<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Datos StructType
 * @subpackage Structs
 */
class Datos extends AbstractStructBase
{
    /**
     * The EstadoInspeccion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstadoInspeccion;
    /**
     * The ResultadoInspeccion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ResultadoInspeccion;
    /**
     * The FechaInspeccion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FechaInspeccion;
    /**
     * The CoberturasAprobadas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString
     */
    public $CoberturasAprobadas;
    /**
     * The CartaDanos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CartaDanos
     */
    public $CartaDanos;
    /**
     * The Patente
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Patente;
    /**
     * The Motor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Motor;
    /**
     * The Chasis
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Chasis;
    /**
     * The Marca
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Marca;
    /**
     * The Modelo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Modelo;
    /**
     * The Ano
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Ano;
    /**
     * The Familia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Familia;
    /**
     * The Sociedad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sociedad;
    /**
     * Constructor method for Datos
     * @uses Datos::setEstadoInspeccion()
     * @uses Datos::setResultadoInspeccion()
     * @uses Datos::setFechaInspeccion()
     * @uses Datos::setCoberturasAprobadas()
     * @uses Datos::setCartaDanos()
     * @uses Datos::setPatente()
     * @uses Datos::setMotor()
     * @uses Datos::setChasis()
     * @uses Datos::setMarca()
     * @uses Datos::setModelo()
     * @uses Datos::setAno()
     * @uses Datos::setFamilia()
     * @uses Datos::setSociedad()
     * @param string $estadoInspeccion
     * @param string $resultadoInspeccion
     * @param string $fechaInspeccion
     * @param \ArrayType\ArrayOfString $coberturasAprobadas
     * @param \StructType\CartaDanos $cartaDanos
     * @param string $patente
     * @param string $motor
     * @param string $chasis
     * @param string $marca
     * @param string $modelo
     * @param string $ano
     * @param string $familia
     * @param string $sociedad
     */
    public function __construct($estadoInspeccion = null, $resultadoInspeccion = null, $fechaInspeccion = null, \ArrayType\ArrayOfString $coberturasAprobadas = null, \StructType\CartaDanos $cartaDanos = null, $patente = null, $motor = null, $chasis = null, $marca = null, $modelo = null, $ano = null, $familia = null, $sociedad = null)
    {
        $this
            ->setEstadoInspeccion($estadoInspeccion)
            ->setResultadoInspeccion($resultadoInspeccion)
            ->setFechaInspeccion($fechaInspeccion)
            ->setCoberturasAprobadas($coberturasAprobadas)
            ->setCartaDanos($cartaDanos)
            ->setPatente($patente)
            ->setMotor($motor)
            ->setChasis($chasis)
            ->setMarca($marca)
            ->setModelo($modelo)
            ->setAno($ano)
            ->setFamilia($familia)
            ->setSociedad($sociedad);
    }
    /**
     * Get EstadoInspeccion value
     * @return string|null
     */
    public function getEstadoInspeccion()
    {
        return $this->EstadoInspeccion;
    }
    /**
     * Set EstadoInspeccion value
     * @param string $estadoInspeccion
     * @return \StructType\Datos
     */
    public function setEstadoInspeccion($estadoInspeccion = null)
    {
        // validation for constraint: string
        if (!is_null($estadoInspeccion) && !is_string($estadoInspeccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoInspeccion, true), gettype($estadoInspeccion)), __LINE__);
        }
        $this->EstadoInspeccion = $estadoInspeccion;
        return $this;
    }
    /**
     * Get ResultadoInspeccion value
     * @return string|null
     */
    public function getResultadoInspeccion()
    {
        return $this->ResultadoInspeccion;
    }
    /**
     * Set ResultadoInspeccion value
     * @param string $resultadoInspeccion
     * @return \StructType\Datos
     */
    public function setResultadoInspeccion($resultadoInspeccion = null)
    {
        // validation for constraint: string
        if (!is_null($resultadoInspeccion) && !is_string($resultadoInspeccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultadoInspeccion, true), gettype($resultadoInspeccion)), __LINE__);
        }
        $this->ResultadoInspeccion = $resultadoInspeccion;
        return $this;
    }
    /**
     * Get FechaInspeccion value
     * @return string|null
     */
    public function getFechaInspeccion()
    {
        return $this->FechaInspeccion;
    }
    /**
     * Set FechaInspeccion value
     * @param string $fechaInspeccion
     * @return \StructType\Datos
     */
    public function setFechaInspeccion($fechaInspeccion = null)
    {
        // validation for constraint: string
        if (!is_null($fechaInspeccion) && !is_string($fechaInspeccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaInspeccion, true), gettype($fechaInspeccion)), __LINE__);
        }
        $this->FechaInspeccion = $fechaInspeccion;
        return $this;
    }
    /**
     * Get CoberturasAprobadas value
     * @return \ArrayType\ArrayOfString|null
     */
    public function getCoberturasAprobadas()
    {
        return $this->CoberturasAprobadas;
    }
    /**
     * Set CoberturasAprobadas value
     * @param \ArrayType\ArrayOfString $coberturasAprobadas
     * @return \StructType\Datos
     */
    public function setCoberturasAprobadas(\ArrayType\ArrayOfString $coberturasAprobadas = null)
    {
        $this->CoberturasAprobadas = $coberturasAprobadas;
        return $this;
    }
    /**
     * Get CartaDanos value
     * @return \StructType\CartaDanos|null
     */
    public function getCartaDanos()
    {
        return $this->CartaDanos;
    }
    /**
     * Set CartaDanos value
     * @param \StructType\CartaDanos $cartaDanos
     * @return \StructType\Datos
     */
    public function setCartaDanos(\StructType\CartaDanos $cartaDanos = null)
    {
        $this->CartaDanos = $cartaDanos;
        return $this;
    }
    /**
     * Get Patente value
     * @return string|null
     */
    public function getPatente()
    {
        return $this->Patente;
    }
    /**
     * Set Patente value
     * @param string $patente
     * @return \StructType\Datos
     */
    public function setPatente($patente = null)
    {
        // validation for constraint: string
        if (!is_null($patente) && !is_string($patente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patente, true), gettype($patente)), __LINE__);
        }
        $this->Patente = $patente;
        return $this;
    }
    /**
     * Get Motor value
     * @return string|null
     */
    public function getMotor()
    {
        return $this->Motor;
    }
    /**
     * Set Motor value
     * @param string $motor
     * @return \StructType\Datos
     */
    public function setMotor($motor = null)
    {
        // validation for constraint: string
        if (!is_null($motor) && !is_string($motor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motor, true), gettype($motor)), __LINE__);
        }
        $this->Motor = $motor;
        return $this;
    }
    /**
     * Get Chasis value
     * @return string|null
     */
    public function getChasis()
    {
        return $this->Chasis;
    }
    /**
     * Set Chasis value
     * @param string $chasis
     * @return \StructType\Datos
     */
    public function setChasis($chasis = null)
    {
        // validation for constraint: string
        if (!is_null($chasis) && !is_string($chasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chasis, true), gettype($chasis)), __LINE__);
        }
        $this->Chasis = $chasis;
        return $this;
    }
    /**
     * Get Marca value
     * @return string|null
     */
    public function getMarca()
    {
        return $this->Marca;
    }
    /**
     * Set Marca value
     * @param string $marca
     * @return \StructType\Datos
     */
    public function setMarca($marca = null)
    {
        // validation for constraint: string
        if (!is_null($marca) && !is_string($marca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marca, true), gettype($marca)), __LINE__);
        }
        $this->Marca = $marca;
        return $this;
    }
    /**
     * Get Modelo value
     * @return string|null
     */
    public function getModelo()
    {
        return $this->Modelo;
    }
    /**
     * Set Modelo value
     * @param string $modelo
     * @return \StructType\Datos
     */
    public function setModelo($modelo = null)
    {
        // validation for constraint: string
        if (!is_null($modelo) && !is_string($modelo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modelo, true), gettype($modelo)), __LINE__);
        }
        $this->Modelo = $modelo;
        return $this;
    }
    /**
     * Get Ano value
     * @return string|null
     */
    public function getAno()
    {
        return $this->Ano;
    }
    /**
     * Set Ano value
     * @param string $ano
     * @return \StructType\Datos
     */
    public function setAno($ano = null)
    {
        // validation for constraint: string
        if (!is_null($ano) && !is_string($ano)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ano, true), gettype($ano)), __LINE__);
        }
        $this->Ano = $ano;
        return $this;
    }
    /**
     * Get Familia value
     * @return string|null
     */
    public function getFamilia()
    {
        return $this->Familia;
    }
    /**
     * Set Familia value
     * @param string $familia
     * @return \StructType\Datos
     */
    public function setFamilia($familia = null)
    {
        // validation for constraint: string
        if (!is_null($familia) && !is_string($familia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($familia, true), gettype($familia)), __LINE__);
        }
        $this->Familia = $familia;
        return $this;
    }
    /**
     * Get Sociedad value
     * @return string|null
     */
    public function getSociedad()
    {
        return $this->Sociedad;
    }
    /**
     * Set Sociedad value
     * @param string $sociedad
     * @return \StructType\Datos
     */
    public function setSociedad($sociedad = null)
    {
        // validation for constraint: string
        if (!is_null($sociedad) && !is_string($sociedad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sociedad, true), gettype($sociedad)), __LINE__);
        }
        $this->Sociedad = $sociedad;
        return $this;
    }
}
