<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Agro ServiceType
 * @subpackage Services
 */
class Agro extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AgroConsultarOrden
     * Meta information extracted from the WSDL
     * - documentation: Realiza una consulta del estado de una orden de Agro | Realiza una consulta del estado de una orden de Agro | Realiza una consulta del estado de una orden de Agro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AgroConsultarOrden $parameters
     * @return \StructType\AgroConsultarOrdenResponse|bool
     */
    public function AgroConsultarOrden(\StructType\AgroConsultarOrden $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AgroConsultarOrden($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AgroCotizar
     * Meta information extracted from the WSDL
     * - documentation: Realiza una Cotización y Guardado de una o varias ordenes de Agro | Realiza una Cotización y Guardado de una o varias ordenes de Agro | Realiza una Cotización y Guardado de una o varias ordenes de Agro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AgroCotizar $parameters
     * @return \StructType\AgroCotizarResponse|bool
     */
    public function AgroCotizar(\StructType\AgroCotizar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AgroCotizar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AgroGuardarCotizacion
     * Meta information extracted from the WSDL
     * - documentation: Realiza una Cotización y Guardado de una o varias ordenes de Agro | Realiza una Cotización y Guardado de una o varias ordenes de Agro | Realiza una Cotización y Guardado de una o varias ordenes de Agro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AgroGuardarCotizacion $parameters
     * @return \StructType\AgroGuardarCotizacionResponse|bool
     */
    public function AgroGuardarCotizacion(\StructType\AgroGuardarCotizacion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->AgroGuardarCotizacion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AgroConsultarOrdenResponse|\StructType\AgroCotizarResponse|\StructType\AgroGuardarCotizacionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
