<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ingreso ServiceType
 * @subpackage Services
 */
class Ingreso extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IngresoDeDenuncia
     * Meta information extracted from the WSDL
     * - documentation: Permite ingresar denuncias en los riesgos de Automotores, Hogar, Comercio y Accidentes Personales.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IngresoDeDenuncia $parameters
     * @return \StructType\IngresoDeDenunciaResponse|bool
     */
    public function IngresoDeDenuncia(\StructType\IngresoDeDenuncia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IngresoDeDenuncia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IngresoDeDenunciaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
