<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ImprimirDocumentacion StructType
 * @subpackage Structs
 */
class ImprimirDocumentacion extends AbstractStructBase
{
    /**
     * The SociedadID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SociedadID;
    /**
     * The TipoIdentificador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TipoIdentificador;
    /**
     * The TipoDocumento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TipoDocumento;
    /**
     * The Item
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Item;
    /**
     * The pUsuario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pUsuario;
    /**
     * The pPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pPassword;
    /**
     * The pUsuarioAec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pUsuarioAec;
    /**
     * The pPasswordAec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pPasswordAec;
    /**
     * The datosImpresion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ImprimirDocumentacion
     */
    public $datosImpresion;
    /**
     * The pIdTransaccionExterno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pIdTransaccionExterno;
    /**
     * The NumeroIdentificador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroIdentificador;
    /**
     * The PrefijoIdentificador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrefijoIdentificador;
    /**
     * The NumeroEndoso
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroEndoso;
    /**
     * Constructor method for ImprimirDocumentacion
     * @uses ImprimirDocumentacion::setSociedadID()
     * @uses ImprimirDocumentacion::setTipoIdentificador()
     * @uses ImprimirDocumentacion::setTipoDocumento()
     * @uses ImprimirDocumentacion::setItem()
     * @uses ImprimirDocumentacion::setPUsuario()
     * @uses ImprimirDocumentacion::setPPassword()
     * @uses ImprimirDocumentacion::setPUsuarioAec()
     * @uses ImprimirDocumentacion::setPPasswordAec()
     * @uses ImprimirDocumentacion::setDatosImpresion()
     * @uses ImprimirDocumentacion::setPIdTransaccionExterno()
     * @uses ImprimirDocumentacion::setNumeroIdentificador()
     * @uses ImprimirDocumentacion::setPrefijoIdentificador()
     * @uses ImprimirDocumentacion::setNumeroEndoso()
     * @param int $sociedadID
     * @param string $tipoIdentificador
     * @param string $tipoDocumento
     * @param int $item
     * @param string $pUsuario
     * @param string $pPassword
     * @param string $pUsuarioAec
     * @param string $pPasswordAec
     * @param \StructType\ImprimirDocumentacion $datosImpresion
     * @param string $pIdTransaccionExterno
     * @param string $numeroIdentificador
     * @param string $prefijoIdentificador
     * @param string $numeroEndoso
     */
    public function __construct($sociedadID = null, $tipoIdentificador = null, $tipoDocumento = null, $item = null, $pUsuario = null, $pPassword = null, $pUsuarioAec = null, $pPasswordAec = null, \StructType\ImprimirDocumentacion $datosImpresion = null, $pIdTransaccionExterno = null, $numeroIdentificador = null, $prefijoIdentificador = null, $numeroEndoso = null)
    {
        $this
            ->setSociedadID($sociedadID)
            ->setTipoIdentificador($tipoIdentificador)
            ->setTipoDocumento($tipoDocumento)
            ->setItem($item)
            ->setPUsuario($pUsuario)
            ->setPPassword($pPassword)
            ->setPUsuarioAec($pUsuarioAec)
            ->setPPasswordAec($pPasswordAec)
            ->setDatosImpresion($datosImpresion)
            ->setPIdTransaccionExterno($pIdTransaccionExterno)
            ->setNumeroIdentificador($numeroIdentificador)
            ->setPrefijoIdentificador($prefijoIdentificador)
            ->setNumeroEndoso($numeroEndoso);
    }
    /**
     * Get SociedadID value
     * @return int
     */
    public function getSociedadID()
    {
        return $this->SociedadID;
    }
    /**
     * Set SociedadID value
     * @param int $sociedadID
     * @return \StructType\ImprimirDocumentacion
     */
    public function setSociedadID($sociedadID = null)
    {
        // validation for constraint: int
        if (!is_null($sociedadID) && !(is_int($sociedadID) || ctype_digit($sociedadID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sociedadID, true), gettype($sociedadID)), __LINE__);
        }
        $this->SociedadID = $sociedadID;
        return $this;
    }
    /**
     * Get TipoIdentificador value
     * @return string
     */
    public function getTipoIdentificador()
    {
        return $this->TipoIdentificador;
    }
    /**
     * Set TipoIdentificador value
     * @uses \EnumType\DatosABuscar::valueIsValid()
     * @uses \EnumType\DatosABuscar::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoIdentificador
     * @return \StructType\ImprimirDocumentacion
     */
    public function setTipoIdentificador($tipoIdentificador = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DatosABuscar::valueIsValid($tipoIdentificador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DatosABuscar', is_array($tipoIdentificador) ? implode(', ', $tipoIdentificador) : var_export($tipoIdentificador, true), implode(', ', \EnumType\DatosABuscar::getValidValues())), __LINE__);
        }
        $this->TipoIdentificador = $tipoIdentificador;
        return $this;
    }
    /**
     * Get TipoDocumento value
     * @return string
     */
    public function getTipoDocumento()
    {
        return $this->TipoDocumento;
    }
    /**
     * Set TipoDocumento value
     * @uses \EnumType\TipoDeDocumento::valueIsValid()
     * @uses \EnumType\TipoDeDocumento::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoDocumento
     * @return \StructType\ImprimirDocumentacion
     */
    public function setTipoDocumento($tipoDocumento = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoDeDocumento::valueIsValid($tipoDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoDeDocumento', is_array($tipoDocumento) ? implode(', ', $tipoDocumento) : var_export($tipoDocumento, true), implode(', ', \EnumType\TipoDeDocumento::getValidValues())), __LINE__);
        }
        $this->TipoDocumento = $tipoDocumento;
        return $this;
    }
    /**
     * Get Item value
     * @return int
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param int $item
     * @return \StructType\ImprimirDocumentacion
     */
    public function setItem($item = null)
    {
        // validation for constraint: int
        if (!is_null($item) && !(is_int($item) || ctype_digit($item))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($item, true), gettype($item)), __LINE__);
        }
        $this->Item = $item;
        return $this;
    }
    /**
     * Get pUsuario value
     * @return string|null
     */
    public function getPUsuario()
    {
        return $this->pUsuario;
    }
    /**
     * Set pUsuario value
     * @param string $pUsuario
     * @return \StructType\ImprimirDocumentacion
     */
    public function setPUsuario($pUsuario = null)
    {
        // validation for constraint: string
        if (!is_null($pUsuario) && !is_string($pUsuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pUsuario, true), gettype($pUsuario)), __LINE__);
        }
        $this->pUsuario = $pUsuario;
        return $this;
    }
    /**
     * Get pPassword value
     * @return string|null
     */
    public function getPPassword()
    {
        return $this->pPassword;
    }
    /**
     * Set pPassword value
     * @param string $pPassword
     * @return \StructType\ImprimirDocumentacion
     */
    public function setPPassword($pPassword = null)
    {
        // validation for constraint: string
        if (!is_null($pPassword) && !is_string($pPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pPassword, true), gettype($pPassword)), __LINE__);
        }
        $this->pPassword = $pPassword;
        return $this;
    }
    /**
     * Get pUsuarioAec value
     * @return string|null
     */
    public function getPUsuarioAec()
    {
        return $this->pUsuarioAec;
    }
    /**
     * Set pUsuarioAec value
     * @param string $pUsuarioAec
     * @return \StructType\ImprimirDocumentacion
     */
    public function setPUsuarioAec($pUsuarioAec = null)
    {
        // validation for constraint: string
        if (!is_null($pUsuarioAec) && !is_string($pUsuarioAec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pUsuarioAec, true), gettype($pUsuarioAec)), __LINE__);
        }
        $this->pUsuarioAec = $pUsuarioAec;
        return $this;
    }
    /**
     * Get pPasswordAec value
     * @return string|null
     */
    public function getPPasswordAec()
    {
        return $this->pPasswordAec;
    }
    /**
     * Set pPasswordAec value
     * @param string $pPasswordAec
     * @return \StructType\ImprimirDocumentacion
     */
    public function setPPasswordAec($pPasswordAec = null)
    {
        // validation for constraint: string
        if (!is_null($pPasswordAec) && !is_string($pPasswordAec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pPasswordAec, true), gettype($pPasswordAec)), __LINE__);
        }
        $this->pPasswordAec = $pPasswordAec;
        return $this;
    }
    /**
     * Get datosImpresion value
     * @return \StructType\ImprimirDocumentacion|null
     */
    public function getDatosImpresion()
    {
        return $this->datosImpresion;
    }
    /**
     * Set datosImpresion value
     * @param \StructType\ImprimirDocumentacion $datosImpresion
     * @return \StructType\ImprimirDocumentacion
     */
    public function setDatosImpresion(\StructType\ImprimirDocumentacion $datosImpresion = null)
    {
        $this->datosImpresion = $datosImpresion;
        return $this;
    }
    /**
     * Get pIdTransaccionExterno value
     * @return string|null
     */
    public function getPIdTransaccionExterno()
    {
        return $this->pIdTransaccionExterno;
    }
    /**
     * Set pIdTransaccionExterno value
     * @param string $pIdTransaccionExterno
     * @return \StructType\ImprimirDocumentacion
     */
    public function setPIdTransaccionExterno($pIdTransaccionExterno = null)
    {
        // validation for constraint: string
        if (!is_null($pIdTransaccionExterno) && !is_string($pIdTransaccionExterno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIdTransaccionExterno, true), gettype($pIdTransaccionExterno)), __LINE__);
        }
        $this->pIdTransaccionExterno = $pIdTransaccionExterno;
        return $this;
    }
    /**
     * Get NumeroIdentificador value
     * @return string|null
     */
    public function getNumeroIdentificador()
    {
        return $this->NumeroIdentificador;
    }
    /**
     * Set NumeroIdentificador value
     * @param string $numeroIdentificador
     * @return \StructType\ImprimirDocumentacion
     */
    public function setNumeroIdentificador($numeroIdentificador = null)
    {
        // validation for constraint: string
        if (!is_null($numeroIdentificador) && !is_string($numeroIdentificador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroIdentificador, true), gettype($numeroIdentificador)), __LINE__);
        }
        $this->NumeroIdentificador = $numeroIdentificador;
        return $this;
    }
    /**
     * Get PrefijoIdentificador value
     * @return string|null
     */
    public function getPrefijoIdentificador()
    {
        return $this->PrefijoIdentificador;
    }
    /**
     * Set PrefijoIdentificador value
     * @param string $prefijoIdentificador
     * @return \StructType\ImprimirDocumentacion
     */
    public function setPrefijoIdentificador($prefijoIdentificador = null)
    {
        // validation for constraint: string
        if (!is_null($prefijoIdentificador) && !is_string($prefijoIdentificador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefijoIdentificador, true), gettype($prefijoIdentificador)), __LINE__);
        }
        $this->PrefijoIdentificador = $prefijoIdentificador;
        return $this;
    }
    /**
     * Get NumeroEndoso value
     * @return string|null
     */
    public function getNumeroEndoso()
    {
        return $this->NumeroEndoso;
    }
    /**
     * Set NumeroEndoso value
     * @param string $numeroEndoso
     * @return \StructType\ImprimirDocumentacion
     */
    public function setNumeroEndoso($numeroEndoso = null)
    {
        // validation for constraint: string
        if (!is_null($numeroEndoso) && !is_string($numeroEndoso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroEndoso, true), gettype($numeroEndoso)), __LINE__);
        }
        $this->NumeroEndoso = $numeroEndoso;
        return $this;
    }
}
