<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocCanalINEmisionRoboOrden StructType
 * @subpackage Structs
 */
class DocCanalINEmisionRoboOrden extends AbstractStructBase
{
    /**
     * The OrdenID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrdenID;
    /**
     * The FamiliaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FamiliaID;
    /**
     * The SociedadID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SociedadID;
    /**
     * The PlanID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PlanID;
    /**
     * The EsRenovacion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $EsRenovacion;
    /**
     * The Comision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Comision;
    /**
     * The BonificacionComercial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BonificacionComercial;
    /**
     * The BonificacionViacobro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BonificacionViacobro;
    /**
     * The FechaVigenciaDesde
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FechaVigenciaDesde;
    /**
     * The FechaVigenciaHasta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FechaVigenciaHasta;
    /**
     * The DistribucionComisionOrganizador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistribucionComisionOrganizador;
    /**
     * The DistribucionComisionProductor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistribucionComisionProductor;
    /**
     * The AniosSinSiniestro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AniosSinSiniestro;
    /**
     * The AjusteSuma
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AjusteSuma;
    /**
     * The RecibePolizaElectronica
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RecibePolizaElectronica;
    /**
     * The RecibeDocumentacionElectronica
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RecibeDocumentacionElectronica;
    /**
     * The IDRiesgo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDRiesgo;
    /**
     * The IDTipoPoliza
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoPoliza;
    /**
     * The IDTipoPersona
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoPersona;
    /**
     * The IDCondicionIVA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDCondicionIVA;
    /**
     * The NroPolizaAnterior
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NroPolizaAnterior;
    /**
     * The IDPersonaAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPersonaAsegurado;
    /**
     * The IDPersonaTomador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPersonaTomador;
    /**
     * The IDViaCobro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDViaCobro;
    /**
     * The IDInstitucionFinanciera
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDInstitucionFinanciera;
    /**
     * The IDPlanPago
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPlanPago;
    /**
     * The IDProducto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProducto;
    /**
     * The IDSegmento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDSegmento;
    /**
     * The NumeroTarjeta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroTarjeta;
    /**
     * The TipoPlanID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoPlanID;
    /**
     * The Mail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mail;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalINEmisionRoboItem
     */
    public $Items;
    /**
     * The Canales
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalINEmisionRoboOrdenCanal
     */
    public $Canales;
    /**
     * The PersonaCanal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalINEmisionRoboPersonaCanal
     */
    public $PersonaCanal;
    /**
     * Constructor method for DocCanalINEmisionRoboOrden
     * @uses DocCanalINEmisionRoboOrden::setOrdenID()
     * @uses DocCanalINEmisionRoboOrden::setFamiliaID()
     * @uses DocCanalINEmisionRoboOrden::setSociedadID()
     * @uses DocCanalINEmisionRoboOrden::setPlanID()
     * @uses DocCanalINEmisionRoboOrden::setEsRenovacion()
     * @uses DocCanalINEmisionRoboOrden::setComision()
     * @uses DocCanalINEmisionRoboOrden::setBonificacionComercial()
     * @uses DocCanalINEmisionRoboOrden::setBonificacionViacobro()
     * @uses DocCanalINEmisionRoboOrden::setFechaVigenciaDesde()
     * @uses DocCanalINEmisionRoboOrden::setFechaVigenciaHasta()
     * @uses DocCanalINEmisionRoboOrden::setDistribucionComisionOrganizador()
     * @uses DocCanalINEmisionRoboOrden::setDistribucionComisionProductor()
     * @uses DocCanalINEmisionRoboOrden::setAniosSinSiniestro()
     * @uses DocCanalINEmisionRoboOrden::setAjusteSuma()
     * @uses DocCanalINEmisionRoboOrden::setRecibePolizaElectronica()
     * @uses DocCanalINEmisionRoboOrden::setRecibeDocumentacionElectronica()
     * @uses DocCanalINEmisionRoboOrden::setIDRiesgo()
     * @uses DocCanalINEmisionRoboOrden::setIDTipoPoliza()
     * @uses DocCanalINEmisionRoboOrden::setIDTipoPersona()
     * @uses DocCanalINEmisionRoboOrden::setIDCondicionIVA()
     * @uses DocCanalINEmisionRoboOrden::setNroPolizaAnterior()
     * @uses DocCanalINEmisionRoboOrden::setIDPersonaAsegurado()
     * @uses DocCanalINEmisionRoboOrden::setIDPersonaTomador()
     * @uses DocCanalINEmisionRoboOrden::setIDViaCobro()
     * @uses DocCanalINEmisionRoboOrden::setIDInstitucionFinanciera()
     * @uses DocCanalINEmisionRoboOrden::setIDPlanPago()
     * @uses DocCanalINEmisionRoboOrden::setIDProducto()
     * @uses DocCanalINEmisionRoboOrden::setIDSegmento()
     * @uses DocCanalINEmisionRoboOrden::setNumeroTarjeta()
     * @uses DocCanalINEmisionRoboOrden::setTipoPlanID()
     * @uses DocCanalINEmisionRoboOrden::setMail()
     * @uses DocCanalINEmisionRoboOrden::setItems()
     * @uses DocCanalINEmisionRoboOrden::setCanales()
     * @uses DocCanalINEmisionRoboOrden::setPersonaCanal()
     * @param int $ordenID
     * @param int $familiaID
     * @param int $sociedadID
     * @param int $planID
     * @param bool $esRenovacion
     * @param float $comision
     * @param float $bonificacionComercial
     * @param float $bonificacionViacobro
     * @param string $fechaVigenciaDesde
     * @param string $fechaVigenciaHasta
     * @param float $distribucionComisionOrganizador
     * @param float $distribucionComisionProductor
     * @param int $aniosSinSiniestro
     * @param int $ajusteSuma
     * @param bool $recibePolizaElectronica
     * @param bool $recibeDocumentacionElectronica
     * @param string $iDRiesgo
     * @param string $iDTipoPoliza
     * @param string $iDTipoPersona
     * @param string $iDCondicionIVA
     * @param string $nroPolizaAnterior
     * @param string $iDPersonaAsegurado
     * @param string $iDPersonaTomador
     * @param string $iDViaCobro
     * @param string $iDInstitucionFinanciera
     * @param string $iDPlanPago
     * @param string $iDProducto
     * @param string $iDSegmento
     * @param string $numeroTarjeta
     * @param string $tipoPlanID
     * @param string $mail
     * @param \ArrayType\ArrayOfDocCanalINEmisionRoboItem $items
     * @param \ArrayType\ArrayOfDocCanalINEmisionRoboOrdenCanal $canales
     * @param \ArrayType\ArrayOfDocCanalINEmisionRoboPersonaCanal $personaCanal
     */
    public function __construct($ordenID = null, $familiaID = null, $sociedadID = null, $planID = null, $esRenovacion = null, $comision = null, $bonificacionComercial = null, $bonificacionViacobro = null, $fechaVigenciaDesde = null, $fechaVigenciaHasta = null, $distribucionComisionOrganizador = null, $distribucionComisionProductor = null, $aniosSinSiniestro = null, $ajusteSuma = null, $recibePolizaElectronica = null, $recibeDocumentacionElectronica = null, $iDRiesgo = null, $iDTipoPoliza = null, $iDTipoPersona = null, $iDCondicionIVA = null, $nroPolizaAnterior = null, $iDPersonaAsegurado = null, $iDPersonaTomador = null, $iDViaCobro = null, $iDInstitucionFinanciera = null, $iDPlanPago = null, $iDProducto = null, $iDSegmento = null, $numeroTarjeta = null, $tipoPlanID = null, $mail = null, \ArrayType\ArrayOfDocCanalINEmisionRoboItem $items = null, \ArrayType\ArrayOfDocCanalINEmisionRoboOrdenCanal $canales = null, \ArrayType\ArrayOfDocCanalINEmisionRoboPersonaCanal $personaCanal = null)
    {
        $this
            ->setOrdenID($ordenID)
            ->setFamiliaID($familiaID)
            ->setSociedadID($sociedadID)
            ->setPlanID($planID)
            ->setEsRenovacion($esRenovacion)
            ->setComision($comision)
            ->setBonificacionComercial($bonificacionComercial)
            ->setBonificacionViacobro($bonificacionViacobro)
            ->setFechaVigenciaDesde($fechaVigenciaDesde)
            ->setFechaVigenciaHasta($fechaVigenciaHasta)
            ->setDistribucionComisionOrganizador($distribucionComisionOrganizador)
            ->setDistribucionComisionProductor($distribucionComisionProductor)
            ->setAniosSinSiniestro($aniosSinSiniestro)
            ->setAjusteSuma($ajusteSuma)
            ->setRecibePolizaElectronica($recibePolizaElectronica)
            ->setRecibeDocumentacionElectronica($recibeDocumentacionElectronica)
            ->setIDRiesgo($iDRiesgo)
            ->setIDTipoPoliza($iDTipoPoliza)
            ->setIDTipoPersona($iDTipoPersona)
            ->setIDCondicionIVA($iDCondicionIVA)
            ->setNroPolizaAnterior($nroPolizaAnterior)
            ->setIDPersonaAsegurado($iDPersonaAsegurado)
            ->setIDPersonaTomador($iDPersonaTomador)
            ->setIDViaCobro($iDViaCobro)
            ->setIDInstitucionFinanciera($iDInstitucionFinanciera)
            ->setIDPlanPago($iDPlanPago)
            ->setIDProducto($iDProducto)
            ->setIDSegmento($iDSegmento)
            ->setNumeroTarjeta($numeroTarjeta)
            ->setTipoPlanID($tipoPlanID)
            ->setMail($mail)
            ->setItems($items)
            ->setCanales($canales)
            ->setPersonaCanal($personaCanal);
    }
    /**
     * Get OrdenID value
     * @return int
     */
    public function getOrdenID()
    {
        return $this->OrdenID;
    }
    /**
     * Set OrdenID value
     * @param int $ordenID
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setOrdenID($ordenID = null)
    {
        // validation for constraint: int
        if (!is_null($ordenID) && !(is_int($ordenID) || ctype_digit($ordenID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordenID, true), gettype($ordenID)), __LINE__);
        }
        $this->OrdenID = $ordenID;
        return $this;
    }
    /**
     * Get FamiliaID value
     * @return int
     */
    public function getFamiliaID()
    {
        return $this->FamiliaID;
    }
    /**
     * Set FamiliaID value
     * @param int $familiaID
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setFamiliaID($familiaID = null)
    {
        // validation for constraint: int
        if (!is_null($familiaID) && !(is_int($familiaID) || ctype_digit($familiaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($familiaID, true), gettype($familiaID)), __LINE__);
        }
        $this->FamiliaID = $familiaID;
        return $this;
    }
    /**
     * Get SociedadID value
     * @return int
     */
    public function getSociedadID()
    {
        return $this->SociedadID;
    }
    /**
     * Set SociedadID value
     * @param int $sociedadID
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setSociedadID($sociedadID = null)
    {
        // validation for constraint: int
        if (!is_null($sociedadID) && !(is_int($sociedadID) || ctype_digit($sociedadID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sociedadID, true), gettype($sociedadID)), __LINE__);
        }
        $this->SociedadID = $sociedadID;
        return $this;
    }
    /**
     * Get PlanID value
     * @return int
     */
    public function getPlanID()
    {
        return $this->PlanID;
    }
    /**
     * Set PlanID value
     * @param int $planID
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setPlanID($planID = null)
    {
        // validation for constraint: int
        if (!is_null($planID) && !(is_int($planID) || ctype_digit($planID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($planID, true), gettype($planID)), __LINE__);
        }
        $this->PlanID = $planID;
        return $this;
    }
    /**
     * Get EsRenovacion value
     * @return bool
     */
    public function getEsRenovacion()
    {
        return $this->EsRenovacion;
    }
    /**
     * Set EsRenovacion value
     * @param bool $esRenovacion
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setEsRenovacion($esRenovacion = null)
    {
        // validation for constraint: boolean
        if (!is_null($esRenovacion) && !is_bool($esRenovacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($esRenovacion, true), gettype($esRenovacion)), __LINE__);
        }
        $this->EsRenovacion = $esRenovacion;
        return $this;
    }
    /**
     * Get Comision value
     * @return float
     */
    public function getComision()
    {
        return $this->Comision;
    }
    /**
     * Set Comision value
     * @param float $comision
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setComision($comision = null)
    {
        // validation for constraint: float
        if (!is_null($comision) && !(is_float($comision) || is_numeric($comision))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($comision, true), gettype($comision)), __LINE__);
        }
        $this->Comision = $comision;
        return $this;
    }
    /**
     * Get BonificacionComercial value
     * @return float
     */
    public function getBonificacionComercial()
    {
        return $this->BonificacionComercial;
    }
    /**
     * Set BonificacionComercial value
     * @param float $bonificacionComercial
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setBonificacionComercial($bonificacionComercial = null)
    {
        // validation for constraint: float
        if (!is_null($bonificacionComercial) && !(is_float($bonificacionComercial) || is_numeric($bonificacionComercial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonificacionComercial, true), gettype($bonificacionComercial)), __LINE__);
        }
        $this->BonificacionComercial = $bonificacionComercial;
        return $this;
    }
    /**
     * Get BonificacionViacobro value
     * @return float
     */
    public function getBonificacionViacobro()
    {
        return $this->BonificacionViacobro;
    }
    /**
     * Set BonificacionViacobro value
     * @param float $bonificacionViacobro
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setBonificacionViacobro($bonificacionViacobro = null)
    {
        // validation for constraint: float
        if (!is_null($bonificacionViacobro) && !(is_float($bonificacionViacobro) || is_numeric($bonificacionViacobro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonificacionViacobro, true), gettype($bonificacionViacobro)), __LINE__);
        }
        $this->BonificacionViacobro = $bonificacionViacobro;
        return $this;
    }
    /**
     * Get FechaVigenciaDesde value
     * @return string
     */
    public function getFechaVigenciaDesde()
    {
        return $this->FechaVigenciaDesde;
    }
    /**
     * Set FechaVigenciaDesde value
     * @param string $fechaVigenciaDesde
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setFechaVigenciaDesde($fechaVigenciaDesde = null)
    {
        // validation for constraint: string
        if (!is_null($fechaVigenciaDesde) && !is_string($fechaVigenciaDesde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaVigenciaDesde, true), gettype($fechaVigenciaDesde)), __LINE__);
        }
        $this->FechaVigenciaDesde = $fechaVigenciaDesde;
        return $this;
    }
    /**
     * Get FechaVigenciaHasta value
     * @return string
     */
    public function getFechaVigenciaHasta()
    {
        return $this->FechaVigenciaHasta;
    }
    /**
     * Set FechaVigenciaHasta value
     * @param string $fechaVigenciaHasta
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setFechaVigenciaHasta($fechaVigenciaHasta = null)
    {
        // validation for constraint: string
        if (!is_null($fechaVigenciaHasta) && !is_string($fechaVigenciaHasta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaVigenciaHasta, true), gettype($fechaVigenciaHasta)), __LINE__);
        }
        $this->FechaVigenciaHasta = $fechaVigenciaHasta;
        return $this;
    }
    /**
     * Get DistribucionComisionOrganizador value
     * @return float
     */
    public function getDistribucionComisionOrganizador()
    {
        return $this->DistribucionComisionOrganizador;
    }
    /**
     * Set DistribucionComisionOrganizador value
     * @param float $distribucionComisionOrganizador
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setDistribucionComisionOrganizador($distribucionComisionOrganizador = null)
    {
        // validation for constraint: float
        if (!is_null($distribucionComisionOrganizador) && !(is_float($distribucionComisionOrganizador) || is_numeric($distribucionComisionOrganizador))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distribucionComisionOrganizador, true), gettype($distribucionComisionOrganizador)), __LINE__);
        }
        $this->DistribucionComisionOrganizador = $distribucionComisionOrganizador;
        return $this;
    }
    /**
     * Get DistribucionComisionProductor value
     * @return float
     */
    public function getDistribucionComisionProductor()
    {
        return $this->DistribucionComisionProductor;
    }
    /**
     * Set DistribucionComisionProductor value
     * @param float $distribucionComisionProductor
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setDistribucionComisionProductor($distribucionComisionProductor = null)
    {
        // validation for constraint: float
        if (!is_null($distribucionComisionProductor) && !(is_float($distribucionComisionProductor) || is_numeric($distribucionComisionProductor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distribucionComisionProductor, true), gettype($distribucionComisionProductor)), __LINE__);
        }
        $this->DistribucionComisionProductor = $distribucionComisionProductor;
        return $this;
    }
    /**
     * Get AniosSinSiniestro value
     * @return int
     */
    public function getAniosSinSiniestro()
    {
        return $this->AniosSinSiniestro;
    }
    /**
     * Set AniosSinSiniestro value
     * @param int $aniosSinSiniestro
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setAniosSinSiniestro($aniosSinSiniestro = null)
    {
        // validation for constraint: int
        if (!is_null($aniosSinSiniestro) && !(is_int($aniosSinSiniestro) || ctype_digit($aniosSinSiniestro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aniosSinSiniestro, true), gettype($aniosSinSiniestro)), __LINE__);
        }
        $this->AniosSinSiniestro = $aniosSinSiniestro;
        return $this;
    }
    /**
     * Get AjusteSuma value
     * @return int
     */
    public function getAjusteSuma()
    {
        return $this->AjusteSuma;
    }
    /**
     * Set AjusteSuma value
     * @param int $ajusteSuma
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setAjusteSuma($ajusteSuma = null)
    {
        // validation for constraint: int
        if (!is_null($ajusteSuma) && !(is_int($ajusteSuma) || ctype_digit($ajusteSuma))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ajusteSuma, true), gettype($ajusteSuma)), __LINE__);
        }
        $this->AjusteSuma = $ajusteSuma;
        return $this;
    }
    /**
     * Get RecibePolizaElectronica value
     * @return bool
     */
    public function getRecibePolizaElectronica()
    {
        return $this->RecibePolizaElectronica;
    }
    /**
     * Set RecibePolizaElectronica value
     * @param bool $recibePolizaElectronica
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setRecibePolizaElectronica($recibePolizaElectronica = null)
    {
        // validation for constraint: boolean
        if (!is_null($recibePolizaElectronica) && !is_bool($recibePolizaElectronica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recibePolizaElectronica, true), gettype($recibePolizaElectronica)), __LINE__);
        }
        $this->RecibePolizaElectronica = $recibePolizaElectronica;
        return $this;
    }
    /**
     * Get RecibeDocumentacionElectronica value
     * @return bool
     */
    public function getRecibeDocumentacionElectronica()
    {
        return $this->RecibeDocumentacionElectronica;
    }
    /**
     * Set RecibeDocumentacionElectronica value
     * @param bool $recibeDocumentacionElectronica
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setRecibeDocumentacionElectronica($recibeDocumentacionElectronica = null)
    {
        // validation for constraint: boolean
        if (!is_null($recibeDocumentacionElectronica) && !is_bool($recibeDocumentacionElectronica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recibeDocumentacionElectronica, true), gettype($recibeDocumentacionElectronica)), __LINE__);
        }
        $this->RecibeDocumentacionElectronica = $recibeDocumentacionElectronica;
        return $this;
    }
    /**
     * Get IDRiesgo value
     * @return string|null
     */
    public function getIDRiesgo()
    {
        return $this->IDRiesgo;
    }
    /**
     * Set IDRiesgo value
     * @param string $iDRiesgo
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setIDRiesgo($iDRiesgo = null)
    {
        // validation for constraint: string
        if (!is_null($iDRiesgo) && !is_string($iDRiesgo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDRiesgo, true), gettype($iDRiesgo)), __LINE__);
        }
        $this->IDRiesgo = $iDRiesgo;
        return $this;
    }
    /**
     * Get IDTipoPoliza value
     * @return string|null
     */
    public function getIDTipoPoliza()
    {
        return $this->IDTipoPoliza;
    }
    /**
     * Set IDTipoPoliza value
     * @param string $iDTipoPoliza
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setIDTipoPoliza($iDTipoPoliza = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoPoliza) && !is_string($iDTipoPoliza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoPoliza, true), gettype($iDTipoPoliza)), __LINE__);
        }
        $this->IDTipoPoliza = $iDTipoPoliza;
        return $this;
    }
    /**
     * Get IDTipoPersona value
     * @return string|null
     */
    public function getIDTipoPersona()
    {
        return $this->IDTipoPersona;
    }
    /**
     * Set IDTipoPersona value
     * @param string $iDTipoPersona
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setIDTipoPersona($iDTipoPersona = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoPersona) && !is_string($iDTipoPersona)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoPersona, true), gettype($iDTipoPersona)), __LINE__);
        }
        $this->IDTipoPersona = $iDTipoPersona;
        return $this;
    }
    /**
     * Get IDCondicionIVA value
     * @return string|null
     */
    public function getIDCondicionIVA()
    {
        return $this->IDCondicionIVA;
    }
    /**
     * Set IDCondicionIVA value
     * @param string $iDCondicionIVA
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setIDCondicionIVA($iDCondicionIVA = null)
    {
        // validation for constraint: string
        if (!is_null($iDCondicionIVA) && !is_string($iDCondicionIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDCondicionIVA, true), gettype($iDCondicionIVA)), __LINE__);
        }
        $this->IDCondicionIVA = $iDCondicionIVA;
        return $this;
    }
    /**
     * Get NroPolizaAnterior value
     * @return string|null
     */
    public function getNroPolizaAnterior()
    {
        return $this->NroPolizaAnterior;
    }
    /**
     * Set NroPolizaAnterior value
     * @param string $nroPolizaAnterior
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setNroPolizaAnterior($nroPolizaAnterior = null)
    {
        // validation for constraint: string
        if (!is_null($nroPolizaAnterior) && !is_string($nroPolizaAnterior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nroPolizaAnterior, true), gettype($nroPolizaAnterior)), __LINE__);
        }
        $this->NroPolizaAnterior = $nroPolizaAnterior;
        return $this;
    }
    /**
     * Get IDPersonaAsegurado value
     * @return string|null
     */
    public function getIDPersonaAsegurado()
    {
        return $this->IDPersonaAsegurado;
    }
    /**
     * Set IDPersonaAsegurado value
     * @param string $iDPersonaAsegurado
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setIDPersonaAsegurado($iDPersonaAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($iDPersonaAsegurado) && !is_string($iDPersonaAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPersonaAsegurado, true), gettype($iDPersonaAsegurado)), __LINE__);
        }
        $this->IDPersonaAsegurado = $iDPersonaAsegurado;
        return $this;
    }
    /**
     * Get IDPersonaTomador value
     * @return string|null
     */
    public function getIDPersonaTomador()
    {
        return $this->IDPersonaTomador;
    }
    /**
     * Set IDPersonaTomador value
     * @param string $iDPersonaTomador
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setIDPersonaTomador($iDPersonaTomador = null)
    {
        // validation for constraint: string
        if (!is_null($iDPersonaTomador) && !is_string($iDPersonaTomador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPersonaTomador, true), gettype($iDPersonaTomador)), __LINE__);
        }
        $this->IDPersonaTomador = $iDPersonaTomador;
        return $this;
    }
    /**
     * Get IDViaCobro value
     * @return string|null
     */
    public function getIDViaCobro()
    {
        return $this->IDViaCobro;
    }
    /**
     * Set IDViaCobro value
     * @param string $iDViaCobro
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setIDViaCobro($iDViaCobro = null)
    {
        // validation for constraint: string
        if (!is_null($iDViaCobro) && !is_string($iDViaCobro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDViaCobro, true), gettype($iDViaCobro)), __LINE__);
        }
        $this->IDViaCobro = $iDViaCobro;
        return $this;
    }
    /**
     * Get IDInstitucionFinanciera value
     * @return string|null
     */
    public function getIDInstitucionFinanciera()
    {
        return $this->IDInstitucionFinanciera;
    }
    /**
     * Set IDInstitucionFinanciera value
     * @param string $iDInstitucionFinanciera
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setIDInstitucionFinanciera($iDInstitucionFinanciera = null)
    {
        // validation for constraint: string
        if (!is_null($iDInstitucionFinanciera) && !is_string($iDInstitucionFinanciera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDInstitucionFinanciera, true), gettype($iDInstitucionFinanciera)), __LINE__);
        }
        $this->IDInstitucionFinanciera = $iDInstitucionFinanciera;
        return $this;
    }
    /**
     * Get IDPlanPago value
     * @return string|null
     */
    public function getIDPlanPago()
    {
        return $this->IDPlanPago;
    }
    /**
     * Set IDPlanPago value
     * @param string $iDPlanPago
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setIDPlanPago($iDPlanPago = null)
    {
        // validation for constraint: string
        if (!is_null($iDPlanPago) && !is_string($iDPlanPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPlanPago, true), gettype($iDPlanPago)), __LINE__);
        }
        $this->IDPlanPago = $iDPlanPago;
        return $this;
    }
    /**
     * Get IDProducto value
     * @return string|null
     */
    public function getIDProducto()
    {
        return $this->IDProducto;
    }
    /**
     * Set IDProducto value
     * @param string $iDProducto
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setIDProducto($iDProducto = null)
    {
        // validation for constraint: string
        if (!is_null($iDProducto) && !is_string($iDProducto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProducto, true), gettype($iDProducto)), __LINE__);
        }
        $this->IDProducto = $iDProducto;
        return $this;
    }
    /**
     * Get IDSegmento value
     * @return string|null
     */
    public function getIDSegmento()
    {
        return $this->IDSegmento;
    }
    /**
     * Set IDSegmento value
     * @param string $iDSegmento
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setIDSegmento($iDSegmento = null)
    {
        // validation for constraint: string
        if (!is_null($iDSegmento) && !is_string($iDSegmento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDSegmento, true), gettype($iDSegmento)), __LINE__);
        }
        $this->IDSegmento = $iDSegmento;
        return $this;
    }
    /**
     * Get NumeroTarjeta value
     * @return string|null
     */
    public function getNumeroTarjeta()
    {
        return $this->NumeroTarjeta;
    }
    /**
     * Set NumeroTarjeta value
     * @param string $numeroTarjeta
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setNumeroTarjeta($numeroTarjeta = null)
    {
        // validation for constraint: string
        if (!is_null($numeroTarjeta) && !is_string($numeroTarjeta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroTarjeta, true), gettype($numeroTarjeta)), __LINE__);
        }
        $this->NumeroTarjeta = $numeroTarjeta;
        return $this;
    }
    /**
     * Get TipoPlanID value
     * @return string|null
     */
    public function getTipoPlanID()
    {
        return $this->TipoPlanID;
    }
    /**
     * Set TipoPlanID value
     * @param string $tipoPlanID
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setTipoPlanID($tipoPlanID = null)
    {
        // validation for constraint: string
        if (!is_null($tipoPlanID) && !is_string($tipoPlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoPlanID, true), gettype($tipoPlanID)), __LINE__);
        }
        $this->TipoPlanID = $tipoPlanID;
        return $this;
    }
    /**
     * Get Mail value
     * @return string|null
     */
    public function getMail()
    {
        return $this->Mail;
    }
    /**
     * Set Mail value
     * @param string $mail
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mail, true), gettype($mail)), __LINE__);
        }
        $this->Mail = $mail;
        return $this;
    }
    /**
     * Get Items value
     * @return \ArrayType\ArrayOfDocCanalINEmisionRoboItem|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \ArrayType\ArrayOfDocCanalINEmisionRoboItem $items
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setItems(\ArrayType\ArrayOfDocCanalINEmisionRoboItem $items = null)
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Get Canales value
     * @return \ArrayType\ArrayOfDocCanalINEmisionRoboOrdenCanal|null
     */
    public function getCanales()
    {
        return $this->Canales;
    }
    /**
     * Set Canales value
     * @param \ArrayType\ArrayOfDocCanalINEmisionRoboOrdenCanal $canales
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setCanales(\ArrayType\ArrayOfDocCanalINEmisionRoboOrdenCanal $canales = null)
    {
        $this->Canales = $canales;
        return $this;
    }
    /**
     * Get PersonaCanal value
     * @return \ArrayType\ArrayOfDocCanalINEmisionRoboPersonaCanal|null
     */
    public function getPersonaCanal()
    {
        return $this->PersonaCanal;
    }
    /**
     * Set PersonaCanal value
     * @param \ArrayType\ArrayOfDocCanalINEmisionRoboPersonaCanal $personaCanal
     * @return \StructType\DocCanalINEmisionRoboOrden
     */
    public function setPersonaCanal(\ArrayType\ArrayOfDocCanalINEmisionRoboPersonaCanal $personaCanal = null)
    {
        $this->PersonaCanal = $personaCanal;
        return $this;
    }
}
