<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Grabar ServiceType
 * @subpackage Services
 */
class Grabar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GrabarPresupuesto
     * Meta information extracted from the WSDL
     * - documentation: Grabado de Presupuesto de Motor. Para todos canales
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GrabarPresupuesto $parameters
     * @return \StructType\GrabarPresupuestoResponse|bool
     */
    public function GrabarPresupuesto(\StructType\GrabarPresupuesto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GrabarPresupuesto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GrabarPresupuestoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
