<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TipoDeDocumento EnumType
 * @subpackage Enumerations
 */
class TipoDeDocumento extends AbstractStructEnumBase
{
    /**
     * Constant for value 'FrenteDePoliza'
     * @return string 'FrenteDePoliza'
     */
    const VALUE_FRENTE_DE_POLIZA = 'FrenteDePoliza';
    /**
     * Constant for value 'SolicitudDeSeguro'
     * @return string 'SolicitudDeSeguro'
     */
    const VALUE_SOLICITUD_DE_SEGURO = 'SolicitudDeSeguro';
    /**
     * Constant for value 'Mercosur'
     * @return string 'Mercosur'
     */
    const VALUE_MERCOSUR = 'Mercosur';
    /**
     * Constant for value 'CartaTr01'
     * @return string 'CartaTr01'
     */
    const VALUE_CARTA_TR_01 = 'CartaTr01';
    /**
     * Constant for value 'CartaNoTr01'
     * @return string 'CartaNoTr01'
     */
    const VALUE_CARTA_NO_TR_01 = 'CartaNoTr01';
    /**
     * Constant for value 'TarjetaDeCirculacion'
     * @return string 'TarjetaDeCirculacion'
     */
    const VALUE_TARJETA_DE_CIRCULACION = 'TarjetaDeCirculacion';
    /**
     * Constant for value 'CertificadoDeCobertura'
     * @return string 'CertificadoDeCobertura'
     */
    const VALUE_CERTIFICADO_DE_COBERTURA = 'CertificadoDeCobertura';
    /**
     * Constant for value 'Poliza'
     * @return string 'Poliza'
     */
    const VALUE_POLIZA = 'Poliza';
    /**
     * Constant for value 'Endoso'
     * @return string 'Endoso'
     */
    const VALUE_ENDOSO = 'Endoso';
    /**
     * Constant for value 'Cupon'
     * @return string 'Cupon'
     */
    const VALUE_CUPON = 'Cupon';
    /**
     * Constant for value 'CertificadoDePago'
     * @return string 'CertificadoDePago'
     */
    const VALUE_CERTIFICADO_DE_PAGO = 'CertificadoDePago';
    /**
     * Return allowed values
     * @uses self::VALUE_FRENTE_DE_POLIZA
     * @uses self::VALUE_SOLICITUD_DE_SEGURO
     * @uses self::VALUE_MERCOSUR
     * @uses self::VALUE_CARTA_TR_01
     * @uses self::VALUE_CARTA_NO_TR_01
     * @uses self::VALUE_TARJETA_DE_CIRCULACION
     * @uses self::VALUE_CERTIFICADO_DE_COBERTURA
     * @uses self::VALUE_POLIZA
     * @uses self::VALUE_ENDOSO
     * @uses self::VALUE_CUPON
     * @uses self::VALUE_CERTIFICADO_DE_PAGO
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FRENTE_DE_POLIZA,
            self::VALUE_SOLICITUD_DE_SEGURO,
            self::VALUE_MERCOSUR,
            self::VALUE_CARTA_TR_01,
            self::VALUE_CARTA_NO_TR_01,
            self::VALUE_TARJETA_DE_CIRCULACION,
            self::VALUE_CERTIFICADO_DE_COBERTURA,
            self::VALUE_POLIZA,
            self::VALUE_ENDOSO,
            self::VALUE_CUPON,
            self::VALUE_CERTIFICADO_DE_PAGO,
        );
    }
}
