<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.cfcal-banque.fr/Homologation/services/SaisieEnLigne/1.10/Service.svc?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.cfcal-banque.fr/Homologation/services/SaisieEnLigne/1.10/Service.svc?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \CfcalSasieSDK\ClassMap::get(),
);
/**
 * Samples for Renvoyer ServiceType
 */
$renvoyer = new \CfcalSasieSDK\Service\Renvoyer($options);
/**
 * Sample call for RenvoyerResultatValidationSaisieEnLigne operation/method
 */
if ($renvoyer->RenvoyerResultatValidationSaisieEnLigne(new \CfcalSasieSDK\Entity\RenvoyerResultatValidationSaisieEnLigne()) !== false) {
    print_r($renvoyer->getResult());
} else {
    print_r($renvoyer->getLastError());
}
/**
 * Sample call for RenvoyerResultatValidationEtEnregistrementSaisieEnLigne
 * operation/method
 */
if ($renvoyer->RenvoyerResultatValidationEtEnregistrementSaisieEnLigne(new \CfcalSasieSDK\Entity\RenvoyerResultatValidationEtEnregistrementSaisieEnLigne()) !== false) {
    print_r($renvoyer->getResult());
} else {
    print_r($renvoyer->getLastError());
}
/**
 * Sample call for RenvoyerListeDocumentSaisieEnLigne operation/method
 */
if ($renvoyer->RenvoyerListeDocumentSaisieEnLigne(new \CfcalSasieSDK\Entity\RenvoyerListeDocumentSaisieEnLigne()) !== false) {
    print_r($renvoyer->getResult());
} else {
    print_r($renvoyer->getLastError());
}
/**
 * Sample call for RenvoyerDocumentSaisieEnLigne operation/method
 */
if ($renvoyer->RenvoyerDocumentSaisieEnLigne(new \CfcalSasieSDK\Entity\RenvoyerDocumentSaisieEnLigne()) !== false) {
    print_r($renvoyer->getResult());
} else {
    print_r($renvoyer->getLastError());
}
/**
 * Sample call for RenvoyerResultatIntegrationSaisieEnLigne operation/method
 */
if ($renvoyer->RenvoyerResultatIntegrationSaisieEnLigne(new \CfcalSasieSDK\Entity\RenvoyerResultatIntegrationSaisieEnLigne()) !== false) {
    print_r($renvoyer->getResult());
} else {
    print_r($renvoyer->getLastError());
}
/**
 * Sample call for RenvoyerEtatSaisieEnLigne operation/method
 */
if ($renvoyer->RenvoyerEtatSaisieEnLigne(new \CfcalSasieSDK\Entity\RenvoyerEtatSaisieEnLigne()) !== false) {
    print_r($renvoyer->getResult());
} else {
    print_r($renvoyer->getLastError());
}
/**
 * Samples for Ajouter ServiceType
 */
$ajouter = new \CfcalSasieSDK\Service\Ajouter($options);
/**
 * Sample call for AjouterPieceDansSaisieEnLigne operation/method
 */
if ($ajouter->AjouterPieceDansSaisieEnLigne(new \CfcalSasieSDK\Entity\AjouterPieceDansSaisieEnLigne()) !== false) {
    print_r($ajouter->getResult());
} else {
    print_r($ajouter->getLastError());
}
