<?php

namespace CfcalSasieSDK\Enum;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ValeurDeReference Enum
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ValeurDeReference
 * @subpackage Enumerations
 */
class ValeurDeReference extends AbstractStructEnumBase
{
    /**
     * Constant for value 'ValeurVenaleActuelle'
     * @return string 'ValeurVenaleActuelle'
     */
    const VALUE_VALEUR_VENALE_ACTUELLE = 'ValeurVenaleActuelle';
    /**
     * Constant for value 'ValeurVenaleApresTravaux'
     * @return string 'ValeurVenaleApresTravaux'
     */
    const VALUE_VALEUR_VENALE_APRES_TRAVAUX = 'ValeurVenaleApresTravaux';
    /**
     * Constant for value 'ValeurVentePubliqueVolontaire'
     * @return string 'ValeurVentePubliqueVolontaire'
     */
    const VALUE_VALEUR_VENTE_PUBLIQUE_VOLONTAIRE = 'ValeurVentePubliqueVolontaire';
    /**
     * Constant for value 'ValeurVenteForcee'
     * @return string 'ValeurVenteForcee'
     */
    const VALUE_VALEUR_VENTE_FORCEE = 'ValeurVenteForcee';
    /**
     * Constant for value 'PrixDAchat'
     * @return string 'PrixDAchat'
     */
    const VALUE_PRIX_DACHAT = 'PrixDAchat';
    /**
     * Constant for value 'Devis'
     * @return string 'Devis'
     */
    const VALUE_DEVIS = 'Devis';
    /**
     * Constant for value 'ValeurProfisco'
     * @return string 'ValeurProfisco'
     */
    const VALUE_VALEUR_PROFISCO = 'ValeurProfisco';
    /**
     * Constant for value 'ValeurDeReconstruction'
     * @return string 'ValeurDeReconstruction'
     */
    const VALUE_VALEUR_DE_RECONSTRUCTION = 'ValeurDeReconstruction';
    /**
     * Constant for value 'Autre'
     * @return string 'Autre'
     */
    const VALUE_AUTRE = 'Autre';
    /**
     * Constant for value 'DevisHTVAEtPrixDuTerrain'
     * @return string 'DevisHTVAEtPrixDuTerrain'
     */
    const VALUE_DEVIS_HTVAET_PRIX_DU_TERRAIN = 'DevisHTVAEtPrixDuTerrain';
    /**
     * Constant for value 'PrixDAchatEtDevis'
     * @return string 'PrixDAchatEtDevis'
     */
    const VALUE_PRIX_DACHAT_ET_DEVIS = 'PrixDAchatEtDevis';
    /**
     * Return allowed values
     * @uses self::VALUE_VALEUR_VENALE_ACTUELLE
     * @uses self::VALUE_VALEUR_VENALE_APRES_TRAVAUX
     * @uses self::VALUE_VALEUR_VENTE_PUBLIQUE_VOLONTAIRE
     * @uses self::VALUE_VALEUR_VENTE_FORCEE
     * @uses self::VALUE_PRIX_DACHAT
     * @uses self::VALUE_DEVIS
     * @uses self::VALUE_VALEUR_PROFISCO
     * @uses self::VALUE_VALEUR_DE_RECONSTRUCTION
     * @uses self::VALUE_AUTRE
     * @uses self::VALUE_DEVIS_HTVAET_PRIX_DU_TERRAIN
     * @uses self::VALUE_PRIX_DACHAT_ET_DEVIS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_VALEUR_VENALE_ACTUELLE,
            self::VALUE_VALEUR_VENALE_APRES_TRAVAUX,
            self::VALUE_VALEUR_VENTE_PUBLIQUE_VOLONTAIRE,
            self::VALUE_VALEUR_VENTE_FORCEE,
            self::VALUE_PRIX_DACHAT,
            self::VALUE_DEVIS,
            self::VALUE_VALEUR_PROFISCO,
            self::VALUE_VALEUR_DE_RECONSTRUCTION,
            self::VALUE_AUTRE,
            self::VALUE_DEVIS_HTVAET_PRIX_DU_TERRAIN,
            self::VALUE_PRIX_DACHAT_ET_DEVIS,
        );
    }
}
