<?php

namespace CfcalSasieSDK\Enum;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TypeNatureDette Enum
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TypeNatureDette
 * @subpackage Enumerations
 */
class TypeNatureDette extends AbstractStructEnumBase
{
    /**
     * Constant for value 'DetteFiscale'
     * @return string 'DetteFiscale'
     */
    const VALUE_DETTE_FISCALE = 'DetteFiscale';
    /**
     * Constant for value 'Decouvert'
     * @return string 'Decouvert'
     */
    const VALUE_DECOUVERT = 'Decouvert';
    /**
     * Constant for value 'DetteFamiliale'
     * @return string 'DetteFamiliale'
     */
    const VALUE_DETTE_FAMILIALE = 'DetteFamiliale';
    /**
     * Constant for value 'DetteSociale'
     * @return string 'DetteSociale'
     */
    const VALUE_DETTE_SOCIALE = 'DetteSociale';
    /**
     * Constant for value 'Donation'
     * @return string 'Donation'
     */
    const VALUE_DONATION = 'Donation';
    /**
     * Constant for value 'Autre'
     * @return string 'Autre'
     */
    const VALUE_AUTRE = 'Autre';
    /**
     * Return allowed values
     * @uses self::VALUE_DETTE_FISCALE
     * @uses self::VALUE_DECOUVERT
     * @uses self::VALUE_DETTE_FAMILIALE
     * @uses self::VALUE_DETTE_SOCIALE
     * @uses self::VALUE_DONATION
     * @uses self::VALUE_AUTRE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DETTE_FISCALE,
            self::VALUE_DECOUVERT,
            self::VALUE_DETTE_FAMILIALE,
            self::VALUE_DETTE_SOCIALE,
            self::VALUE_DONATION,
            self::VALUE_AUTRE,
        );
    }
}
