<?php

namespace CfcalSasieSDK\Enum;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for Standing Enum
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Standing
 * @subpackage Enumerations
 */
class Standing extends AbstractStructEnumBase
{
    /**
     * Constant for value 'GrandStanding'
     * @return string 'GrandStanding'
     */
    const VALUE_GRAND_STANDING = 'GrandStanding';
    /**
     * Constant for value 'Standing'
     * @return string 'Standing'
     */
    const VALUE_STANDING = 'Standing';
    /**
     * Constant for value 'Normal'
     * @return string 'Normal'
     */
    const VALUE_NORMAL = 'Normal';
    /**
     * Constant for value 'Moyen'
     * @return string 'Moyen'
     */
    const VALUE_MOYEN = 'Moyen';
    /**
     * Constant for value 'Aucun'
     * @return string 'Aucun'
     */
    const VALUE_AUCUN = 'Aucun';
    /**
     * Constant for value 'Min'
     * @return string 'Min'
     */
    const VALUE_MIN = 'Min';
    /**
     * Constant for value 'Max'
     * @return string 'Max'
     */
    const VALUE_MAX = 'Max';
    /**
     * Return allowed values
     * @uses self::VALUE_GRAND_STANDING
     * @uses self::VALUE_STANDING
     * @uses self::VALUE_NORMAL
     * @uses self::VALUE_MOYEN
     * @uses self::VALUE_AUCUN
     * @uses self::VALUE_MIN
     * @uses self::VALUE_MAX
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GRAND_STANDING,
            self::VALUE_STANDING,
            self::VALUE_NORMAL,
            self::VALUE_MOYEN,
            self::VALUE_AUCUN,
            self::VALUE_MIN,
            self::VALUE_MAX,
        );
    }
}
