<?php

namespace CfcalSasieSDK\Enum;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for SituationProfessionnelle Enum
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SituationProfessionnelle
 * @subpackage Enumerations
 */
class SituationProfessionnelle extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Employe'
     * @return string 'Employe'
     */
    const VALUE_EMPLOYE = 'Employe';
    /**
     * Constant for value 'Retraite'
     * @return string 'Retraite'
     */
    const VALUE_RETRAITE = 'Retraite';
    /**
     * Constant for value 'SansEmploi'
     * @return string 'SansEmploi'
     */
    const VALUE_SANS_EMPLOI = 'SansEmploi';
    /**
     * Constant for value 'ProfessionLiberale'
     * @return string 'ProfessionLiberale'
     */
    const VALUE_PROFESSION_LIBERALE = 'ProfessionLiberale';
    /**
     * Constant for value 'Artisan'
     * @return string 'Artisan'
     */
    const VALUE_ARTISAN = 'Artisan';
    /**
     * Constant for value 'Commercant'
     * @return string 'Commercant'
     */
    const VALUE_COMMERCANT = 'Commercant';
    /**
     * Constant for value 'DirigeantDeSociete'
     * @return string 'DirigeantDeSociete'
     */
    const VALUE_DIRIGEANT_DE_SOCIETE = 'DirigeantDeSociete';
    /**
     * Return allowed values
     * @uses self::VALUE_EMPLOYE
     * @uses self::VALUE_RETRAITE
     * @uses self::VALUE_SANS_EMPLOI
     * @uses self::VALUE_PROFESSION_LIBERALE
     * @uses self::VALUE_ARTISAN
     * @uses self::VALUE_COMMERCANT
     * @uses self::VALUE_DIRIGEANT_DE_SOCIETE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EMPLOYE,
            self::VALUE_RETRAITE,
            self::VALUE_SANS_EMPLOI,
            self::VALUE_PROFESSION_LIBERALE,
            self::VALUE_ARTISAN,
            self::VALUE_COMMERCANT,
            self::VALUE_DIRIGEANT_DE_SOCIETE,
        );
    }
}
