<?php

namespace CfcalSasieSDK\Enum;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for NatureEngagement Enum
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:NatureEngagement
 * @subpackage Enumerations
 */
class NatureEngagement extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Immobilier'
     * @return string 'Immobilier'
     */
    const VALUE_IMMOBILIER = 'Immobilier';
    /**
     * Constant for value 'ConsommationAmortissable'
     * @return string 'ConsommationAmortissable'
     */
    const VALUE_CONSOMMATION_AMORTISSABLE = 'ConsommationAmortissable';
    /**
     * Constant for value 'Professionnel'
     * @return string 'Professionnel'
     */
    const VALUE_PROFESSIONNEL = 'Professionnel';
    /**
     * Constant for value 'ConsommationRenouvelable'
     * @return string 'ConsommationRenouvelable'
     */
    const VALUE_CONSOMMATION_RENOUVELABLE = 'ConsommationRenouvelable';
    /**
     * Constant for value 'ImmobilierLocatif'
     * @return string 'ImmobilierLocatif'
     */
    const VALUE_IMMOBILIER_LOCATIF = 'ImmobilierLocatif';
    /**
     * Constant for value 'ImmobilierNonlocatif'
     * @return string 'ImmobilierNonlocatif'
     */
    const VALUE_IMMOBILIER_NONLOCATIF = 'ImmobilierNonlocatif';
    /**
     * Return allowed values
     * @uses self::VALUE_IMMOBILIER
     * @uses self::VALUE_CONSOMMATION_AMORTISSABLE
     * @uses self::VALUE_PROFESSIONNEL
     * @uses self::VALUE_CONSOMMATION_RENOUVELABLE
     * @uses self::VALUE_IMMOBILIER_LOCATIF
     * @uses self::VALUE_IMMOBILIER_NONLOCATIF
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_IMMOBILIER,
            self::VALUE_CONSOMMATION_AMORTISSABLE,
            self::VALUE_PROFESSIONNEL,
            self::VALUE_CONSOMMATION_RENOUVELABLE,
            self::VALUE_IMMOBILIER_LOCATIF,
            self::VALUE_IMMOBILIER_NONLOCATIF,
        );
    }
}
