<?php

namespace CfcalSasieSDK\Enum;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for Environnement Enum
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Environnement
 * @subpackage Enumerations
 */
class Environnement extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Excellent'
     * @return string 'Excellent'
     */
    const VALUE_EXCELLENT = 'Excellent';
    /**
     * Constant for value 'Bon'
     * @return string 'Bon'
     */
    const VALUE_BON = 'Bon';
    /**
     * Constant for value 'Moyen'
     * @return string 'Moyen'
     */
    const VALUE_MOYEN = 'Moyen';
    /**
     * Constant for value 'Passable'
     * @return string 'Passable'
     */
    const VALUE_PASSABLE = 'Passable';
    /**
     * Constant for value 'Mediocre'
     * @return string 'Mediocre'
     */
    const VALUE_MEDIOCRE = 'Mediocre';
    /**
     * Return allowed values
     * @uses self::VALUE_EXCELLENT
     * @uses self::VALUE_BON
     * @uses self::VALUE_MOYEN
     * @uses self::VALUE_PASSABLE
     * @uses self::VALUE_MEDIOCRE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_EXCELLENT,
            self::VALUE_BON,
            self::VALUE_MOYEN,
            self::VALUE_PASSABLE,
            self::VALUE_MEDIOCRE,
        );
    }
}
