<?php

namespace CfcalSasieSDK\Enum;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for ChargesReelles Enum
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ChargesReelles
 * @subpackage Enumerations
 */
class ChargesReelles extends AbstractStructEnumBase
{
    /**
     * Constant for value 'DroitDUsage'
     * @return string 'DroitDUsage'
     */
    const VALUE_DROIT_DUSAGE = 'DroitDUsage';
    /**
     * Constant for value 'DroitDHabitation'
     * @return string 'DroitDHabitation'
     */
    const VALUE_DROIT_DHABITATION = 'DroitDHabitation';
    /**
     * Constant for value 'BailAVie'
     * @return string 'BailAVie'
     */
    const VALUE_BAIL_AVIE = 'BailAVie';
    /**
     * Constant for value 'Inconnu'
     * @return string 'Inconnu'
     */
    const VALUE_INCONNU = 'Inconnu';
    /**
     * Return allowed values
     * @uses self::VALUE_DROIT_DUSAGE
     * @uses self::VALUE_DROIT_DHABITATION
     * @uses self::VALUE_BAIL_AVIE
     * @uses self::VALUE_INCONNU
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DROIT_DUSAGE,
            self::VALUE_DROIT_DHABITATION,
            self::VALUE_BAIL_AVIE,
            self::VALUE_INCONNU,
        );
    }
}
