<?php

namespace CfcalSasieSDK\Enum;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for CapaciteJuridique Enum
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CapaciteJuridique
 * @subpackage Enumerations
 */
class CapaciteJuridique extends AbstractStructEnumBase
{
    /**
     * Constant for value 'MineurEmancipe'
     * @return string 'MineurEmancipe'
     */
    const VALUE_MINEUR_EMANCIPE = 'MineurEmancipe';
    /**
     * Constant for value 'MineurSousAdministrationLegalePureEtSimple'
     * @return string 'MineurSousAdministrationLegalePureEtSimple'
     */
    const VALUE_MINEUR_SOUS_ADMINISTRATION_LEGALE_PURE_ET_SIMPLE = 'MineurSousAdministrationLegalePureEtSimple';
    /**
     * Constant for value 'MineurSousAdministrationSousControleJudiciaire'
     * @return string 'MineurSousAdministrationSousControleJudiciaire'
     */
    const VALUE_MINEUR_SOUS_ADMINISTRATION_SOUS_CONTROLE_JUDICIAIRE = 'MineurSousAdministrationSousControleJudiciaire';
    /**
     * Constant for value 'MineurSousTutelle'
     * @return string 'MineurSousTutelle'
     */
    const VALUE_MINEUR_SOUS_TUTELLE = 'MineurSousTutelle';
    /**
     * Constant for value 'PupilleDetat'
     * @return string 'PupilleDetat'
     */
    const VALUE_PUPILLE_DETAT = 'PupilleDetat';
    /**
     * Constant for value 'PupilleDeLaNation'
     * @return string 'PupilleDeLaNation'
     */
    const VALUE_PUPILLE_DE_LA_NATION = 'PupilleDeLaNation';
    /**
     * Constant for value 'MajeurCapable'
     * @return string 'MajeurCapable'
     */
    const VALUE_MAJEUR_CAPABLE = 'MajeurCapable';
    /**
     * Constant for value 'MajeurSousSauvegardeDeJusticeMandatOrdinaire'
     * @return string 'MajeurSousSauvegardeDeJusticeMandatOrdinaire'
     */
    const VALUE_MAJEUR_SOUS_SAUVEGARDE_DE_JUSTICE_MANDAT_ORDINAIRE = 'MajeurSousSauvegardeDeJusticeMandatOrdinaire';
    /**
     * Constant for value
     * 'MajeurSousSauvegardeDeJusticeMandatDonneEnConsiderationDeMiseSousSauvegardeDeJu
     * stice'
     * @return string 'MajeurSousSauvegardeDeJusticeMandatDonneEnConsiderationDeMiseSousSauvegardeDeJustice'
     */
    const VALUE_MAJEUR_SOUS_SAUVEGARDE_DE_JUSTICE_MANDAT_DONNE_EN_CONSIDERATION_DE_MISE_SOUS_SAUVEGARDE_DE_JUSTICE = 'MajeurSousSauvegardeDeJusticeMandatDonneEnConsiderationDeMiseSousSauvegardeDeJustice';
    /**
     * Constant for value 'MajeurSousSauvegardeDeJusticeMandatSpecial'
     * @return string 'MajeurSousSauvegardeDeJusticeMandatSpecial'
     */
    const VALUE_MAJEUR_SOUS_SAUVEGARDE_DE_JUSTICE_MANDAT_SPECIAL = 'MajeurSousSauvegardeDeJusticeMandatSpecial';
    /**
     * Constant for value 'MajeurSousCuratelleSimple'
     * @return string 'MajeurSousCuratelleSimple'
     */
    const VALUE_MAJEUR_SOUS_CURATELLE_SIMPLE = 'MajeurSousCuratelleSimple';
    /**
     * Constant for value 'MajeurSousCuratelleRenforcee'
     * @return string 'MajeurSousCuratelleRenforcee'
     */
    const VALUE_MAJEUR_SOUS_CURATELLE_RENFORCEE = 'MajeurSousCuratelleRenforcee';
    /**
     * Constant for value 'MajeurSousGeranceDeTutelle'
     * @return string 'MajeurSousGeranceDeTutelle'
     */
    const VALUE_MAJEUR_SOUS_GERANCE_DE_TUTELLE = 'MajeurSousGeranceDeTutelle';
    /**
     * Constant for value 'MajeurSousControleJudiciaire'
     * @return string 'MajeurSousControleJudiciaire'
     */
    const VALUE_MAJEUR_SOUS_CONTROLE_JUDICIAIRE = 'MajeurSousControleJudiciaire';
    /**
     * Constant for value 'MajeurSousTutelle'
     * @return string 'MajeurSousTutelle'
     */
    const VALUE_MAJEUR_SOUS_TUTELLE = 'MajeurSousTutelle';
    /**
     * Constant for value 'MajeurSousSauvegardeDeJustice'
     * @return string 'MajeurSousSauvegardeDeJustice'
     */
    const VALUE_MAJEUR_SOUS_SAUVEGARDE_DE_JUSTICE = 'MajeurSousSauvegardeDeJustice';
    /**
     * Constant for value 'MajeurSousCuratelle'
     * @return string 'MajeurSousCuratelle'
     */
    const VALUE_MAJEUR_SOUS_CURATELLE = 'MajeurSousCuratelle';
    /**
     * Return allowed values
     * @uses self::VALUE_MINEUR_EMANCIPE
     * @uses self::VALUE_MINEUR_SOUS_ADMINISTRATION_LEGALE_PURE_ET_SIMPLE
     * @uses self::VALUE_MINEUR_SOUS_ADMINISTRATION_SOUS_CONTROLE_JUDICIAIRE
     * @uses self::VALUE_MINEUR_SOUS_TUTELLE
     * @uses self::VALUE_PUPILLE_DETAT
     * @uses self::VALUE_PUPILLE_DE_LA_NATION
     * @uses self::VALUE_MAJEUR_CAPABLE
     * @uses self::VALUE_MAJEUR_SOUS_SAUVEGARDE_DE_JUSTICE_MANDAT_ORDINAIRE
     * @uses self::VALUE_MAJEUR_SOUS_SAUVEGARDE_DE_JUSTICE_MANDAT_DONNE_EN_CONSIDERATION_DE_MISE_SOUS_SAUVEGARDE_DE_JUSTICE
     * @uses self::VALUE_MAJEUR_SOUS_SAUVEGARDE_DE_JUSTICE_MANDAT_SPECIAL
     * @uses self::VALUE_MAJEUR_SOUS_CURATELLE_SIMPLE
     * @uses self::VALUE_MAJEUR_SOUS_CURATELLE_RENFORCEE
     * @uses self::VALUE_MAJEUR_SOUS_GERANCE_DE_TUTELLE
     * @uses self::VALUE_MAJEUR_SOUS_CONTROLE_JUDICIAIRE
     * @uses self::VALUE_MAJEUR_SOUS_TUTELLE
     * @uses self::VALUE_MAJEUR_SOUS_SAUVEGARDE_DE_JUSTICE
     * @uses self::VALUE_MAJEUR_SOUS_CURATELLE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MINEUR_EMANCIPE,
            self::VALUE_MINEUR_SOUS_ADMINISTRATION_LEGALE_PURE_ET_SIMPLE,
            self::VALUE_MINEUR_SOUS_ADMINISTRATION_SOUS_CONTROLE_JUDICIAIRE,
            self::VALUE_MINEUR_SOUS_TUTELLE,
            self::VALUE_PUPILLE_DETAT,
            self::VALUE_PUPILLE_DE_LA_NATION,
            self::VALUE_MAJEUR_CAPABLE,
            self::VALUE_MAJEUR_SOUS_SAUVEGARDE_DE_JUSTICE_MANDAT_ORDINAIRE,
            self::VALUE_MAJEUR_SOUS_SAUVEGARDE_DE_JUSTICE_MANDAT_DONNE_EN_CONSIDERATION_DE_MISE_SOUS_SAUVEGARDE_DE_JUSTICE,
            self::VALUE_MAJEUR_SOUS_SAUVEGARDE_DE_JUSTICE_MANDAT_SPECIAL,
            self::VALUE_MAJEUR_SOUS_CURATELLE_SIMPLE,
            self::VALUE_MAJEUR_SOUS_CURATELLE_RENFORCEE,
            self::VALUE_MAJEUR_SOUS_GERANCE_DE_TUTELLE,
            self::VALUE_MAJEUR_SOUS_CONTROLE_JUDICIAIRE,
            self::VALUE_MAJEUR_SOUS_TUTELLE,
            self::VALUE_MAJEUR_SOUS_SAUVEGARDE_DE_JUSTICE,
            self::VALUE_MAJEUR_SOUS_CURATELLE,
        );
    }
}
