<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ville Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Ville
 * @subpackage Structs
 */
class Ville extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The CodePostal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodePostal;
    /**
     * The Commune
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Commune;
    /**
     * The CodePays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodePays;
    /**
     * Constructor method for Ville
     * @uses Ville::setCodePostal()
     * @uses Ville::setCommune()
     * @uses Ville::setCodePays()
     * @param string $codePostal
     * @param string $commune
     * @param string $codePays
     */
    public function __construct($codePostal = null, $commune = null, $codePays = null)
    {
        $this
            ->setCodePostal($codePostal)
            ->setCommune($commune)
            ->setCodePays($codePays);
    }
    /**
     * Get CodePostal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodePostal()
    {
        return isset($this->CodePostal) ? $this->CodePostal : null;
    }
    /**
     * Set CodePostal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codePostal
     * @return \CfcalSasieSDK\Entity\Ville
     */
    public function setCodePostal($codePostal = null)
    {
        // validation for constraint: string
        if (!is_null($codePostal) && !is_string($codePostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codePostal, true), gettype($codePostal)), __LINE__);
        }
        if (is_null($codePostal) || (is_array($codePostal) && empty($codePostal))) {
            unset($this->CodePostal);
        } else {
            $this->CodePostal = $codePostal;
        }
        return $this;
    }
    /**
     * Get Commune value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCommune()
    {
        return isset($this->Commune) ? $this->Commune : null;
    }
    /**
     * Set Commune value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $commune
     * @return \CfcalSasieSDK\Entity\Ville
     */
    public function setCommune($commune = null)
    {
        // validation for constraint: string
        if (!is_null($commune) && !is_string($commune)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commune, true), gettype($commune)), __LINE__);
        }
        if (is_null($commune) || (is_array($commune) && empty($commune))) {
            unset($this->Commune);
        } else {
            $this->Commune = $commune;
        }
        return $this;
    }
    /**
     * Get CodePays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodePays()
    {
        return isset($this->CodePays) ? $this->CodePays : null;
    }
    /**
     * Set CodePays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\Pays::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\Pays::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codePays
     * @return \CfcalSasieSDK\Entity\Ville
     */
    public function setCodePays($codePays = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\Pays::valueIsValid($codePays)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\Pays', is_array($codePays) ? implode(', ', $codePays) : var_export($codePays, true), implode(', ', \CfcalSasieSDK\Enum\Pays::getValidValues())), __LINE__);
        }
        if (is_null($codePays) || (is_array($codePays) && empty($codePays))) {
            unset($this->CodePays);
        } else {
            $this->CodePays = $codePays;
        }
        return $this;
    }
}
