<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Societe Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Societe
 * @subpackage Structs
 */
class Societe extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The RaisonSociale
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RaisonSociale;
    /**
     * The Adresse
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Adresse;
    /**
     * The Ville
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Ville
     */
    public $Ville;
    /**
     * The SIRET
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SIRET;
    /**
     * The CodeCultureLangue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeCultureLangue;
    /**
     * The CodeFormeJuridique
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeFormeJuridique;
    /**
     * Constructor method for Societe
     * @uses Societe::setRaisonSociale()
     * @uses Societe::setAdresse()
     * @uses Societe::setVille()
     * @uses Societe::setSIRET()
     * @uses Societe::setCodeCultureLangue()
     * @uses Societe::setCodeFormeJuridique()
     * @param string $raisonSociale
     * @param string $adresse
     * @param \CfcalSasieSDK\Entity\Ville $ville
     * @param string $sIRET
     * @param string $codeCultureLangue
     * @param string $codeFormeJuridique
     */
    public function __construct($raisonSociale = null, $adresse = null, \CfcalSasieSDK\Entity\Ville $ville = null, $sIRET = null, $codeCultureLangue = null, $codeFormeJuridique = null)
    {
        $this
            ->setRaisonSociale($raisonSociale)
            ->setAdresse($adresse)
            ->setVille($ville)
            ->setSIRET($sIRET)
            ->setCodeCultureLangue($codeCultureLangue)
            ->setCodeFormeJuridique($codeFormeJuridique);
    }
    /**
     * Get RaisonSociale value
     * @return string|null
     */
    public function getRaisonSociale()
    {
        return $this->RaisonSociale;
    }
    /**
     * Set RaisonSociale value
     * @param string $raisonSociale
     * @return \CfcalSasieSDK\Entity\Societe
     */
    public function setRaisonSociale($raisonSociale = null)
    {
        // validation for constraint: string
        if (!is_null($raisonSociale) && !is_string($raisonSociale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($raisonSociale, true), gettype($raisonSociale)), __LINE__);
        }
        $this->RaisonSociale = $raisonSociale;
        return $this;
    }
    /**
     * Get Adresse value
     * @return string|null
     */
    public function getAdresse()
    {
        return $this->Adresse;
    }
    /**
     * Set Adresse value
     * @param string $adresse
     * @return \CfcalSasieSDK\Entity\Societe
     */
    public function setAdresse($adresse = null)
    {
        // validation for constraint: string
        if (!is_null($adresse) && !is_string($adresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresse, true), gettype($adresse)), __LINE__);
        }
        $this->Adresse = $adresse;
        return $this;
    }
    /**
     * Get Ville value
     * @return \CfcalSasieSDK\Entity\Ville|null
     */
    public function getVille()
    {
        return $this->Ville;
    }
    /**
     * Set Ville value
     * @param \CfcalSasieSDK\Entity\Ville $ville
     * @return \CfcalSasieSDK\Entity\Societe
     */
    public function setVille(\CfcalSasieSDK\Entity\Ville $ville = null)
    {
        $this->Ville = $ville;
        return $this;
    }
    /**
     * Get SIRET value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSIRET()
    {
        return isset($this->SIRET) ? $this->SIRET : null;
    }
    /**
     * Set SIRET value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sIRET
     * @return \CfcalSasieSDK\Entity\Societe
     */
    public function setSIRET($sIRET = null)
    {
        // validation for constraint: string
        if (!is_null($sIRET) && !is_string($sIRET)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sIRET, true), gettype($sIRET)), __LINE__);
        }
        if (is_null($sIRET) || (is_array($sIRET) && empty($sIRET))) {
            unset($this->SIRET);
        } else {
            $this->SIRET = $sIRET;
        }
        return $this;
    }
    /**
     * Get CodeCultureLangue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeCultureLangue()
    {
        return isset($this->CodeCultureLangue) ? $this->CodeCultureLangue : null;
    }
    /**
     * Set CodeCultureLangue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypeCodeCultureLangueBelgique::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeCodeCultureLangueBelgique::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeCultureLangue
     * @return \CfcalSasieSDK\Entity\Societe
     */
    public function setCodeCultureLangue($codeCultureLangue = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeCodeCultureLangueBelgique::valueIsValid($codeCultureLangue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeCodeCultureLangueBelgique', is_array($codeCultureLangue) ? implode(', ', $codeCultureLangue) : var_export($codeCultureLangue, true), implode(', ', \CfcalSasieSDK\Enum\TypeCodeCultureLangueBelgique::getValidValues())), __LINE__);
        }
        if (is_null($codeCultureLangue) || (is_array($codeCultureLangue) && empty($codeCultureLangue))) {
            unset($this->CodeCultureLangue);
        } else {
            $this->CodeCultureLangue = $codeCultureLangue;
        }
        return $this;
    }
    /**
     * Get CodeFormeJuridique value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeFormeJuridique()
    {
        return isset($this->CodeFormeJuridique) ? $this->CodeFormeJuridique : null;
    }
    /**
     * Set CodeFormeJuridique value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\FormeJuridique::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\FormeJuridique::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeFormeJuridique
     * @return \CfcalSasieSDK\Entity\Societe
     */
    public function setCodeFormeJuridique($codeFormeJuridique = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\FormeJuridique::valueIsValid($codeFormeJuridique)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\FormeJuridique', is_array($codeFormeJuridique) ? implode(', ', $codeFormeJuridique) : var_export($codeFormeJuridique, true), implode(', ', \CfcalSasieSDK\Enum\FormeJuridique::getValidValues())), __LINE__);
        }
        if (is_null($codeFormeJuridique) || (is_array($codeFormeJuridique) && empty($codeFormeJuridique))) {
            unset($this->CodeFormeJuridique);
        } else {
            $this->CodeFormeJuridique = $codeFormeJuridique;
        }
        return $this;
    }
}
