<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureEmprunteur Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SignatureEmprunteur
 * @subpackage Structs
 */
class SignatureEmprunteur extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The CodePersonnePhysique
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CodePersonnePhysique;
    /**
     * The CodeTypeSignatureAssurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypeSignatureAssurance;
    /**
     * The CodeTypeSignaturePret
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypeSignaturePret;
    /**
     * The ContactEmailEmprunteurParcoursSignature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactEmailEmprunteurParcoursSignature;
    /**
     * The ContactTelephoneEmprunteurParcoursSignature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactTelephoneEmprunteurParcoursSignature;
    /**
     * Constructor method for SignatureEmprunteur
     * @uses SignatureEmprunteur::setCodePersonnePhysique()
     * @uses SignatureEmprunteur::setCodeTypeSignatureAssurance()
     * @uses SignatureEmprunteur::setCodeTypeSignaturePret()
     * @uses SignatureEmprunteur::setContactEmailEmprunteurParcoursSignature()
     * @uses SignatureEmprunteur::setContactTelephoneEmprunteurParcoursSignature()
     * @param int $codePersonnePhysique
     * @param string $codeTypeSignatureAssurance
     * @param string $codeTypeSignaturePret
     * @param string $contactEmailEmprunteurParcoursSignature
     * @param string $contactTelephoneEmprunteurParcoursSignature
     */
    public function __construct($codePersonnePhysique = null, $codeTypeSignatureAssurance = null, $codeTypeSignaturePret = null, $contactEmailEmprunteurParcoursSignature = null, $contactTelephoneEmprunteurParcoursSignature = null)
    {
        $this
            ->setCodePersonnePhysique($codePersonnePhysique)
            ->setCodeTypeSignatureAssurance($codeTypeSignatureAssurance)
            ->setCodeTypeSignaturePret($codeTypeSignaturePret)
            ->setContactEmailEmprunteurParcoursSignature($contactEmailEmprunteurParcoursSignature)
            ->setContactTelephoneEmprunteurParcoursSignature($contactTelephoneEmprunteurParcoursSignature);
    }
    /**
     * Get CodePersonnePhysique value
     * @return int|null
     */
    public function getCodePersonnePhysique()
    {
        return $this->CodePersonnePhysique;
    }
    /**
     * Set CodePersonnePhysique value
     * @param int $codePersonnePhysique
     * @return \CfcalSasieSDK\Entity\SignatureEmprunteur
     */
    public function setCodePersonnePhysique($codePersonnePhysique = null)
    {
        // validation for constraint: int
        if (!is_null($codePersonnePhysique) && !(is_int($codePersonnePhysique) || ctype_digit($codePersonnePhysique))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codePersonnePhysique, true), gettype($codePersonnePhysique)), __LINE__);
        }
        $this->CodePersonnePhysique = $codePersonnePhysique;
        return $this;
    }
    /**
     * Get CodeTypeSignatureAssurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeSignatureAssurance()
    {
        return isset($this->CodeTypeSignatureAssurance) ? $this->CodeTypeSignatureAssurance : null;
    }
    /**
     * Set CodeTypeSignatureAssurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypeSignature::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeSignature::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeSignatureAssurance
     * @return \CfcalSasieSDK\Entity\SignatureEmprunteur
     */
    public function setCodeTypeSignatureAssurance($codeTypeSignatureAssurance = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeSignature::valueIsValid($codeTypeSignatureAssurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeSignature', is_array($codeTypeSignatureAssurance) ? implode(', ', $codeTypeSignatureAssurance) : var_export($codeTypeSignatureAssurance, true), implode(', ', \CfcalSasieSDK\Enum\TypeSignature::getValidValues())), __LINE__);
        }
        if (is_null($codeTypeSignatureAssurance) || (is_array($codeTypeSignatureAssurance) && empty($codeTypeSignatureAssurance))) {
            unset($this->CodeTypeSignatureAssurance);
        } else {
            $this->CodeTypeSignatureAssurance = $codeTypeSignatureAssurance;
        }
        return $this;
    }
    /**
     * Get CodeTypeSignaturePret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeSignaturePret()
    {
        return isset($this->CodeTypeSignaturePret) ? $this->CodeTypeSignaturePret : null;
    }
    /**
     * Set CodeTypeSignaturePret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypeSignature::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeSignature::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeSignaturePret
     * @return \CfcalSasieSDK\Entity\SignatureEmprunteur
     */
    public function setCodeTypeSignaturePret($codeTypeSignaturePret = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeSignature::valueIsValid($codeTypeSignaturePret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeSignature', is_array($codeTypeSignaturePret) ? implode(', ', $codeTypeSignaturePret) : var_export($codeTypeSignaturePret, true), implode(', ', \CfcalSasieSDK\Enum\TypeSignature::getValidValues())), __LINE__);
        }
        if (is_null($codeTypeSignaturePret) || (is_array($codeTypeSignaturePret) && empty($codeTypeSignaturePret))) {
            unset($this->CodeTypeSignaturePret);
        } else {
            $this->CodeTypeSignaturePret = $codeTypeSignaturePret;
        }
        return $this;
    }
    /**
     * Get ContactEmailEmprunteurParcoursSignature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactEmailEmprunteurParcoursSignature()
    {
        return isset($this->ContactEmailEmprunteurParcoursSignature) ? $this->ContactEmailEmprunteurParcoursSignature : null;
    }
    /**
     * Set ContactEmailEmprunteurParcoursSignature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactEmailEmprunteurParcoursSignature
     * @return \CfcalSasieSDK\Entity\SignatureEmprunteur
     */
    public function setContactEmailEmprunteurParcoursSignature($contactEmailEmprunteurParcoursSignature = null)
    {
        // validation for constraint: string
        if (!is_null($contactEmailEmprunteurParcoursSignature) && !is_string($contactEmailEmprunteurParcoursSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactEmailEmprunteurParcoursSignature, true), gettype($contactEmailEmprunteurParcoursSignature)), __LINE__);
        }
        if (is_null($contactEmailEmprunteurParcoursSignature) || (is_array($contactEmailEmprunteurParcoursSignature) && empty($contactEmailEmprunteurParcoursSignature))) {
            unset($this->ContactEmailEmprunteurParcoursSignature);
        } else {
            $this->ContactEmailEmprunteurParcoursSignature = $contactEmailEmprunteurParcoursSignature;
        }
        return $this;
    }
    /**
     * Get ContactTelephoneEmprunteurParcoursSignature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactTelephoneEmprunteurParcoursSignature()
    {
        return isset($this->ContactTelephoneEmprunteurParcoursSignature) ? $this->ContactTelephoneEmprunteurParcoursSignature : null;
    }
    /**
     * Set ContactTelephoneEmprunteurParcoursSignature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactTelephoneEmprunteurParcoursSignature
     * @return \CfcalSasieSDK\Entity\SignatureEmprunteur
     */
    public function setContactTelephoneEmprunteurParcoursSignature($contactTelephoneEmprunteurParcoursSignature = null)
    {
        // validation for constraint: string
        if (!is_null($contactTelephoneEmprunteurParcoursSignature) && !is_string($contactTelephoneEmprunteurParcoursSignature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactTelephoneEmprunteurParcoursSignature, true), gettype($contactTelephoneEmprunteurParcoursSignature)), __LINE__);
        }
        if (is_null($contactTelephoneEmprunteurParcoursSignature) || (is_array($contactTelephoneEmprunteurParcoursSignature) && empty($contactTelephoneEmprunteurParcoursSignature))) {
            unset($this->ContactTelephoneEmprunteurParcoursSignature);
        } else {
            $this->ContactTelephoneEmprunteurParcoursSignature = $contactTelephoneEmprunteurParcoursSignature;
        }
        return $this;
    }
}
