<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SCI Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SCI
 * @subpackage Structs
 */
class SCI extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The SiretSCI
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SiretSCI;
    /**
     * The RaisonSocial
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $RaisonSocial;
    /**
     * The ListeRevenus
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Revenus
     */
    public $ListeRevenus;
    /**
     * The ListeCharges
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Charges
     */
    public $ListeCharges;
    /**
     * The EnCoursDeCreation
     * @var bool
     */
    public $EnCoursDeCreation;
    /**
     * The EstFamiliale
     * @var bool
     */
    public $EstFamiliale;
    /**
     * Constructor method for SCI
     * @uses SCI::setSiretSCI()
     * @uses SCI::setRaisonSocial()
     * @uses SCI::setListeRevenus()
     * @uses SCI::setListeCharges()
     * @uses SCI::setEnCoursDeCreation()
     * @uses SCI::setEstFamiliale()
     * @param string $siretSCI
     * @param string $raisonSocial
     * @param \CfcalSasieSDK\Entity\Revenus $listeRevenus
     * @param \CfcalSasieSDK\Entity\Charges $listeCharges
     * @param bool $enCoursDeCreation
     * @param bool $estFamiliale
     */
    public function __construct($siretSCI = null, $raisonSocial = null, \CfcalSasieSDK\Entity\Revenus $listeRevenus = null, \CfcalSasieSDK\Entity\Charges $listeCharges = null, $enCoursDeCreation = null, $estFamiliale = null)
    {
        $this
            ->setSiretSCI($siretSCI)
            ->setRaisonSocial($raisonSocial)
            ->setListeRevenus($listeRevenus)
            ->setListeCharges($listeCharges)
            ->setEnCoursDeCreation($enCoursDeCreation)
            ->setEstFamiliale($estFamiliale);
    }
    /**
     * Get SiretSCI value
     * @return string|null
     */
    public function getSiretSCI()
    {
        return $this->SiretSCI;
    }
    /**
     * Set SiretSCI value
     * @param string $siretSCI
     * @return \CfcalSasieSDK\Entity\SCI
     */
    public function setSiretSCI($siretSCI = null)
    {
        // validation for constraint: string
        if (!is_null($siretSCI) && !is_string($siretSCI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siretSCI, true), gettype($siretSCI)), __LINE__);
        }
        $this->SiretSCI = $siretSCI;
        return $this;
    }
    /**
     * Get RaisonSocial value
     * @return string|null
     */
    public function getRaisonSocial()
    {
        return $this->RaisonSocial;
    }
    /**
     * Set RaisonSocial value
     * @param string $raisonSocial
     * @return \CfcalSasieSDK\Entity\SCI
     */
    public function setRaisonSocial($raisonSocial = null)
    {
        // validation for constraint: string
        if (!is_null($raisonSocial) && !is_string($raisonSocial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($raisonSocial, true), gettype($raisonSocial)), __LINE__);
        }
        $this->RaisonSocial = $raisonSocial;
        return $this;
    }
    /**
     * Get ListeRevenus value
     * @return \CfcalSasieSDK\Entity\Revenus|null
     */
    public function getListeRevenus()
    {
        return $this->ListeRevenus;
    }
    /**
     * Set ListeRevenus value
     * @param \CfcalSasieSDK\Entity\Revenus $listeRevenus
     * @return \CfcalSasieSDK\Entity\SCI
     */
    public function setListeRevenus(\CfcalSasieSDK\Entity\Revenus $listeRevenus = null)
    {
        $this->ListeRevenus = $listeRevenus;
        return $this;
    }
    /**
     * Get ListeCharges value
     * @return \CfcalSasieSDK\Entity\Charges|null
     */
    public function getListeCharges()
    {
        return $this->ListeCharges;
    }
    /**
     * Set ListeCharges value
     * @param \CfcalSasieSDK\Entity\Charges $listeCharges
     * @return \CfcalSasieSDK\Entity\SCI
     */
    public function setListeCharges(\CfcalSasieSDK\Entity\Charges $listeCharges = null)
    {
        $this->ListeCharges = $listeCharges;
        return $this;
    }
    /**
     * Get EnCoursDeCreation value
     * @return bool|null
     */
    public function getEnCoursDeCreation()
    {
        return $this->EnCoursDeCreation;
    }
    /**
     * Set EnCoursDeCreation value
     * @param bool $enCoursDeCreation
     * @return \CfcalSasieSDK\Entity\SCI
     */
    public function setEnCoursDeCreation($enCoursDeCreation = null)
    {
        // validation for constraint: boolean
        if (!is_null($enCoursDeCreation) && !is_bool($enCoursDeCreation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enCoursDeCreation, true), gettype($enCoursDeCreation)), __LINE__);
        }
        $this->EnCoursDeCreation = $enCoursDeCreation;
        return $this;
    }
    /**
     * Get EstFamiliale value
     * @return bool|null
     */
    public function getEstFamiliale()
    {
        return $this->EstFamiliale;
    }
    /**
     * Set EstFamiliale value
     * @param bool $estFamiliale
     * @return \CfcalSasieSDK\Entity\SCI
     */
    public function setEstFamiliale($estFamiliale = null)
    {
        // validation for constraint: boolean
        if (!is_null($estFamiliale) && !is_bool($estFamiliale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estFamiliale, true), gettype($estFamiliale)), __LINE__);
        }
        $this->EstFamiliale = $estFamiliale;
        return $this;
    }
}
