<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Revenus Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Revenus
 * @subpackage Structs
 */
class Revenus extends AbstractStructBase
{
    /**
     * The Revenu
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Revenu[]
     */
    public $Revenu;
    /**
     * Constructor method for Revenus
     * @uses Revenus::setRevenu()
     * @param \CfcalSasieSDK\Entity\Revenu[] $revenu
     */
    public function __construct(array $revenu = array())
    {
        $this
            ->setRevenu($revenu);
    }
    /**
     * Get Revenu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Revenu[]|null
     */
    public function getRevenu()
    {
        return isset($this->Revenu) ? $this->Revenu : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRevenu method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRevenu method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRevenuForArrayConstraintsFromSetRevenu(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $revenusRevenuItem) {
            // validation for constraint: itemType
            if (!$revenusRevenuItem instanceof \CfcalSasieSDK\Entity\Revenu) {
                $invalidValues[] = is_object($revenusRevenuItem) ? get_class($revenusRevenuItem) : sprintf('%s(%s)', gettype($revenusRevenuItem), var_export($revenusRevenuItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Revenu property can only contain items of type \CfcalSasieSDK\Entity\Revenu, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Revenu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Revenu[] $revenu
     * @return \CfcalSasieSDK\Entity\Revenus
     */
    public function setRevenu(array $revenu = array())
    {
        // validation for constraint: array
        if ('' !== ($revenuArrayErrorMessage = self::validateRevenuForArrayConstraintsFromSetRevenu($revenu))) {
            throw new \InvalidArgumentException($revenuArrayErrorMessage, __LINE__);
        }
        if (is_null($revenu) || (is_array($revenu) && empty($revenu))) {
            unset($this->Revenu);
        } else {
            $this->Revenu = $revenu;
        }
        return $this;
    }
    /**
     * Add item to Revenu value
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Revenu $item
     * @return \CfcalSasieSDK\Entity\Revenus
     */
    public function addToRevenu(\CfcalSasieSDK\Entity\Revenu $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CfcalSasieSDK\Entity\Revenu) {
            throw new \InvalidArgumentException(sprintf('The Revenu property can only contain items of type \CfcalSasieSDK\Entity\Revenu, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Revenu[] = $item;
        return $this;
    }
}
