<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Revenu Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Revenu
 * @subpackage Structs
 */
class Revenu extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The Periodicite
     * @var string
     */
    public $Periodicite;
    /**
     * The Montant
     * @var float
     */
    public $Montant;
    /**
     * The EstPermanent
     * @var bool
     */
    public $EstPermanent;
    /**
     * The TypeRevenu
     * @var string
     */
    public $TypeRevenu;
    /**
     * The TypeRegimeLocation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeRegimeLocation;
    /**
     * Constructor method for Revenu
     * @uses Revenu::setPeriodicite()
     * @uses Revenu::setMontant()
     * @uses Revenu::setEstPermanent()
     * @uses Revenu::setTypeRevenu()
     * @uses Revenu::setTypeRegimeLocation()
     * @param string $periodicite
     * @param float $montant
     * @param bool $estPermanent
     * @param string $typeRevenu
     * @param string $typeRegimeLocation
     */
    public function __construct($periodicite = null, $montant = null, $estPermanent = null, $typeRevenu = null, $typeRegimeLocation = null)
    {
        $this
            ->setPeriodicite($periodicite)
            ->setMontant($montant)
            ->setEstPermanent($estPermanent)
            ->setTypeRevenu($typeRevenu)
            ->setTypeRegimeLocation($typeRegimeLocation);
    }
    /**
     * Get Periodicite value
     * @return string|null
     */
    public function getPeriodicite()
    {
        return $this->Periodicite;
    }
    /**
     * Set Periodicite value
     * @uses \CfcalSasieSDK\Enum\Periodicite::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\Periodicite::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $periodicite
     * @return \CfcalSasieSDK\Entity\Revenu
     */
    public function setPeriodicite($periodicite = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\Periodicite::valueIsValid($periodicite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\Periodicite', is_array($periodicite) ? implode(', ', $periodicite) : var_export($periodicite, true), implode(', ', \CfcalSasieSDK\Enum\Periodicite::getValidValues())), __LINE__);
        }
        $this->Periodicite = $periodicite;
        return $this;
    }
    /**
     * Get Montant value
     * @return float|null
     */
    public function getMontant()
    {
        return $this->Montant;
    }
    /**
     * Set Montant value
     * @param float $montant
     * @return \CfcalSasieSDK\Entity\Revenu
     */
    public function setMontant($montant = null)
    {
        // validation for constraint: float
        if (!is_null($montant) && !(is_float($montant) || is_numeric($montant))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montant, true), gettype($montant)), __LINE__);
        }
        $this->Montant = $montant;
        return $this;
    }
    /**
     * Get EstPermanent value
     * @return bool|null
     */
    public function getEstPermanent()
    {
        return $this->EstPermanent;
    }
    /**
     * Set EstPermanent value
     * @param bool $estPermanent
     * @return \CfcalSasieSDK\Entity\Revenu
     */
    public function setEstPermanent($estPermanent = null)
    {
        // validation for constraint: boolean
        if (!is_null($estPermanent) && !is_bool($estPermanent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estPermanent, true), gettype($estPermanent)), __LINE__);
        }
        $this->EstPermanent = $estPermanent;
        return $this;
    }
    /**
     * Get TypeRevenu value
     * @return string|null
     */
    public function getTypeRevenu()
    {
        return $this->TypeRevenu;
    }
    /**
     * Set TypeRevenu value
     * @uses \CfcalSasieSDK\Enum\TypeRevenu::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeRevenu::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeRevenu
     * @return \CfcalSasieSDK\Entity\Revenu
     */
    public function setTypeRevenu($typeRevenu = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeRevenu::valueIsValid($typeRevenu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeRevenu', is_array($typeRevenu) ? implode(', ', $typeRevenu) : var_export($typeRevenu, true), implode(', ', \CfcalSasieSDK\Enum\TypeRevenu::getValidValues())), __LINE__);
        }
        $this->TypeRevenu = $typeRevenu;
        return $this;
    }
    /**
     * Get TypeRegimeLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeRegimeLocation()
    {
        return isset($this->TypeRegimeLocation) ? $this->TypeRegimeLocation : null;
    }
    /**
     * Set TypeRegimeLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypeRegimeLocation::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeRegimeLocation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeRegimeLocation
     * @return \CfcalSasieSDK\Entity\Revenu
     */
    public function setTypeRegimeLocation($typeRegimeLocation = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeRegimeLocation::valueIsValid($typeRegimeLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeRegimeLocation', is_array($typeRegimeLocation) ? implode(', ', $typeRegimeLocation) : var_export($typeRegimeLocation, true), implode(', ', \CfcalSasieSDK\Enum\TypeRegimeLocation::getValidValues())), __LINE__);
        }
        if (is_null($typeRegimeLocation) || (is_array($typeRegimeLocation) && empty($typeRegimeLocation))) {
            unset($this->TypeRegimeLocation);
        } else {
            $this->TypeRegimeLocation = $typeRegimeLocation;
        }
        return $this;
    }
}
