<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultatOperationPublicBase Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResultatOperationPublicBase
 * @subpackage Structs
 */
class ResultatOperationPublicBase extends ObjetPublicOutilsBase
{
    /**
     * The Statut
     * @var string
     */
    public $Statut;
    /**
     * The Messages
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CfcalSasieSDK\ArrayType\ArrayOfMessage
     */
    public $Messages;
    /**
     * Constructor method for ResultatOperationPublicBase
     * @uses ResultatOperationPublicBase::setStatut()
     * @uses ResultatOperationPublicBase::setMessages()
     * @param string $statut
     * @param \CfcalSasieSDK\ArrayType\ArrayOfMessage $messages
     */
    public function __construct($statut = null, \CfcalSasieSDK\ArrayType\ArrayOfMessage $messages = null)
    {
        $this
            ->setStatut($statut)
            ->setMessages($messages);
    }
    /**
     * Get Statut value
     * @return string|null
     */
    public function getStatut()
    {
        return $this->Statut;
    }
    /**
     * Set Statut value
     * @uses \CfcalSasieSDK\Enum\StatutAppelWebservice::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\StatutAppelWebservice::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statut
     * @return \CfcalSasieSDK\Entity\ResultatOperationPublicBase
     */
    public function setStatut($statut = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\StatutAppelWebservice::valueIsValid($statut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\StatutAppelWebservice', is_array($statut) ? implode(', ', $statut) : var_export($statut, true), implode(', ', \CfcalSasieSDK\Enum\StatutAppelWebservice::getValidValues())), __LINE__);
        }
        $this->Statut = $statut;
        return $this;
    }
    /**
     * Get Messages value
     * @return \CfcalSasieSDK\ArrayType\ArrayOfMessage|null
     */
    public function getMessages()
    {
        return $this->Messages;
    }
    /**
     * Set Messages value
     * @param \CfcalSasieSDK\ArrayType\ArrayOfMessage $messages
     * @return \CfcalSasieSDK\Entity\ResultatOperationPublicBase
     */
    public function setMessages(\CfcalSasieSDK\ArrayType\ArrayOfMessage $messages = null)
    {
        $this->Messages = $messages;
        return $this;
    }
}
