<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultatEtatSaisieEnLigne Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ResultatEtatSaisieEnLigne
 * @subpackage Structs
 */
class ResultatEtatSaisieEnLigne extends ResultatAppelWebservice
{
    /**
     * The Etat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Etat;
    /**
     * The DetailEtatSaisieEnLigne
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\DetailEtatSaisieEnLigne
     */
    public $DetailEtatSaisieEnLigne;
    /**
     * Constructor method for ResultatEtatSaisieEnLigne
     * @uses ResultatEtatSaisieEnLigne::setEtat()
     * @uses ResultatEtatSaisieEnLigne::setDetailEtatSaisieEnLigne()
     * @param string $etat
     * @param \CfcalSasieSDK\Entity\DetailEtatSaisieEnLigne $detailEtatSaisieEnLigne
     */
    public function __construct($etat = null, \CfcalSasieSDK\Entity\DetailEtatSaisieEnLigne $detailEtatSaisieEnLigne = null)
    {
        $this
            ->setEtat($etat)
            ->setDetailEtatSaisieEnLigne($detailEtatSaisieEnLigne);
    }
    /**
     * Get Etat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEtat()
    {
        return isset($this->Etat) ? $this->Etat : null;
    }
    /**
     * Set Etat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\EtatSaisieEnLigne::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\EtatSaisieEnLigne::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $etat
     * @return \CfcalSasieSDK\Entity\ResultatEtatSaisieEnLigne
     */
    public function setEtat($etat = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\EtatSaisieEnLigne::valueIsValid($etat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\EtatSaisieEnLigne', is_array($etat) ? implode(', ', $etat) : var_export($etat, true), implode(', ', \CfcalSasieSDK\Enum\EtatSaisieEnLigne::getValidValues())), __LINE__);
        }
        if (is_null($etat) || (is_array($etat) && empty($etat))) {
            unset($this->Etat);
        } else {
            $this->Etat = $etat;
        }
        return $this;
    }
    /**
     * Get DetailEtatSaisieEnLigne value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\DetailEtatSaisieEnLigne|null
     */
    public function getDetailEtatSaisieEnLigne()
    {
        return isset($this->DetailEtatSaisieEnLigne) ? $this->DetailEtatSaisieEnLigne : null;
    }
    /**
     * Set DetailEtatSaisieEnLigne value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\DetailEtatSaisieEnLigne $detailEtatSaisieEnLigne
     * @return \CfcalSasieSDK\Entity\ResultatEtatSaisieEnLigne
     */
    public function setDetailEtatSaisieEnLigne(\CfcalSasieSDK\Entity\DetailEtatSaisieEnLigne $detailEtatSaisieEnLigne = null)
    {
        if (is_null($detailEtatSaisieEnLigne) || (is_array($detailEtatSaisieEnLigne) && empty($detailEtatSaisieEnLigne))) {
            unset($this->DetailEtatSaisieEnLigne);
        } else {
            $this->DetailEtatSaisieEnLigne = $detailEtatSaisieEnLigne;
        }
        return $this;
    }
}
