<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenceCadastrale Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReferenceCadastrale
 * @subpackage Structs
 */
class ReferenceCadastrale extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The Section
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Section;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Numero;
    /**
     * The LieuDit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LieuDit;
    /**
     * The NombreHectares
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NombreHectares;
    /**
     * The NombreAres
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NombreAres;
    /**
     * The NombreCentiares
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NombreCentiares;
    /**
     * The Nature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nature;
    /**
     * Constructor method for ReferenceCadastrale
     * @uses ReferenceCadastrale::setSection()
     * @uses ReferenceCadastrale::setNumero()
     * @uses ReferenceCadastrale::setLieuDit()
     * @uses ReferenceCadastrale::setNombreHectares()
     * @uses ReferenceCadastrale::setNombreAres()
     * @uses ReferenceCadastrale::setNombreCentiares()
     * @uses ReferenceCadastrale::setNature()
     * @param string $section
     * @param string $numero
     * @param string $lieuDit
     * @param int $nombreHectares
     * @param int $nombreAres
     * @param int $nombreCentiares
     * @param string $nature
     */
    public function __construct($section = null, $numero = null, $lieuDit = null, $nombreHectares = null, $nombreAres = null, $nombreCentiares = null, $nature = null)
    {
        $this
            ->setSection($section)
            ->setNumero($numero)
            ->setLieuDit($lieuDit)
            ->setNombreHectares($nombreHectares)
            ->setNombreAres($nombreAres)
            ->setNombreCentiares($nombreCentiares)
            ->setNature($nature);
    }
    /**
     * Get Section value
     * @return string|null
     */
    public function getSection()
    {
        return $this->Section;
    }
    /**
     * Set Section value
     * @param string $section
     * @return \CfcalSasieSDK\Entity\ReferenceCadastrale
     */
    public function setSection($section = null)
    {
        // validation for constraint: string
        if (!is_null($section) && !is_string($section)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($section, true), gettype($section)), __LINE__);
        }
        $this->Section = $section;
        return $this;
    }
    /**
     * Get Numero value
     * @return string|null
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param string $numero
     * @return \CfcalSasieSDK\Entity\ReferenceCadastrale
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get LieuDit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLieuDit()
    {
        return isset($this->LieuDit) ? $this->LieuDit : null;
    }
    /**
     * Set LieuDit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lieuDit
     * @return \CfcalSasieSDK\Entity\ReferenceCadastrale
     */
    public function setLieuDit($lieuDit = null)
    {
        // validation for constraint: string
        if (!is_null($lieuDit) && !is_string($lieuDit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lieuDit, true), gettype($lieuDit)), __LINE__);
        }
        if (is_null($lieuDit) || (is_array($lieuDit) && empty($lieuDit))) {
            unset($this->LieuDit);
        } else {
            $this->LieuDit = $lieuDit;
        }
        return $this;
    }
    /**
     * Get NombreHectares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNombreHectares()
    {
        return isset($this->NombreHectares) ? $this->NombreHectares : null;
    }
    /**
     * Set NombreHectares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nombreHectares
     * @return \CfcalSasieSDK\Entity\ReferenceCadastrale
     */
    public function setNombreHectares($nombreHectares = null)
    {
        // validation for constraint: int
        if (!is_null($nombreHectares) && !(is_int($nombreHectares) || ctype_digit($nombreHectares))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nombreHectares, true), gettype($nombreHectares)), __LINE__);
        }
        if (is_null($nombreHectares) || (is_array($nombreHectares) && empty($nombreHectares))) {
            unset($this->NombreHectares);
        } else {
            $this->NombreHectares = $nombreHectares;
        }
        return $this;
    }
    /**
     * Get NombreAres value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNombreAres()
    {
        return isset($this->NombreAres) ? $this->NombreAres : null;
    }
    /**
     * Set NombreAres value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nombreAres
     * @return \CfcalSasieSDK\Entity\ReferenceCadastrale
     */
    public function setNombreAres($nombreAres = null)
    {
        // validation for constraint: int
        if (!is_null($nombreAres) && !(is_int($nombreAres) || ctype_digit($nombreAres))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nombreAres, true), gettype($nombreAres)), __LINE__);
        }
        if (is_null($nombreAres) || (is_array($nombreAres) && empty($nombreAres))) {
            unset($this->NombreAres);
        } else {
            $this->NombreAres = $nombreAres;
        }
        return $this;
    }
    /**
     * Get NombreCentiares value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNombreCentiares()
    {
        return isset($this->NombreCentiares) ? $this->NombreCentiares : null;
    }
    /**
     * Set NombreCentiares value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nombreCentiares
     * @return \CfcalSasieSDK\Entity\ReferenceCadastrale
     */
    public function setNombreCentiares($nombreCentiares = null)
    {
        // validation for constraint: int
        if (!is_null($nombreCentiares) && !(is_int($nombreCentiares) || ctype_digit($nombreCentiares))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nombreCentiares, true), gettype($nombreCentiares)), __LINE__);
        }
        if (is_null($nombreCentiares) || (is_array($nombreCentiares) && empty($nombreCentiares))) {
            unset($this->NombreCentiares);
        } else {
            $this->NombreCentiares = $nombreCentiares;
        }
        return $this;
    }
    /**
     * Get Nature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNature()
    {
        return isset($this->Nature) ? $this->Nature : null;
    }
    /**
     * Set Nature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nature
     * @return \CfcalSasieSDK\Entity\ReferenceCadastrale
     */
    public function setNature($nature = null)
    {
        // validation for constraint: string
        if (!is_null($nature) && !is_string($nature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nature, true), gettype($nature)), __LINE__);
        }
        if (is_null($nature) || (is_array($nature) && empty($nature))) {
            unset($this->Nature);
        } else {
            $this->Nature = $nature;
        }
        return $this;
    }
}
