<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Proprietaire Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Proprietaire
 * @subpackage Structs
 */
class Proprietaire extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The IdentifiantIntervenant
     * @var int
     */
    public $IdentifiantIntervenant;
    /**
     * The CodeTypePropriete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypePropriete;
    /**
     * The DateAcquisition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateAcquisition;
    /**
     * The TauxUsufruit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TauxUsufruit;
    /**
     * The TauxNuePropriete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TauxNuePropriete;
    /**
     * Constructor method for Proprietaire
     * @uses Proprietaire::setIdentifiantIntervenant()
     * @uses Proprietaire::setCodeTypePropriete()
     * @uses Proprietaire::setDateAcquisition()
     * @uses Proprietaire::setTauxUsufruit()
     * @uses Proprietaire::setTauxNuePropriete()
     * @param int $identifiantIntervenant
     * @param string $codeTypePropriete
     * @param string $dateAcquisition
     * @param float $tauxUsufruit
     * @param float $tauxNuePropriete
     */
    public function __construct($identifiantIntervenant = null, $codeTypePropriete = null, $dateAcquisition = null, $tauxUsufruit = null, $tauxNuePropriete = null)
    {
        $this
            ->setIdentifiantIntervenant($identifiantIntervenant)
            ->setCodeTypePropriete($codeTypePropriete)
            ->setDateAcquisition($dateAcquisition)
            ->setTauxUsufruit($tauxUsufruit)
            ->setTauxNuePropriete($tauxNuePropriete);
    }
    /**
     * Get IdentifiantIntervenant value
     * @return int|null
     */
    public function getIdentifiantIntervenant()
    {
        return $this->IdentifiantIntervenant;
    }
    /**
     * Set IdentifiantIntervenant value
     * @param int $identifiantIntervenant
     * @return \CfcalSasieSDK\Entity\Proprietaire
     */
    public function setIdentifiantIntervenant($identifiantIntervenant = null)
    {
        // validation for constraint: int
        if (!is_null($identifiantIntervenant) && !(is_int($identifiantIntervenant) || ctype_digit($identifiantIntervenant))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($identifiantIntervenant, true), gettype($identifiantIntervenant)), __LINE__);
        }
        $this->IdentifiantIntervenant = $identifiantIntervenant;
        return $this;
    }
    /**
     * Get CodeTypePropriete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypePropriete()
    {
        return isset($this->CodeTypePropriete) ? $this->CodeTypePropriete : null;
    }
    /**
     * Set CodeTypePropriete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\Propriete::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\Propriete::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypePropriete
     * @return \CfcalSasieSDK\Entity\Proprietaire
     */
    public function setCodeTypePropriete($codeTypePropriete = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\Propriete::valueIsValid($codeTypePropriete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\Propriete', is_array($codeTypePropriete) ? implode(', ', $codeTypePropriete) : var_export($codeTypePropriete, true), implode(', ', \CfcalSasieSDK\Enum\Propriete::getValidValues())), __LINE__);
        }
        if (is_null($codeTypePropriete) || (is_array($codeTypePropriete) && empty($codeTypePropriete))) {
            unset($this->CodeTypePropriete);
        } else {
            $this->CodeTypePropriete = $codeTypePropriete;
        }
        return $this;
    }
    /**
     * Get DateAcquisition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateAcquisition()
    {
        return isset($this->DateAcquisition) ? $this->DateAcquisition : null;
    }
    /**
     * Set DateAcquisition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateAcquisition
     * @return \CfcalSasieSDK\Entity\Proprietaire
     */
    public function setDateAcquisition($dateAcquisition = null)
    {
        // validation for constraint: string
        if (!is_null($dateAcquisition) && !is_string($dateAcquisition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateAcquisition, true), gettype($dateAcquisition)), __LINE__);
        }
        if (is_null($dateAcquisition) || (is_array($dateAcquisition) && empty($dateAcquisition))) {
            unset($this->DateAcquisition);
        } else {
            $this->DateAcquisition = $dateAcquisition;
        }
        return $this;
    }
    /**
     * Get TauxUsufruit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTauxUsufruit()
    {
        return isset($this->TauxUsufruit) ? $this->TauxUsufruit : null;
    }
    /**
     * Set TauxUsufruit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $tauxUsufruit
     * @return \CfcalSasieSDK\Entity\Proprietaire
     */
    public function setTauxUsufruit($tauxUsufruit = null)
    {
        // validation for constraint: float
        if (!is_null($tauxUsufruit) && !(is_float($tauxUsufruit) || is_numeric($tauxUsufruit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tauxUsufruit, true), gettype($tauxUsufruit)), __LINE__);
        }
        if (is_null($tauxUsufruit) || (is_array($tauxUsufruit) && empty($tauxUsufruit))) {
            unset($this->TauxUsufruit);
        } else {
            $this->TauxUsufruit = $tauxUsufruit;
        }
        return $this;
    }
    /**
     * Get TauxNuePropriete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTauxNuePropriete()
    {
        return isset($this->TauxNuePropriete) ? $this->TauxNuePropriete : null;
    }
    /**
     * Set TauxNuePropriete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $tauxNuePropriete
     * @return \CfcalSasieSDK\Entity\Proprietaire
     */
    public function setTauxNuePropriete($tauxNuePropriete = null)
    {
        // validation for constraint: float
        if (!is_null($tauxNuePropriete) && !(is_float($tauxNuePropriete) || is_numeric($tauxNuePropriete))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tauxNuePropriete, true), gettype($tauxNuePropriete)), __LINE__);
        }
        if (is_null($tauxNuePropriete) || (is_array($tauxNuePropriete) && empty($tauxNuePropriete))) {
            unset($this->TauxNuePropriete);
        } else {
            $this->TauxNuePropriete = $tauxNuePropriete;
        }
        return $this;
    }
}
