<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrixAcquisitionBien Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PrixAcquisitionBien
 * @subpackage Structs
 */
class PrixAcquisitionBien extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The DateEstimation
     * @var string
     */
    public $DateEstimation;
    /**
     * The PrixAcquisition
     * @var float
     */
    public $PrixAcquisition;
    /**
     * The NomEstimateur
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomEstimateur;
    /**
     * The CodeTypeEstimation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypeEstimation;
    /**
     * Constructor method for PrixAcquisitionBien
     * @uses PrixAcquisitionBien::setDateEstimation()
     * @uses PrixAcquisitionBien::setPrixAcquisition()
     * @uses PrixAcquisitionBien::setNomEstimateur()
     * @uses PrixAcquisitionBien::setCodeTypeEstimation()
     * @param string $dateEstimation
     * @param float $prixAcquisition
     * @param string $nomEstimateur
     * @param string $codeTypeEstimation
     */
    public function __construct($dateEstimation = null, $prixAcquisition = null, $nomEstimateur = null, $codeTypeEstimation = null)
    {
        $this
            ->setDateEstimation($dateEstimation)
            ->setPrixAcquisition($prixAcquisition)
            ->setNomEstimateur($nomEstimateur)
            ->setCodeTypeEstimation($codeTypeEstimation);
    }
    /**
     * Get DateEstimation value
     * @return string|null
     */
    public function getDateEstimation()
    {
        return $this->DateEstimation;
    }
    /**
     * Set DateEstimation value
     * @param string $dateEstimation
     * @return \CfcalSasieSDK\Entity\PrixAcquisitionBien
     */
    public function setDateEstimation($dateEstimation = null)
    {
        // validation for constraint: string
        if (!is_null($dateEstimation) && !is_string($dateEstimation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEstimation, true), gettype($dateEstimation)), __LINE__);
        }
        $this->DateEstimation = $dateEstimation;
        return $this;
    }
    /**
     * Get PrixAcquisition value
     * @return float|null
     */
    public function getPrixAcquisition()
    {
        return $this->PrixAcquisition;
    }
    /**
     * Set PrixAcquisition value
     * @param float $prixAcquisition
     * @return \CfcalSasieSDK\Entity\PrixAcquisitionBien
     */
    public function setPrixAcquisition($prixAcquisition = null)
    {
        // validation for constraint: float
        if (!is_null($prixAcquisition) && !(is_float($prixAcquisition) || is_numeric($prixAcquisition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prixAcquisition, true), gettype($prixAcquisition)), __LINE__);
        }
        $this->PrixAcquisition = $prixAcquisition;
        return $this;
    }
    /**
     * Get NomEstimateur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomEstimateur()
    {
        return isset($this->NomEstimateur) ? $this->NomEstimateur : null;
    }
    /**
     * Set NomEstimateur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomEstimateur
     * @return \CfcalSasieSDK\Entity\PrixAcquisitionBien
     */
    public function setNomEstimateur($nomEstimateur = null)
    {
        // validation for constraint: string
        if (!is_null($nomEstimateur) && !is_string($nomEstimateur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomEstimateur, true), gettype($nomEstimateur)), __LINE__);
        }
        if (is_null($nomEstimateur) || (is_array($nomEstimateur) && empty($nomEstimateur))) {
            unset($this->NomEstimateur);
        } else {
            $this->NomEstimateur = $nomEstimateur;
        }
        return $this;
    }
    /**
     * Get CodeTypeEstimation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeEstimation()
    {
        return isset($this->CodeTypeEstimation) ? $this->CodeTypeEstimation : null;
    }
    /**
     * Set CodeTypeEstimation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\EstimationAcquisition::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\EstimationAcquisition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeEstimation
     * @return \CfcalSasieSDK\Entity\PrixAcquisitionBien
     */
    public function setCodeTypeEstimation($codeTypeEstimation = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\EstimationAcquisition::valueIsValid($codeTypeEstimation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\EstimationAcquisition', is_array($codeTypeEstimation) ? implode(', ', $codeTypeEstimation) : var_export($codeTypeEstimation, true), implode(', ', \CfcalSasieSDK\Enum\EstimationAcquisition::getValidValues())), __LINE__);
        }
        if (is_null($codeTypeEstimation) || (is_array($codeTypeEstimation) && empty($codeTypeEstimation))) {
            unset($this->CodeTypeEstimation);
        } else {
            $this->CodeTypeEstimation = $codeTypeEstimation;
        }
        return $this;
    }
}
