<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Piece Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Piece
 * @subpackage Structs
 */
class Piece extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The NomFichier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $NomFichier;
    /**
     * The Fichier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Fichier;
    /**
     * The EmprunteMD5DuFichier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmprunteMD5DuFichier;
    /**
     * The TypeDocument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeDocument;
    /**
     * Constructor method for Piece
     * @uses Piece::setNomFichier()
     * @uses Piece::setFichier()
     * @uses Piece::setEmprunteMD5DuFichier()
     * @uses Piece::setTypeDocument()
     * @param string $nomFichier
     * @param string $fichier
     * @param string $emprunteMD5DuFichier
     * @param string $typeDocument
     */
    public function __construct($nomFichier = null, $fichier = null, $emprunteMD5DuFichier = null, $typeDocument = null)
    {
        $this
            ->setNomFichier($nomFichier)
            ->setFichier($fichier)
            ->setEmprunteMD5DuFichier($emprunteMD5DuFichier)
            ->setTypeDocument($typeDocument);
    }
    /**
     * Get NomFichier value
     * @return string|null
     */
    public function getNomFichier()
    {
        return $this->NomFichier;
    }
    /**
     * Set NomFichier value
     * @param string $nomFichier
     * @return \CfcalSasieSDK\Entity\Piece
     */
    public function setNomFichier($nomFichier = null)
    {
        // validation for constraint: string
        if (!is_null($nomFichier) && !is_string($nomFichier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomFichier, true), gettype($nomFichier)), __LINE__);
        }
        $this->NomFichier = $nomFichier;
        return $this;
    }
    /**
     * Get Fichier value
     * @return string|null
     */
    public function getFichier()
    {
        return $this->Fichier;
    }
    /**
     * Set Fichier value
     * @param string $fichier
     * @return \CfcalSasieSDK\Entity\Piece
     */
    public function setFichier($fichier = null)
    {
        // validation for constraint: string
        if (!is_null($fichier) && !is_string($fichier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fichier, true), gettype($fichier)), __LINE__);
        }
        $this->Fichier = $fichier;
        return $this;
    }
    /**
     * Get EmprunteMD5DuFichier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmprunteMD5DuFichier()
    {
        return isset($this->EmprunteMD5DuFichier) ? $this->EmprunteMD5DuFichier : null;
    }
    /**
     * Set EmprunteMD5DuFichier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emprunteMD5DuFichier
     * @return \CfcalSasieSDK\Entity\Piece
     */
    public function setEmprunteMD5DuFichier($emprunteMD5DuFichier = null)
    {
        // validation for constraint: string
        if (!is_null($emprunteMD5DuFichier) && !is_string($emprunteMD5DuFichier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emprunteMD5DuFichier, true), gettype($emprunteMD5DuFichier)), __LINE__);
        }
        if (is_null($emprunteMD5DuFichier) || (is_array($emprunteMD5DuFichier) && empty($emprunteMD5DuFichier))) {
            unset($this->EmprunteMD5DuFichier);
        } else {
            $this->EmprunteMD5DuFichier = $emprunteMD5DuFichier;
        }
        return $this;
    }
    /**
     * Get TypeDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeDocument()
    {
        return isset($this->TypeDocument) ? $this->TypeDocument : null;
    }
    /**
     * Set TypeDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypeDocumentDossierDePret::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeDocumentDossierDePret::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeDocument
     * @return \CfcalSasieSDK\Entity\Piece
     */
    public function setTypeDocument($typeDocument = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeDocumentDossierDePret::valueIsValid($typeDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeDocumentDossierDePret', is_array($typeDocument) ? implode(', ', $typeDocument) : var_export($typeDocument, true), implode(', ', \CfcalSasieSDK\Enum\TypeDocumentDossierDePret::getValidValues())), __LINE__);
        }
        if (is_null($typeDocument) || (is_array($typeDocument) && empty($typeDocument))) {
            unset($this->TypeDocument);
        } else {
            $this->TypeDocument = $typeDocument;
        }
        return $this;
    }
}
