<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonneACharge Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PersonneACharge
 * @subpackage Structs
 */
class PersonneACharge extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The CodeTypeSexe
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodeTypeSexe;
    /**
     * The Nom
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Nom;
    /**
     * The DateNaissance
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DateNaissance;
    /**
     * The LienFamilial
     * @var string
     */
    public $LienFamilial;
    /**
     * Constructor method for PersonneACharge
     * @uses PersonneACharge::setCodeTypeSexe()
     * @uses PersonneACharge::setNom()
     * @uses PersonneACharge::setDateNaissance()
     * @uses PersonneACharge::setLienFamilial()
     * @param string $codeTypeSexe
     * @param string $nom
     * @param string $dateNaissance
     * @param string $lienFamilial
     */
    public function __construct($codeTypeSexe = null, $nom = null, $dateNaissance = null, $lienFamilial = null)
    {
        $this
            ->setCodeTypeSexe($codeTypeSexe)
            ->setNom($nom)
            ->setDateNaissance($dateNaissance)
            ->setLienFamilial($lienFamilial);
    }
    /**
     * Get CodeTypeSexe value
     * @return string|null
     */
    public function getCodeTypeSexe()
    {
        return $this->CodeTypeSexe;
    }
    /**
     * Set CodeTypeSexe value
     * @uses \CfcalSasieSDK\Enum\Sexe::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\Sexe::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeSexe
     * @return \CfcalSasieSDK\Entity\PersonneACharge
     */
    public function setCodeTypeSexe($codeTypeSexe = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\Sexe::valueIsValid($codeTypeSexe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\Sexe', is_array($codeTypeSexe) ? implode(', ', $codeTypeSexe) : var_export($codeTypeSexe, true), implode(', ', \CfcalSasieSDK\Enum\Sexe::getValidValues())), __LINE__);
        }
        $this->CodeTypeSexe = $codeTypeSexe;
        return $this;
    }
    /**
     * Get Nom value
     * @return string|null
     */
    public function getNom()
    {
        return $this->Nom;
    }
    /**
     * Set Nom value
     * @param string $nom
     * @return \CfcalSasieSDK\Entity\PersonneACharge
     */
    public function setNom($nom = null)
    {
        // validation for constraint: string
        if (!is_null($nom) && !is_string($nom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom, true), gettype($nom)), __LINE__);
        }
        $this->Nom = $nom;
        return $this;
    }
    /**
     * Get DateNaissance value
     * @return string|null
     */
    public function getDateNaissance()
    {
        return $this->DateNaissance;
    }
    /**
     * Set DateNaissance value
     * @param string $dateNaissance
     * @return \CfcalSasieSDK\Entity\PersonneACharge
     */
    public function setDateNaissance($dateNaissance = null)
    {
        // validation for constraint: string
        if (!is_null($dateNaissance) && !is_string($dateNaissance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateNaissance, true), gettype($dateNaissance)), __LINE__);
        }
        $this->DateNaissance = $dateNaissance;
        return $this;
    }
    /**
     * Get LienFamilial value
     * @return string|null
     */
    public function getLienFamilial()
    {
        return $this->LienFamilial;
    }
    /**
     * Set LienFamilial value
     * @uses \CfcalSasieSDK\Enum\TypeLienFamilial::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeLienFamilial::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $lienFamilial
     * @return \CfcalSasieSDK\Entity\PersonneACharge
     */
    public function setLienFamilial($lienFamilial = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeLienFamilial::valueIsValid($lienFamilial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeLienFamilial', is_array($lienFamilial) ? implode(', ', $lienFamilial) : var_export($lienFamilial, true), implode(', ', \CfcalSasieSDK\Enum\TypeLienFamilial::getValidValues())), __LINE__);
        }
        $this->LienFamilial = $lienFamilial;
        return $this;
    }
}
