<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Message Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Message
 * @subpackage Structs
 */
class Message extends ObjetPublicOutilsBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Code;
    /**
     * The Libelle
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Libelle;
    /**
     * Constructor method for Message
     * @uses Message::setCode()
     * @uses Message::setLibelle()
     * @param string $code
     * @param string $libelle
     */
    public function __construct($code = null, $libelle = null)
    {
        $this
            ->setCode($code)
            ->setLibelle($libelle);
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \CfcalSasieSDK\Entity\Message
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Libelle value
     * @return string|null
     */
    public function getLibelle()
    {
        return $this->Libelle;
    }
    /**
     * Set Libelle value
     * @param string $libelle
     * @return \CfcalSasieSDK\Entity\Message
     */
    public function setLibelle($libelle = null)
    {
        // validation for constraint: string
        if (!is_null($libelle) && !is_string($libelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($libelle, true), gettype($libelle)), __LINE__);
        }
        $this->Libelle = $libelle;
        return $this;
    }
}
