<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Liens Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Liens
 * @subpackage Structs
 */
class Liens extends AbstractStructBase
{
    /**
     * The Lien
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Lien[]
     */
    public $Lien;
    /**
     * Constructor method for Liens
     * @uses Liens::setLien()
     * @param \CfcalSasieSDK\Entity\Lien[] $lien
     */
    public function __construct(array $lien = array())
    {
        $this
            ->setLien($lien);
    }
    /**
     * Get Lien value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Lien[]|null
     */
    public function getLien()
    {
        return isset($this->Lien) ? $this->Lien : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLien method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLien method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLienForArrayConstraintsFromSetLien(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $liensLienItem) {
            // validation for constraint: itemType
            if (!$liensLienItem instanceof \CfcalSasieSDK\Entity\Lien) {
                $invalidValues[] = is_object($liensLienItem) ? get_class($liensLienItem) : sprintf('%s(%s)', gettype($liensLienItem), var_export($liensLienItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Lien property can only contain items of type \CfcalSasieSDK\Entity\Lien, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Lien value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Lien[] $lien
     * @return \CfcalSasieSDK\Entity\Liens
     */
    public function setLien(array $lien = array())
    {
        // validation for constraint: array
        if ('' !== ($lienArrayErrorMessage = self::validateLienForArrayConstraintsFromSetLien($lien))) {
            throw new \InvalidArgumentException($lienArrayErrorMessage, __LINE__);
        }
        if (is_null($lien) || (is_array($lien) && empty($lien))) {
            unset($this->Lien);
        } else {
            $this->Lien = $lien;
        }
        return $this;
    }
    /**
     * Add item to Lien value
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Lien $item
     * @return \CfcalSasieSDK\Entity\Liens
     */
    public function addToLien(\CfcalSasieSDK\Entity\Lien $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CfcalSasieSDK\Entity\Lien) {
            throw new \InvalidArgumentException(sprintf('The Lien property can only contain items of type \CfcalSasieSDK\Entity\Lien, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Lien[] = $item;
        return $this;
    }
}
