<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Lien Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Lien
 * @subpackage Structs
 */
class Lien extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The CodeTypeLien
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CodeTypeLien;
    /**
     * The AdresseCommune
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AdresseCommune;
    /**
     * The Menage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Menage;
    /**
     * Constructor method for Lien
     * @uses Lien::setCodeTypeLien()
     * @uses Lien::setAdresseCommune()
     * @uses Lien::setMenage()
     * @param string $codeTypeLien
     * @param bool $adresseCommune
     * @param bool $menage
     */
    public function __construct($codeTypeLien = null, $adresseCommune = null, $menage = null)
    {
        $this
            ->setCodeTypeLien($codeTypeLien)
            ->setAdresseCommune($adresseCommune)
            ->setMenage($menage);
    }
    /**
     * Get CodeTypeLien value
     * @return string|null
     */
    public function getCodeTypeLien()
    {
        return $this->CodeTypeLien;
    }
    /**
     * Set CodeTypeLien value
     * @uses \CfcalSasieSDK\Enum\TypeLien::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeLien::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeLien
     * @return \CfcalSasieSDK\Entity\Lien
     */
    public function setCodeTypeLien($codeTypeLien = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeLien::valueIsValid($codeTypeLien)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeLien', is_array($codeTypeLien) ? implode(', ', $codeTypeLien) : var_export($codeTypeLien, true), implode(', ', \CfcalSasieSDK\Enum\TypeLien::getValidValues())), __LINE__);
        }
        $this->CodeTypeLien = $codeTypeLien;
        return $this;
    }
    /**
     * Get AdresseCommune value
     * @return bool|null
     */
    public function getAdresseCommune()
    {
        return $this->AdresseCommune;
    }
    /**
     * Set AdresseCommune value
     * @param bool $adresseCommune
     * @return \CfcalSasieSDK\Entity\Lien
     */
    public function setAdresseCommune($adresseCommune = null)
    {
        // validation for constraint: boolean
        if (!is_null($adresseCommune) && !is_bool($adresseCommune)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($adresseCommune, true), gettype($adresseCommune)), __LINE__);
        }
        $this->AdresseCommune = $adresseCommune;
        return $this;
    }
    /**
     * Get Menage value
     * @return bool|null
     */
    public function getMenage()
    {
        return $this->Menage;
    }
    /**
     * Set Menage value
     * @param bool $menage
     * @return \CfcalSasieSDK\Entity\Lien
     */
    public function setMenage($menage = null)
    {
        // validation for constraint: boolean
        if (!is_null($menage) && !is_bool($menage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($menage, true), gettype($menage)), __LINE__);
        }
        $this->Menage = $menage;
        return $this;
    }
}
