<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InformationsListeDocumentSaisieEnLigne Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InformationsListeDocumentSaisieEnLigne
 * @subpackage Structs
 */
class InformationsListeDocumentSaisieEnLigne extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The CodeSaisieEnLigne
     * @var int
     */
    public $CodeSaisieEnLigne;
    /**
     * The TypeEdition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $TypeEdition;
    /**
     * Constructor method for InformationsListeDocumentSaisieEnLigne
     * @uses InformationsListeDocumentSaisieEnLigne::setCodeSaisieEnLigne()
     * @uses InformationsListeDocumentSaisieEnLigne::setTypeEdition()
     * @param int $codeSaisieEnLigne
     * @param string[] $typeEdition
     */
    public function __construct($codeSaisieEnLigne = null, array $typeEdition = array())
    {
        $this
            ->setCodeSaisieEnLigne($codeSaisieEnLigne)
            ->setTypeEdition($typeEdition);
    }
    /**
     * Get CodeSaisieEnLigne value
     * @return int|null
     */
    public function getCodeSaisieEnLigne()
    {
        return $this->CodeSaisieEnLigne;
    }
    /**
     * Set CodeSaisieEnLigne value
     * @param int $codeSaisieEnLigne
     * @return \CfcalSasieSDK\Entity\InformationsListeDocumentSaisieEnLigne
     */
    public function setCodeSaisieEnLigne($codeSaisieEnLigne = null)
    {
        // validation for constraint: int
        if (!is_null($codeSaisieEnLigne) && !(is_int($codeSaisieEnLigne) || ctype_digit($codeSaisieEnLigne))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeSaisieEnLigne, true), gettype($codeSaisieEnLigne)), __LINE__);
        }
        $this->CodeSaisieEnLigne = $codeSaisieEnLigne;
        return $this;
    }
    /**
     * Get TypeEdition value
     * @return string[]|null
     */
    public function getTypeEdition()
    {
        return $this->TypeEdition;
    }
    /**
     * This method is responsible for validating the values passed to the setTypeEdition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypeEdition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeEditionForArrayConstraintsFromSetTypeEdition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $informationsListeDocumentSaisieEnLigneTypeEditionItem) {
            // validation for constraint: enumeration
            if (!\CfcalSasieSDK\Enum\TypeSaisieEnLigneEdition::valueIsValid($informationsListeDocumentSaisieEnLigneTypeEditionItem)) {
                $invalidValues[] = is_object($informationsListeDocumentSaisieEnLigneTypeEditionItem) ? get_class($informationsListeDocumentSaisieEnLigneTypeEditionItem) : sprintf('%s(%s)', gettype($informationsListeDocumentSaisieEnLigneTypeEditionItem), var_export($informationsListeDocumentSaisieEnLigneTypeEditionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeSaisieEnLigneEdition', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \CfcalSasieSDK\Enum\TypeSaisieEnLigneEdition::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TypeEdition value
     * @uses \CfcalSasieSDK\Enum\TypeSaisieEnLigneEdition::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeSaisieEnLigneEdition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $typeEdition
     * @return \CfcalSasieSDK\Entity\InformationsListeDocumentSaisieEnLigne
     */
    public function setTypeEdition(array $typeEdition = array())
    {
        // validation for constraint: list
        if ('' !== ($typeEditionArrayErrorMessage = self::validateTypeEditionForArrayConstraintsFromSetTypeEdition($typeEdition))) {
            throw new \InvalidArgumentException($typeEditionArrayErrorMessage, __LINE__);
        }
        $this->TypeEdition = is_array($typeEdition) ? implode(' ', $typeEdition) : null;
        return $this;
    }
}
