<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InformationsIntegrationSaisieEnLigne Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InformationsIntegrationSaisieEnLigne
 * @subpackage Structs
 */
class InformationsIntegrationSaisieEnLigne extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The CodeSaisieEnLigne
     * @var int
     */
    public $CodeSaisieEnLigne;
    /**
     * The ForcerDeclassement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ForcerDeclassement;
    /**
     * Constructor method for InformationsIntegrationSaisieEnLigne
     * @uses InformationsIntegrationSaisieEnLigne::setCodeSaisieEnLigne()
     * @uses InformationsIntegrationSaisieEnLigne::setForcerDeclassement()
     * @param int $codeSaisieEnLigne
     * @param bool $forcerDeclassement
     */
    public function __construct($codeSaisieEnLigne = null, $forcerDeclassement = null)
    {
        $this
            ->setCodeSaisieEnLigne($codeSaisieEnLigne)
            ->setForcerDeclassement($forcerDeclassement);
    }
    /**
     * Get CodeSaisieEnLigne value
     * @return int|null
     */
    public function getCodeSaisieEnLigne()
    {
        return $this->CodeSaisieEnLigne;
    }
    /**
     * Set CodeSaisieEnLigne value
     * @param int $codeSaisieEnLigne
     * @return \CfcalSasieSDK\Entity\InformationsIntegrationSaisieEnLigne
     */
    public function setCodeSaisieEnLigne($codeSaisieEnLigne = null)
    {
        // validation for constraint: int
        if (!is_null($codeSaisieEnLigne) && !(is_int($codeSaisieEnLigne) || ctype_digit($codeSaisieEnLigne))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeSaisieEnLigne, true), gettype($codeSaisieEnLigne)), __LINE__);
        }
        $this->CodeSaisieEnLigne = $codeSaisieEnLigne;
        return $this;
    }
    /**
     * Get ForcerDeclassement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getForcerDeclassement()
    {
        return isset($this->ForcerDeclassement) ? $this->ForcerDeclassement : null;
    }
    /**
     * Set ForcerDeclassement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $forcerDeclassement
     * @return \CfcalSasieSDK\Entity\InformationsIntegrationSaisieEnLigne
     */
    public function setForcerDeclassement($forcerDeclassement = null)
    {
        // validation for constraint: boolean
        if (!is_null($forcerDeclassement) && !is_bool($forcerDeclassement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($forcerDeclassement, true), gettype($forcerDeclassement)), __LINE__);
        }
        if (is_null($forcerDeclassement) || (is_array($forcerDeclassement) && empty($forcerDeclassement))) {
            unset($this->ForcerDeclassement);
        } else {
            $this->ForcerDeclassement = $forcerDeclassement;
        }
        return $this;
    }
}
