<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InformationsGenerationDocumentSaisieEnLigne Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:InformationsGenerationDocumentSaisieEnLigne
 * @subpackage Structs
 */
class InformationsGenerationDocumentSaisieEnLigne extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The CodeSaisieEnLigne
     * @var int
     */
    public $CodeSaisieEnLigne;
    /**
     * The CodeDocumentInformation
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodeDocumentInformation;
    /**
     * Constructor method for InformationsGenerationDocumentSaisieEnLigne
     * @uses InformationsGenerationDocumentSaisieEnLigne::setCodeSaisieEnLigne()
     * @uses InformationsGenerationDocumentSaisieEnLigne::setCodeDocumentInformation()
     * @param int $codeSaisieEnLigne
     * @param string $codeDocumentInformation
     */
    public function __construct($codeSaisieEnLigne = null, $codeDocumentInformation = null)
    {
        $this
            ->setCodeSaisieEnLigne($codeSaisieEnLigne)
            ->setCodeDocumentInformation($codeDocumentInformation);
    }
    /**
     * Get CodeSaisieEnLigne value
     * @return int|null
     */
    public function getCodeSaisieEnLigne()
    {
        return $this->CodeSaisieEnLigne;
    }
    /**
     * Set CodeSaisieEnLigne value
     * @param int $codeSaisieEnLigne
     * @return \CfcalSasieSDK\Entity\InformationsGenerationDocumentSaisieEnLigne
     */
    public function setCodeSaisieEnLigne($codeSaisieEnLigne = null)
    {
        // validation for constraint: int
        if (!is_null($codeSaisieEnLigne) && !(is_int($codeSaisieEnLigne) || ctype_digit($codeSaisieEnLigne))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeSaisieEnLigne, true), gettype($codeSaisieEnLigne)), __LINE__);
        }
        $this->CodeSaisieEnLigne = $codeSaisieEnLigne;
        return $this;
    }
    /**
     * Get CodeDocumentInformation value
     * @return string|null
     */
    public function getCodeDocumentInformation()
    {
        return $this->CodeDocumentInformation;
    }
    /**
     * Set CodeDocumentInformation value
     * @param string $codeDocumentInformation
     * @return \CfcalSasieSDK\Entity\InformationsGenerationDocumentSaisieEnLigne
     */
    public function setCodeDocumentInformation($codeDocumentInformation = null)
    {
        // validation for constraint: string
        if (!is_null($codeDocumentInformation) && !is_string($codeDocumentInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeDocumentInformation, true), gettype($codeDocumentInformation)), __LINE__);
        }
        $this->CodeDocumentInformation = $codeDocumentInformation;
        return $this;
    }
}
