<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IBAN Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:IBAN
 * @subpackage Structs
 */
class IBAN extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The Domiciliation
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Domiciliation;
    /**
     * The Adresse
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Adresse;
    /**
     * The Ville
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Ville
     */
    public $Ville;
    /**
     * The IBAN
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $IBAN;
    /**
     * The BIC
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $BIC;
    /**
     * Constructor method for IBAN
     * @uses IBAN::setDomiciliation()
     * @uses IBAN::setAdresse()
     * @uses IBAN::setVille()
     * @uses IBAN::setIBAN()
     * @uses IBAN::setBIC()
     * @param string $domiciliation
     * @param string $adresse
     * @param \CfcalSasieSDK\Entity\Ville $ville
     * @param string $iBAN
     * @param string $bIC
     */
    public function __construct($domiciliation = null, $adresse = null, \CfcalSasieSDK\Entity\Ville $ville = null, $iBAN = null, $bIC = null)
    {
        $this
            ->setDomiciliation($domiciliation)
            ->setAdresse($adresse)
            ->setVille($ville)
            ->setIBAN($iBAN)
            ->setBIC($bIC);
    }
    /**
     * Get Domiciliation value
     * @return string|null
     */
    public function getDomiciliation()
    {
        return $this->Domiciliation;
    }
    /**
     * Set Domiciliation value
     * @param string $domiciliation
     * @return \CfcalSasieSDK\Entity\IBAN
     */
    public function setDomiciliation($domiciliation = null)
    {
        // validation for constraint: string
        if (!is_null($domiciliation) && !is_string($domiciliation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domiciliation, true), gettype($domiciliation)), __LINE__);
        }
        $this->Domiciliation = $domiciliation;
        return $this;
    }
    /**
     * Get Adresse value
     * @return string|null
     */
    public function getAdresse()
    {
        return $this->Adresse;
    }
    /**
     * Set Adresse value
     * @param string $adresse
     * @return \CfcalSasieSDK\Entity\IBAN
     */
    public function setAdresse($adresse = null)
    {
        // validation for constraint: string
        if (!is_null($adresse) && !is_string($adresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresse, true), gettype($adresse)), __LINE__);
        }
        $this->Adresse = $adresse;
        return $this;
    }
    /**
     * Get Ville value
     * @return \CfcalSasieSDK\Entity\Ville|null
     */
    public function getVille()
    {
        return $this->Ville;
    }
    /**
     * Set Ville value
     * @param \CfcalSasieSDK\Entity\Ville $ville
     * @return \CfcalSasieSDK\Entity\IBAN
     */
    public function setVille(\CfcalSasieSDK\Entity\Ville $ville = null)
    {
        $this->Ville = $ville;
        return $this;
    }
    /**
     * Get IBAN value
     * @return string|null
     */
    public function getIBAN()
    {
        return $this->IBAN;
    }
    /**
     * Set IBAN value
     * @param string $iBAN
     * @return \CfcalSasieSDK\Entity\IBAN
     */
    public function setIBAN($iBAN = null)
    {
        // validation for constraint: string
        if (!is_null($iBAN) && !is_string($iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iBAN, true), gettype($iBAN)), __LINE__);
        }
        $this->IBAN = $iBAN;
        return $this;
    }
    /**
     * Get BIC value
     * @return string|null
     */
    public function getBIC()
    {
        return $this->BIC;
    }
    /**
     * Set BIC value
     * @param string $bIC
     * @return \CfcalSasieSDK\Entity\IBAN
     */
    public function setBIC($bIC = null)
    {
        // validation for constraint: string
        if (!is_null($bIC) && !is_string($bIC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bIC, true), gettype($bIC)), __LINE__);
        }
        $this->BIC = $bIC;
        return $this;
    }
}
