<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Garanties Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Garanties
 * @subpackage Structs
 */
class Garanties extends AbstractStructBase
{
    /**
     * The Garantie
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Garantie[]
     */
    public $Garantie;
    /**
     * Constructor method for Garanties
     * @uses Garanties::setGarantie()
     * @param \CfcalSasieSDK\Entity\Garantie[] $garantie
     */
    public function __construct(array $garantie = array())
    {
        $this
            ->setGarantie($garantie);
    }
    /**
     * Get Garantie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Garantie[]|null
     */
    public function getGarantie()
    {
        return isset($this->Garantie) ? $this->Garantie : null;
    }
    /**
     * This method is responsible for validating the values passed to the setGarantie method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGarantie method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGarantieForArrayConstraintsFromSetGarantie(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $garantiesGarantieItem) {
            // validation for constraint: itemType
            if (!$garantiesGarantieItem instanceof \CfcalSasieSDK\Entity\Garantie) {
                $invalidValues[] = is_object($garantiesGarantieItem) ? get_class($garantiesGarantieItem) : sprintf('%s(%s)', gettype($garantiesGarantieItem), var_export($garantiesGarantieItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Garantie property can only contain items of type \CfcalSasieSDK\Entity\Garantie, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Garantie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Garantie[] $garantie
     * @return \CfcalSasieSDK\Entity\Garanties
     */
    public function setGarantie(array $garantie = array())
    {
        // validation for constraint: array
        if ('' !== ($garantieArrayErrorMessage = self::validateGarantieForArrayConstraintsFromSetGarantie($garantie))) {
            throw new \InvalidArgumentException($garantieArrayErrorMessage, __LINE__);
        }
        if (is_null($garantie) || (is_array($garantie) && empty($garantie))) {
            unset($this->Garantie);
        } else {
            $this->Garantie = $garantie;
        }
        return $this;
    }
    /**
     * Add item to Garantie value
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Garantie $item
     * @return \CfcalSasieSDK\Entity\Garanties
     */
    public function addToGarantie(\CfcalSasieSDK\Entity\Garantie $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CfcalSasieSDK\Entity\Garantie) {
            throw new \InvalidArgumentException(sprintf('The Garantie property can only contain items of type \CfcalSasieSDK\Entity\Garantie, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Garantie[] = $item;
        return $this;
    }
}
