<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Garantie Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Garantie
 * @subpackage Structs
 */
class Garantie extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The Adresse
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Adresse;
    /**
     * The Environnement
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Environnement;
    /**
     * The Ville
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Ville
     */
    public $Ville;
    /**
     * The Biens
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Biens
     */
    public $Biens;
    /**
     * The Proprietaires
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Proprietaires
     */
    public $Proprietaires;
    /**
     * The ReferencesCadastrales
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\ReferenceCadastrales
     */
    public $ReferencesCadastrales;
    /**
     * The CodeAcquisition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CodeAcquisition;
    /**
     * The EstBienEnAcquisition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EstBienEnAcquisition;
    /**
     * The CodeTypeGarantie
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CodeTypeGarantie;
    /**
     * The NombreParts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NombreParts;
    /**
     * The ValeurPart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValeurPart;
    /**
     * The ReferenceContrat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceContrat;
    /**
     * The CodeSupportFinancier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CodeSupportFinancier;
    /**
     * Constructor method for Garantie
     * @uses Garantie::setAdresse()
     * @uses Garantie::setEnvironnement()
     * @uses Garantie::setVille()
     * @uses Garantie::setBiens()
     * @uses Garantie::setProprietaires()
     * @uses Garantie::setReferencesCadastrales()
     * @uses Garantie::setCodeAcquisition()
     * @uses Garantie::setEstBienEnAcquisition()
     * @uses Garantie::setCodeTypeGarantie()
     * @uses Garantie::setNombreParts()
     * @uses Garantie::setValeurPart()
     * @uses Garantie::setReferenceContrat()
     * @uses Garantie::setCodeSupportFinancier()
     * @param string $adresse
     * @param string $environnement
     * @param \CfcalSasieSDK\Entity\Ville $ville
     * @param \CfcalSasieSDK\Entity\Biens $biens
     * @param \CfcalSasieSDK\Entity\Proprietaires $proprietaires
     * @param \CfcalSasieSDK\Entity\ReferenceCadastrales $referencesCadastrales
     * @param int $codeAcquisition
     * @param bool $estBienEnAcquisition
     * @param string $codeTypeGarantie
     * @param int $nombreParts
     * @param float $valeurPart
     * @param string $referenceContrat
     * @param int $codeSupportFinancier
     */
    public function __construct($adresse = null, $environnement = null, \CfcalSasieSDK\Entity\Ville $ville = null, \CfcalSasieSDK\Entity\Biens $biens = null, \CfcalSasieSDK\Entity\Proprietaires $proprietaires = null, \CfcalSasieSDK\Entity\ReferenceCadastrales $referencesCadastrales = null, $codeAcquisition = null, $estBienEnAcquisition = null, $codeTypeGarantie = null, $nombreParts = null, $valeurPart = null, $referenceContrat = null, $codeSupportFinancier = null)
    {
        $this
            ->setAdresse($adresse)
            ->setEnvironnement($environnement)
            ->setVille($ville)
            ->setBiens($biens)
            ->setProprietaires($proprietaires)
            ->setReferencesCadastrales($referencesCadastrales)
            ->setCodeAcquisition($codeAcquisition)
            ->setEstBienEnAcquisition($estBienEnAcquisition)
            ->setCodeTypeGarantie($codeTypeGarantie)
            ->setNombreParts($nombreParts)
            ->setValeurPart($valeurPart)
            ->setReferenceContrat($referenceContrat)
            ->setCodeSupportFinancier($codeSupportFinancier);
    }
    /**
     * Get Adresse value
     * @return string|null
     */
    public function getAdresse()
    {
        return $this->Adresse;
    }
    /**
     * Set Adresse value
     * @param string $adresse
     * @return \CfcalSasieSDK\Entity\Garantie
     */
    public function setAdresse($adresse = null)
    {
        // validation for constraint: string
        if (!is_null($adresse) && !is_string($adresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresse, true), gettype($adresse)), __LINE__);
        }
        $this->Adresse = $adresse;
        return $this;
    }
    /**
     * Get Environnement value
     * @return string|null
     */
    public function getEnvironnement()
    {
        return $this->Environnement;
    }
    /**
     * Set Environnement value
     * @uses \CfcalSasieSDK\Enum\Environnement::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\Environnement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $environnement
     * @return \CfcalSasieSDK\Entity\Garantie
     */
    public function setEnvironnement($environnement = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\Environnement::valueIsValid($environnement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\Environnement', is_array($environnement) ? implode(', ', $environnement) : var_export($environnement, true), implode(', ', \CfcalSasieSDK\Enum\Environnement::getValidValues())), __LINE__);
        }
        $this->Environnement = $environnement;
        return $this;
    }
    /**
     * Get Ville value
     * @return \CfcalSasieSDK\Entity\Ville|null
     */
    public function getVille()
    {
        return $this->Ville;
    }
    /**
     * Set Ville value
     * @param \CfcalSasieSDK\Entity\Ville $ville
     * @return \CfcalSasieSDK\Entity\Garantie
     */
    public function setVille(\CfcalSasieSDK\Entity\Ville $ville = null)
    {
        $this->Ville = $ville;
        return $this;
    }
    /**
     * Get Biens value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Biens|null
     */
    public function getBiens()
    {
        return isset($this->Biens) ? $this->Biens : null;
    }
    /**
     * Set Biens value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\Biens $biens
     * @return \CfcalSasieSDK\Entity\Garantie
     */
    public function setBiens(\CfcalSasieSDK\Entity\Biens $biens = null)
    {
        if (is_null($biens) || (is_array($biens) && empty($biens))) {
            unset($this->Biens);
        } else {
            $this->Biens = $biens;
        }
        return $this;
    }
    /**
     * Get Proprietaires value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Proprietaires|null
     */
    public function getProprietaires()
    {
        return isset($this->Proprietaires) ? $this->Proprietaires : null;
    }
    /**
     * Set Proprietaires value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\Proprietaires $proprietaires
     * @return \CfcalSasieSDK\Entity\Garantie
     */
    public function setProprietaires(\CfcalSasieSDK\Entity\Proprietaires $proprietaires = null)
    {
        if (is_null($proprietaires) || (is_array($proprietaires) && empty($proprietaires))) {
            unset($this->Proprietaires);
        } else {
            $this->Proprietaires = $proprietaires;
        }
        return $this;
    }
    /**
     * Get ReferencesCadastrales value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\ReferenceCadastrales|null
     */
    public function getReferencesCadastrales()
    {
        return isset($this->ReferencesCadastrales) ? $this->ReferencesCadastrales : null;
    }
    /**
     * Set ReferencesCadastrales value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\ReferenceCadastrales $referencesCadastrales
     * @return \CfcalSasieSDK\Entity\Garantie
     */
    public function setReferencesCadastrales(\CfcalSasieSDK\Entity\ReferenceCadastrales $referencesCadastrales = null)
    {
        if (is_null($referencesCadastrales) || (is_array($referencesCadastrales) && empty($referencesCadastrales))) {
            unset($this->ReferencesCadastrales);
        } else {
            $this->ReferencesCadastrales = $referencesCadastrales;
        }
        return $this;
    }
    /**
     * Get CodeAcquisition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCodeAcquisition()
    {
        return isset($this->CodeAcquisition) ? $this->CodeAcquisition : null;
    }
    /**
     * Set CodeAcquisition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $codeAcquisition
     * @return \CfcalSasieSDK\Entity\Garantie
     */
    public function setCodeAcquisition($codeAcquisition = null)
    {
        // validation for constraint: int
        if (!is_null($codeAcquisition) && !(is_int($codeAcquisition) || ctype_digit($codeAcquisition))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeAcquisition, true), gettype($codeAcquisition)), __LINE__);
        }
        if (is_null($codeAcquisition) || (is_array($codeAcquisition) && empty($codeAcquisition))) {
            unset($this->CodeAcquisition);
        } else {
            $this->CodeAcquisition = $codeAcquisition;
        }
        return $this;
    }
    /**
     * Get EstBienEnAcquisition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEstBienEnAcquisition()
    {
        return isset($this->EstBienEnAcquisition) ? $this->EstBienEnAcquisition : null;
    }
    /**
     * Set EstBienEnAcquisition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $estBienEnAcquisition
     * @return \CfcalSasieSDK\Entity\Garantie
     */
    public function setEstBienEnAcquisition($estBienEnAcquisition = null)
    {
        // validation for constraint: boolean
        if (!is_null($estBienEnAcquisition) && !is_bool($estBienEnAcquisition)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estBienEnAcquisition, true), gettype($estBienEnAcquisition)), __LINE__);
        }
        if (is_null($estBienEnAcquisition) || (is_array($estBienEnAcquisition) && empty($estBienEnAcquisition))) {
            unset($this->EstBienEnAcquisition);
        } else {
            $this->EstBienEnAcquisition = $estBienEnAcquisition;
        }
        return $this;
    }
    /**
     * Get CodeTypeGarantie value
     * @return string|null
     */
    public function getCodeTypeGarantie()
    {
        return $this->CodeTypeGarantie;
    }
    /**
     * Set CodeTypeGarantie value
     * @uses \CfcalSasieSDK\Enum\TypeGarantie::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeGarantie::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeGarantie
     * @return \CfcalSasieSDK\Entity\Garantie
     */
    public function setCodeTypeGarantie($codeTypeGarantie = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeGarantie::valueIsValid($codeTypeGarantie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeGarantie', is_array($codeTypeGarantie) ? implode(', ', $codeTypeGarantie) : var_export($codeTypeGarantie, true), implode(', ', \CfcalSasieSDK\Enum\TypeGarantie::getValidValues())), __LINE__);
        }
        $this->CodeTypeGarantie = $codeTypeGarantie;
        return $this;
    }
    /**
     * Get NombreParts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNombreParts()
    {
        return isset($this->NombreParts) ? $this->NombreParts : null;
    }
    /**
     * Set NombreParts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nombreParts
     * @return \CfcalSasieSDK\Entity\Garantie
     */
    public function setNombreParts($nombreParts = null)
    {
        // validation for constraint: int
        if (!is_null($nombreParts) && !(is_int($nombreParts) || ctype_digit($nombreParts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nombreParts, true), gettype($nombreParts)), __LINE__);
        }
        if (is_null($nombreParts) || (is_array($nombreParts) && empty($nombreParts))) {
            unset($this->NombreParts);
        } else {
            $this->NombreParts = $nombreParts;
        }
        return $this;
    }
    /**
     * Get ValeurPart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValeurPart()
    {
        return isset($this->ValeurPart) ? $this->ValeurPart : null;
    }
    /**
     * Set ValeurPart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valeurPart
     * @return \CfcalSasieSDK\Entity\Garantie
     */
    public function setValeurPart($valeurPart = null)
    {
        // validation for constraint: float
        if (!is_null($valeurPart) && !(is_float($valeurPart) || is_numeric($valeurPart))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valeurPart, true), gettype($valeurPart)), __LINE__);
        }
        if (is_null($valeurPart) || (is_array($valeurPart) && empty($valeurPart))) {
            unset($this->ValeurPart);
        } else {
            $this->ValeurPart = $valeurPart;
        }
        return $this;
    }
    /**
     * Get ReferenceContrat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceContrat()
    {
        return isset($this->ReferenceContrat) ? $this->ReferenceContrat : null;
    }
    /**
     * Set ReferenceContrat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceContrat
     * @return \CfcalSasieSDK\Entity\Garantie
     */
    public function setReferenceContrat($referenceContrat = null)
    {
        // validation for constraint: string
        if (!is_null($referenceContrat) && !is_string($referenceContrat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceContrat, true), gettype($referenceContrat)), __LINE__);
        }
        if (is_null($referenceContrat) || (is_array($referenceContrat) && empty($referenceContrat))) {
            unset($this->ReferenceContrat);
        } else {
            $this->ReferenceContrat = $referenceContrat;
        }
        return $this;
    }
    /**
     * Get CodeSupportFinancier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCodeSupportFinancier()
    {
        return isset($this->CodeSupportFinancier) ? $this->CodeSupportFinancier : null;
    }
    /**
     * Set CodeSupportFinancier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $codeSupportFinancier
     * @return \CfcalSasieSDK\Entity\Garantie
     */
    public function setCodeSupportFinancier($codeSupportFinancier = null)
    {
        // validation for constraint: int
        if (!is_null($codeSupportFinancier) && !(is_int($codeSupportFinancier) || ctype_digit($codeSupportFinancier))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeSupportFinancier, true), gettype($codeSupportFinancier)), __LINE__);
        }
        if (is_null($codeSupportFinancier) || (is_array($codeSupportFinancier) && empty($codeSupportFinancier))) {
            unset($this->CodeSupportFinancier);
        } else {
            $this->CodeSupportFinancier = $codeSupportFinancier;
        }
        return $this;
    }
}
