<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Financements Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Financements
 * @subpackage Structs
 */
class Financements extends AbstractStructBase
{
    /**
     * The Financement
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Financement[]
     */
    public $Financement;
    /**
     * Constructor method for Financements
     * @uses Financements::setFinancement()
     * @param \CfcalSasieSDK\Entity\Financement[] $financement
     */
    public function __construct(array $financement = array())
    {
        $this
            ->setFinancement($financement);
    }
    /**
     * Get Financement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Financement[]|null
     */
    public function getFinancement()
    {
        return isset($this->Financement) ? $this->Financement : null;
    }
    /**
     * This method is responsible for validating the values passed to the setFinancement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFinancement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFinancementForArrayConstraintsFromSetFinancement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $financementsFinancementItem) {
            // validation for constraint: itemType
            if (!$financementsFinancementItem instanceof \CfcalSasieSDK\Entity\Financement) {
                $invalidValues[] = is_object($financementsFinancementItem) ? get_class($financementsFinancementItem) : sprintf('%s(%s)', gettype($financementsFinancementItem), var_export($financementsFinancementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Financement property can only contain items of type \CfcalSasieSDK\Entity\Financement, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Financement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Financement[] $financement
     * @return \CfcalSasieSDK\Entity\Financements
     */
    public function setFinancement(array $financement = array())
    {
        // validation for constraint: array
        if ('' !== ($financementArrayErrorMessage = self::validateFinancementForArrayConstraintsFromSetFinancement($financement))) {
            throw new \InvalidArgumentException($financementArrayErrorMessage, __LINE__);
        }
        if (is_null($financement) || (is_array($financement) && empty($financement))) {
            unset($this->Financement);
        } else {
            $this->Financement = $financement;
        }
        return $this;
    }
    /**
     * Add item to Financement value
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Financement $item
     * @return \CfcalSasieSDK\Entity\Financements
     */
    public function addToFinancement(\CfcalSasieSDK\Entity\Financement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CfcalSasieSDK\Entity\Financement) {
            throw new \InvalidArgumentException(sprintf('The Financement property can only contain items of type \CfcalSasieSDK\Entity\Financement, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Financement[] = $item;
        return $this;
    }
}
