<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Financement Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Financement
 * @subpackage Structs
 */
class Financement extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The CodeTypeFinancement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $CodeTypeFinancement;
    /**
     * The Montant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Montant;
    /**
     * The Duree
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Duree;
    /**
     * The Echeance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Echeance;
    /**
     * The Periodicite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Periodicite;
    /**
     * Constructor method for Financement
     * @uses Financement::setCodeTypeFinancement()
     * @uses Financement::setMontant()
     * @uses Financement::setDuree()
     * @uses Financement::setEcheance()
     * @uses Financement::setPeriodicite()
     * @param int $codeTypeFinancement
     * @param float $montant
     * @param int $duree
     * @param float $echeance
     * @param string $periodicite
     */
    public function __construct($codeTypeFinancement = null, $montant = null, $duree = null, $echeance = null, $periodicite = null)
    {
        $this
            ->setCodeTypeFinancement($codeTypeFinancement)
            ->setMontant($montant)
            ->setDuree($duree)
            ->setEcheance($echeance)
            ->setPeriodicite($periodicite);
    }
    /**
     * Get CodeTypeFinancement value
     * @return int|null
     */
    public function getCodeTypeFinancement()
    {
        return $this->CodeTypeFinancement;
    }
    /**
     * Set CodeTypeFinancement value
     * @param int $codeTypeFinancement
     * @return \CfcalSasieSDK\Entity\Financement
     */
    public function setCodeTypeFinancement($codeTypeFinancement = null)
    {
        // validation for constraint: int
        if (!is_null($codeTypeFinancement) && !(is_int($codeTypeFinancement) || ctype_digit($codeTypeFinancement))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeTypeFinancement, true), gettype($codeTypeFinancement)), __LINE__);
        }
        $this->CodeTypeFinancement = $codeTypeFinancement;
        return $this;
    }
    /**
     * Get Montant value
     * @return float|null
     */
    public function getMontant()
    {
        return $this->Montant;
    }
    /**
     * Set Montant value
     * @param float $montant
     * @return \CfcalSasieSDK\Entity\Financement
     */
    public function setMontant($montant = null)
    {
        // validation for constraint: float
        if (!is_null($montant) && !(is_float($montant) || is_numeric($montant))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montant, true), gettype($montant)), __LINE__);
        }
        $this->Montant = $montant;
        return $this;
    }
    /**
     * Get Duree value
     * @return int|null
     */
    public function getDuree()
    {
        return $this->Duree;
    }
    /**
     * Set Duree value
     * @param int $duree
     * @return \CfcalSasieSDK\Entity\Financement
     */
    public function setDuree($duree = null)
    {
        // validation for constraint: int
        if (!is_null($duree) && !(is_int($duree) || ctype_digit($duree))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duree, true), gettype($duree)), __LINE__);
        }
        $this->Duree = $duree;
        return $this;
    }
    /**
     * Get Echeance value
     * @return float|null
     */
    public function getEcheance()
    {
        return $this->Echeance;
    }
    /**
     * Set Echeance value
     * @param float $echeance
     * @return \CfcalSasieSDK\Entity\Financement
     */
    public function setEcheance($echeance = null)
    {
        // validation for constraint: float
        if (!is_null($echeance) && !(is_float($echeance) || is_numeric($echeance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($echeance, true), gettype($echeance)), __LINE__);
        }
        $this->Echeance = $echeance;
        return $this;
    }
    /**
     * Get Periodicite value
     * @return string|null
     */
    public function getPeriodicite()
    {
        return $this->Periodicite;
    }
    /**
     * Set Periodicite value
     * @uses \CfcalSasieSDK\Enum\Periodicite::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\Periodicite::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $periodicite
     * @return \CfcalSasieSDK\Entity\Financement
     */
    public function setPeriodicite($periodicite = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\Periodicite::valueIsValid($periodicite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\Periodicite', is_array($periodicite) ? implode(', ', $periodicite) : var_export($periodicite, true), implode(', ', \CfcalSasieSDK\Enum\Periodicite::getValidValues())), __LINE__);
        }
        $this->Periodicite = $periodicite;
        return $this;
    }
}
