<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstimationRecenteBien Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EstimationRecenteBien
 * @subpackage Structs
 */
class EstimationRecenteBien extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The DateEstimation
     * @var string
     */
    public $DateEstimation;
    /**
     * The Valeur
     * @var float
     */
    public $Valeur;
    /**
     * The TypeEstimation
     * @var string
     */
    public $TypeEstimation;
    /**
     * The NomEstimateur
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomEstimateur;
    /**
     * The CodeTypeValeurDeReference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypeValeurDeReference;
    /**
     * Constructor method for EstimationRecenteBien
     * @uses EstimationRecenteBien::setDateEstimation()
     * @uses EstimationRecenteBien::setValeur()
     * @uses EstimationRecenteBien::setTypeEstimation()
     * @uses EstimationRecenteBien::setNomEstimateur()
     * @uses EstimationRecenteBien::setCodeTypeValeurDeReference()
     * @param string $dateEstimation
     * @param float $valeur
     * @param string $typeEstimation
     * @param string $nomEstimateur
     * @param string $codeTypeValeurDeReference
     */
    public function __construct($dateEstimation = null, $valeur = null, $typeEstimation = null, $nomEstimateur = null, $codeTypeValeurDeReference = null)
    {
        $this
            ->setDateEstimation($dateEstimation)
            ->setValeur($valeur)
            ->setTypeEstimation($typeEstimation)
            ->setNomEstimateur($nomEstimateur)
            ->setCodeTypeValeurDeReference($codeTypeValeurDeReference);
    }
    /**
     * Get DateEstimation value
     * @return string|null
     */
    public function getDateEstimation()
    {
        return $this->DateEstimation;
    }
    /**
     * Set DateEstimation value
     * @param string $dateEstimation
     * @return \CfcalSasieSDK\Entity\EstimationRecenteBien
     */
    public function setDateEstimation($dateEstimation = null)
    {
        // validation for constraint: string
        if (!is_null($dateEstimation) && !is_string($dateEstimation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEstimation, true), gettype($dateEstimation)), __LINE__);
        }
        $this->DateEstimation = $dateEstimation;
        return $this;
    }
    /**
     * Get Valeur value
     * @return float|null
     */
    public function getValeur()
    {
        return $this->Valeur;
    }
    /**
     * Set Valeur value
     * @param float $valeur
     * @return \CfcalSasieSDK\Entity\EstimationRecenteBien
     */
    public function setValeur($valeur = null)
    {
        // validation for constraint: float
        if (!is_null($valeur) && !(is_float($valeur) || is_numeric($valeur))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valeur, true), gettype($valeur)), __LINE__);
        }
        $this->Valeur = $valeur;
        return $this;
    }
    /**
     * Get TypeEstimation value
     * @return string|null
     */
    public function getTypeEstimation()
    {
        return $this->TypeEstimation;
    }
    /**
     * Set TypeEstimation value
     * @uses \CfcalSasieSDK\Enum\TypeEstimationRecente::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeEstimationRecente::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeEstimation
     * @return \CfcalSasieSDK\Entity\EstimationRecenteBien
     */
    public function setTypeEstimation($typeEstimation = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeEstimationRecente::valueIsValid($typeEstimation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeEstimationRecente', is_array($typeEstimation) ? implode(', ', $typeEstimation) : var_export($typeEstimation, true), implode(', ', \CfcalSasieSDK\Enum\TypeEstimationRecente::getValidValues())), __LINE__);
        }
        $this->TypeEstimation = $typeEstimation;
        return $this;
    }
    /**
     * Get NomEstimateur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomEstimateur()
    {
        return isset($this->NomEstimateur) ? $this->NomEstimateur : null;
    }
    /**
     * Set NomEstimateur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomEstimateur
     * @return \CfcalSasieSDK\Entity\EstimationRecenteBien
     */
    public function setNomEstimateur($nomEstimateur = null)
    {
        // validation for constraint: string
        if (!is_null($nomEstimateur) && !is_string($nomEstimateur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomEstimateur, true), gettype($nomEstimateur)), __LINE__);
        }
        if (is_null($nomEstimateur) || (is_array($nomEstimateur) && empty($nomEstimateur))) {
            unset($this->NomEstimateur);
        } else {
            $this->NomEstimateur = $nomEstimateur;
        }
        return $this;
    }
    /**
     * Get CodeTypeValeurDeReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeValeurDeReference()
    {
        return isset($this->CodeTypeValeurDeReference) ? $this->CodeTypeValeurDeReference : null;
    }
    /**
     * Set CodeTypeValeurDeReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\ValeurDeReference::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\ValeurDeReference::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeValeurDeReference
     * @return \CfcalSasieSDK\Entity\EstimationRecenteBien
     */
    public function setCodeTypeValeurDeReference($codeTypeValeurDeReference = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\ValeurDeReference::valueIsValid($codeTypeValeurDeReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\ValeurDeReference', is_array($codeTypeValeurDeReference) ? implode(', ', $codeTypeValeurDeReference) : var_export($codeTypeValeurDeReference, true), implode(', ', \CfcalSasieSDK\Enum\ValeurDeReference::getValidValues())), __LINE__);
        }
        if (is_null($codeTypeValeurDeReference) || (is_array($codeTypeValeurDeReference) && empty($codeTypeValeurDeReference))) {
            unset($this->CodeTypeValeurDeReference);
        } else {
            $this->CodeTypeValeurDeReference = $codeTypeValeurDeReference;
        }
        return $this;
    }
}
