<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Emprunts Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Emprunts
 * @subpackage Structs
 */
class Emprunts extends AbstractStructBase
{
    /**
     * The Emprunt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Emprunt[]
     */
    public $Emprunt;
    /**
     * Constructor method for Emprunts
     * @uses Emprunts::setEmprunt()
     * @param \CfcalSasieSDK\Entity\Emprunt[] $emprunt
     */
    public function __construct(array $emprunt = array())
    {
        $this
            ->setEmprunt($emprunt);
    }
    /**
     * Get Emprunt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Emprunt[]|null
     */
    public function getEmprunt()
    {
        return isset($this->Emprunt) ? $this->Emprunt : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEmprunt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmprunt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmpruntForArrayConstraintsFromSetEmprunt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $empruntsEmpruntItem) {
            // validation for constraint: itemType
            if (!$empruntsEmpruntItem instanceof \CfcalSasieSDK\Entity\Emprunt) {
                $invalidValues[] = is_object($empruntsEmpruntItem) ? get_class($empruntsEmpruntItem) : sprintf('%s(%s)', gettype($empruntsEmpruntItem), var_export($empruntsEmpruntItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Emprunt property can only contain items of type \CfcalSasieSDK\Entity\Emprunt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Emprunt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Emprunt[] $emprunt
     * @return \CfcalSasieSDK\Entity\Emprunts
     */
    public function setEmprunt(array $emprunt = array())
    {
        // validation for constraint: array
        if ('' !== ($empruntArrayErrorMessage = self::validateEmpruntForArrayConstraintsFromSetEmprunt($emprunt))) {
            throw new \InvalidArgumentException($empruntArrayErrorMessage, __LINE__);
        }
        if (is_null($emprunt) || (is_array($emprunt) && empty($emprunt))) {
            unset($this->Emprunt);
        } else {
            $this->Emprunt = $emprunt;
        }
        return $this;
    }
    /**
     * Add item to Emprunt value
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Emprunt $item
     * @return \CfcalSasieSDK\Entity\Emprunts
     */
    public function addToEmprunt(\CfcalSasieSDK\Entity\Emprunt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CfcalSasieSDK\Entity\Emprunt) {
            throw new \InvalidArgumentException(sprintf('The Emprunt property can only contain items of type \CfcalSasieSDK\Entity\Emprunt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Emprunt[] = $item;
        return $this;
    }
}
