<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Emprunteur Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Emprunteur
 * @subpackage Structs
 */
class Emprunteur extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The IdentifiantIntervenant
     * @var int
     */
    public $IdentifiantIntervenant;
    /**
     * The Nom
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Nom;
    /**
     * The NomJeuneFille
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomJeuneFille;
    /**
     * The Prenom
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Prenom;
    /**
     * The DateNaissance
     * @var string
     */
    public $DateNaissance;
    /**
     * The Adresse
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Adresse;
    /**
     * The Civilite
     * @var string
     */
    public $Civilite;
    /**
     * The RegimeMatrimonial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegimeMatrimonial;
    /**
     * The SituationFamiliale
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SituationFamiliale;
    /**
     * The Habitat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Habitat;
    /**
     * The CapaciteJuridique
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CapaciteJuridique;
    /**
     * The Ville
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Ville
     */
    public $Ville;
    /**
     * The VilleNaissance
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Ville
     */
    public $VilleNaissance;
    /**
     * The SituationProfessionnelle
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $SituationProfessionnelle;
    /**
     * The Contacts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Contacts
     */
    public $Contacts;
    /**
     * The PersonnesACharges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\PersonneACharges
     */
    public $PersonnesACharges;
    /**
     * The Emplois
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Emplois
     */
    public $Emplois;
    /**
     * The Revenus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Revenus
     */
    public $Revenus;
    /**
     * The Charges
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Charges
     */
    public $Charges;
    /**
     * The Entreprise
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Societe
     */
    public $Entreprise;
    /**
     * The Taille
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Taille;
    /**
     * The Poids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Poids;
    /**
     * The EstPersonnePolitiquementExposee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EstPersonnePolitiquementExposee;
    /**
     * The AbsenceImpotsSurLeRevenu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AbsenceImpotsSurLeRevenu;
    /**
     * The EstSansAssurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EstSansAssurance;
    /**
     * The Assurance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Assurance
     */
    public $Assurance;
    /**
     * The NumeroDeRegistreNational
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroDeRegistreNational;
    /**
     * The NumeroDeCarteIdentite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroDeCarteIdentite;
    /**
     * The CodeCultureLangue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeCultureLangue;
    /**
     * The CodePaysDeResidenceFiscale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodePaysDeResidenceFiscale;
    /**
     * The CodeTypeNationalite
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeTypeNationalite;
    /**
     * The PossedeRejetBancaireRecent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PossedeRejetBancaireRecent;
    /**
     * The EstRessortissantUE
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EstRessortissantUE;
    /**
     * Constructor method for Emprunteur
     * @uses Emprunteur::setIdentifiantIntervenant()
     * @uses Emprunteur::setNom()
     * @uses Emprunteur::setNomJeuneFille()
     * @uses Emprunteur::setPrenom()
     * @uses Emprunteur::setDateNaissance()
     * @uses Emprunteur::setAdresse()
     * @uses Emprunteur::setCivilite()
     * @uses Emprunteur::setRegimeMatrimonial()
     * @uses Emprunteur::setSituationFamiliale()
     * @uses Emprunteur::setHabitat()
     * @uses Emprunteur::setCapaciteJuridique()
     * @uses Emprunteur::setVille()
     * @uses Emprunteur::setVilleNaissance()
     * @uses Emprunteur::setSituationProfessionnelle()
     * @uses Emprunteur::setContacts()
     * @uses Emprunteur::setPersonnesACharges()
     * @uses Emprunteur::setEmplois()
     * @uses Emprunteur::setRevenus()
     * @uses Emprunteur::setCharges()
     * @uses Emprunteur::setEntreprise()
     * @uses Emprunteur::setTaille()
     * @uses Emprunteur::setPoids()
     * @uses Emprunteur::setEstPersonnePolitiquementExposee()
     * @uses Emprunteur::setAbsenceImpotsSurLeRevenu()
     * @uses Emprunteur::setEstSansAssurance()
     * @uses Emprunteur::setAssurance()
     * @uses Emprunteur::setNumeroDeRegistreNational()
     * @uses Emprunteur::setNumeroDeCarteIdentite()
     * @uses Emprunteur::setCodeCultureLangue()
     * @uses Emprunteur::setCodePaysDeResidenceFiscale()
     * @uses Emprunteur::setCodeTypeNationalite()
     * @uses Emprunteur::setPossedeRejetBancaireRecent()
     * @uses Emprunteur::setEstRessortissantUE()
     * @param int $identifiantIntervenant
     * @param string $nom
     * @param string $nomJeuneFille
     * @param string $prenom
     * @param string $dateNaissance
     * @param string $adresse
     * @param string $civilite
     * @param string $regimeMatrimonial
     * @param string $situationFamiliale
     * @param string $habitat
     * @param string $capaciteJuridique
     * @param \CfcalSasieSDK\Entity\Ville $ville
     * @param \CfcalSasieSDK\Entity\Ville $villeNaissance
     * @param string $situationProfessionnelle
     * @param \CfcalSasieSDK\Entity\Contacts $contacts
     * @param \CfcalSasieSDK\Entity\PersonneACharges $personnesACharges
     * @param \CfcalSasieSDK\Entity\Emplois $emplois
     * @param \CfcalSasieSDK\Entity\Revenus $revenus
     * @param \CfcalSasieSDK\Entity\Charges $charges
     * @param \CfcalSasieSDK\Entity\Societe $entreprise
     * @param string $taille
     * @param int $poids
     * @param bool $estPersonnePolitiquementExposee
     * @param bool $absenceImpotsSurLeRevenu
     * @param bool $estSansAssurance
     * @param \CfcalSasieSDK\Entity\Assurance $assurance
     * @param string $numeroDeRegistreNational
     * @param string $numeroDeCarteIdentite
     * @param string $codeCultureLangue
     * @param string $codePaysDeResidenceFiscale
     * @param string $codeTypeNationalite
     * @param bool $possedeRejetBancaireRecent
     * @param bool $estRessortissantUE
     */
    public function __construct($identifiantIntervenant = null, $nom = null, $nomJeuneFille = null, $prenom = null, $dateNaissance = null, $adresse = null, $civilite = null, $regimeMatrimonial = null, $situationFamiliale = null, $habitat = null, $capaciteJuridique = null, \CfcalSasieSDK\Entity\Ville $ville = null, \CfcalSasieSDK\Entity\Ville $villeNaissance = null, $situationProfessionnelle = null, \CfcalSasieSDK\Entity\Contacts $contacts = null, \CfcalSasieSDK\Entity\PersonneACharges $personnesACharges = null, \CfcalSasieSDK\Entity\Emplois $emplois = null, \CfcalSasieSDK\Entity\Revenus $revenus = null, \CfcalSasieSDK\Entity\Charges $charges = null, \CfcalSasieSDK\Entity\Societe $entreprise = null, $taille = null, $poids = null, $estPersonnePolitiquementExposee = null, $absenceImpotsSurLeRevenu = null, $estSansAssurance = null, \CfcalSasieSDK\Entity\Assurance $assurance = null, $numeroDeRegistreNational = null, $numeroDeCarteIdentite = null, $codeCultureLangue = null, $codePaysDeResidenceFiscale = null, $codeTypeNationalite = null, $possedeRejetBancaireRecent = null, $estRessortissantUE = null)
    {
        $this
            ->setIdentifiantIntervenant($identifiantIntervenant)
            ->setNom($nom)
            ->setNomJeuneFille($nomJeuneFille)
            ->setPrenom($prenom)
            ->setDateNaissance($dateNaissance)
            ->setAdresse($adresse)
            ->setCivilite($civilite)
            ->setRegimeMatrimonial($regimeMatrimonial)
            ->setSituationFamiliale($situationFamiliale)
            ->setHabitat($habitat)
            ->setCapaciteJuridique($capaciteJuridique)
            ->setVille($ville)
            ->setVilleNaissance($villeNaissance)
            ->setSituationProfessionnelle($situationProfessionnelle)
            ->setContacts($contacts)
            ->setPersonnesACharges($personnesACharges)
            ->setEmplois($emplois)
            ->setRevenus($revenus)
            ->setCharges($charges)
            ->setEntreprise($entreprise)
            ->setTaille($taille)
            ->setPoids($poids)
            ->setEstPersonnePolitiquementExposee($estPersonnePolitiquementExposee)
            ->setAbsenceImpotsSurLeRevenu($absenceImpotsSurLeRevenu)
            ->setEstSansAssurance($estSansAssurance)
            ->setAssurance($assurance)
            ->setNumeroDeRegistreNational($numeroDeRegistreNational)
            ->setNumeroDeCarteIdentite($numeroDeCarteIdentite)
            ->setCodeCultureLangue($codeCultureLangue)
            ->setCodePaysDeResidenceFiscale($codePaysDeResidenceFiscale)
            ->setCodeTypeNationalite($codeTypeNationalite)
            ->setPossedeRejetBancaireRecent($possedeRejetBancaireRecent)
            ->setEstRessortissantUE($estRessortissantUE);
    }
    /**
     * Get IdentifiantIntervenant value
     * @return int|null
     */
    public function getIdentifiantIntervenant()
    {
        return $this->IdentifiantIntervenant;
    }
    /**
     * Set IdentifiantIntervenant value
     * @param int $identifiantIntervenant
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setIdentifiantIntervenant($identifiantIntervenant = null)
    {
        // validation for constraint: int
        if (!is_null($identifiantIntervenant) && !(is_int($identifiantIntervenant) || ctype_digit($identifiantIntervenant))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($identifiantIntervenant, true), gettype($identifiantIntervenant)), __LINE__);
        }
        $this->IdentifiantIntervenant = $identifiantIntervenant;
        return $this;
    }
    /**
     * Get Nom value
     * @return string|null
     */
    public function getNom()
    {
        return $this->Nom;
    }
    /**
     * Set Nom value
     * @param string $nom
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setNom($nom = null)
    {
        // validation for constraint: string
        if (!is_null($nom) && !is_string($nom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom, true), gettype($nom)), __LINE__);
        }
        $this->Nom = $nom;
        return $this;
    }
    /**
     * Get NomJeuneFille value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomJeuneFille()
    {
        return isset($this->NomJeuneFille) ? $this->NomJeuneFille : null;
    }
    /**
     * Set NomJeuneFille value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomJeuneFille
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setNomJeuneFille($nomJeuneFille = null)
    {
        // validation for constraint: string
        if (!is_null($nomJeuneFille) && !is_string($nomJeuneFille)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomJeuneFille, true), gettype($nomJeuneFille)), __LINE__);
        }
        if (is_null($nomJeuneFille) || (is_array($nomJeuneFille) && empty($nomJeuneFille))) {
            unset($this->NomJeuneFille);
        } else {
            $this->NomJeuneFille = $nomJeuneFille;
        }
        return $this;
    }
    /**
     * Get Prenom value
     * @return string|null
     */
    public function getPrenom()
    {
        return $this->Prenom;
    }
    /**
     * Set Prenom value
     * @param string $prenom
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setPrenom($prenom = null)
    {
        // validation for constraint: string
        if (!is_null($prenom) && !is_string($prenom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prenom, true), gettype($prenom)), __LINE__);
        }
        $this->Prenom = $prenom;
        return $this;
    }
    /**
     * Get DateNaissance value
     * @return string|null
     */
    public function getDateNaissance()
    {
        return $this->DateNaissance;
    }
    /**
     * Set DateNaissance value
     * @param string $dateNaissance
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setDateNaissance($dateNaissance = null)
    {
        // validation for constraint: string
        if (!is_null($dateNaissance) && !is_string($dateNaissance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateNaissance, true), gettype($dateNaissance)), __LINE__);
        }
        $this->DateNaissance = $dateNaissance;
        return $this;
    }
    /**
     * Get Adresse value
     * @return string|null
     */
    public function getAdresse()
    {
        return $this->Adresse;
    }
    /**
     * Set Adresse value
     * @param string $adresse
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setAdresse($adresse = null)
    {
        // validation for constraint: string
        if (!is_null($adresse) && !is_string($adresse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresse, true), gettype($adresse)), __LINE__);
        }
        $this->Adresse = $adresse;
        return $this;
    }
    /**
     * Get Civilite value
     * @return string|null
     */
    public function getCivilite()
    {
        return $this->Civilite;
    }
    /**
     * Set Civilite value
     * @uses \CfcalSasieSDK\Enum\Civilite::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\Civilite::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $civilite
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setCivilite($civilite = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\Civilite::valueIsValid($civilite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\Civilite', is_array($civilite) ? implode(', ', $civilite) : var_export($civilite, true), implode(', ', \CfcalSasieSDK\Enum\Civilite::getValidValues())), __LINE__);
        }
        $this->Civilite = $civilite;
        return $this;
    }
    /**
     * Get RegimeMatrimonial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegimeMatrimonial()
    {
        return isset($this->RegimeMatrimonial) ? $this->RegimeMatrimonial : null;
    }
    /**
     * Set RegimeMatrimonial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\RegimeMatrimonial::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\RegimeMatrimonial::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $regimeMatrimonial
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setRegimeMatrimonial($regimeMatrimonial = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\RegimeMatrimonial::valueIsValid($regimeMatrimonial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\RegimeMatrimonial', is_array($regimeMatrimonial) ? implode(', ', $regimeMatrimonial) : var_export($regimeMatrimonial, true), implode(', ', \CfcalSasieSDK\Enum\RegimeMatrimonial::getValidValues())), __LINE__);
        }
        if (is_null($regimeMatrimonial) || (is_array($regimeMatrimonial) && empty($regimeMatrimonial))) {
            unset($this->RegimeMatrimonial);
        } else {
            $this->RegimeMatrimonial = $regimeMatrimonial;
        }
        return $this;
    }
    /**
     * Get SituationFamiliale value
     * @return string|null
     */
    public function getSituationFamiliale()
    {
        return $this->SituationFamiliale;
    }
    /**
     * Set SituationFamiliale value
     * @uses \CfcalSasieSDK\Enum\SituationFamiliale::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\SituationFamiliale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $situationFamiliale
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setSituationFamiliale($situationFamiliale = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\SituationFamiliale::valueIsValid($situationFamiliale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\SituationFamiliale', is_array($situationFamiliale) ? implode(', ', $situationFamiliale) : var_export($situationFamiliale, true), implode(', ', \CfcalSasieSDK\Enum\SituationFamiliale::getValidValues())), __LINE__);
        }
        $this->SituationFamiliale = $situationFamiliale;
        return $this;
    }
    /**
     * Get Habitat value
     * @return string|null
     */
    public function getHabitat()
    {
        return $this->Habitat;
    }
    /**
     * Set Habitat value
     * @uses \CfcalSasieSDK\Enum\TypeHabitat::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeHabitat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $habitat
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setHabitat($habitat = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeHabitat::valueIsValid($habitat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeHabitat', is_array($habitat) ? implode(', ', $habitat) : var_export($habitat, true), implode(', ', \CfcalSasieSDK\Enum\TypeHabitat::getValidValues())), __LINE__);
        }
        $this->Habitat = $habitat;
        return $this;
    }
    /**
     * Get CapaciteJuridique value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCapaciteJuridique()
    {
        return isset($this->CapaciteJuridique) ? $this->CapaciteJuridique : null;
    }
    /**
     * Set CapaciteJuridique value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\CapaciteJuridique::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\CapaciteJuridique::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $capaciteJuridique
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setCapaciteJuridique($capaciteJuridique = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\CapaciteJuridique::valueIsValid($capaciteJuridique)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\CapaciteJuridique', is_array($capaciteJuridique) ? implode(', ', $capaciteJuridique) : var_export($capaciteJuridique, true), implode(', ', \CfcalSasieSDK\Enum\CapaciteJuridique::getValidValues())), __LINE__);
        }
        if (is_null($capaciteJuridique) || (is_array($capaciteJuridique) && empty($capaciteJuridique))) {
            unset($this->CapaciteJuridique);
        } else {
            $this->CapaciteJuridique = $capaciteJuridique;
        }
        return $this;
    }
    /**
     * Get Ville value
     * @return \CfcalSasieSDK\Entity\Ville|null
     */
    public function getVille()
    {
        return $this->Ville;
    }
    /**
     * Set Ville value
     * @param \CfcalSasieSDK\Entity\Ville $ville
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setVille(\CfcalSasieSDK\Entity\Ville $ville = null)
    {
        $this->Ville = $ville;
        return $this;
    }
    /**
     * Get VilleNaissance value
     * @return \CfcalSasieSDK\Entity\Ville|null
     */
    public function getVilleNaissance()
    {
        return $this->VilleNaissance;
    }
    /**
     * Set VilleNaissance value
     * @param \CfcalSasieSDK\Entity\Ville $villeNaissance
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setVilleNaissance(\CfcalSasieSDK\Entity\Ville $villeNaissance = null)
    {
        $this->VilleNaissance = $villeNaissance;
        return $this;
    }
    /**
     * Get SituationProfessionnelle value
     * @return string|null
     */
    public function getSituationProfessionnelle()
    {
        return $this->SituationProfessionnelle;
    }
    /**
     * Set SituationProfessionnelle value
     * @uses \CfcalSasieSDK\Enum\SituationProfessionnelle::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\SituationProfessionnelle::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $situationProfessionnelle
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setSituationProfessionnelle($situationProfessionnelle = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\SituationProfessionnelle::valueIsValid($situationProfessionnelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\SituationProfessionnelle', is_array($situationProfessionnelle) ? implode(', ', $situationProfessionnelle) : var_export($situationProfessionnelle, true), implode(', ', \CfcalSasieSDK\Enum\SituationProfessionnelle::getValidValues())), __LINE__);
        }
        $this->SituationProfessionnelle = $situationProfessionnelle;
        return $this;
    }
    /**
     * Get Contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Contacts|null
     */
    public function getContacts()
    {
        return isset($this->Contacts) ? $this->Contacts : null;
    }
    /**
     * Set Contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\Contacts $contacts
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setContacts(\CfcalSasieSDK\Entity\Contacts $contacts = null)
    {
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->Contacts);
        } else {
            $this->Contacts = $contacts;
        }
        return $this;
    }
    /**
     * Get PersonnesACharges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\PersonneACharges|null
     */
    public function getPersonnesACharges()
    {
        return isset($this->PersonnesACharges) ? $this->PersonnesACharges : null;
    }
    /**
     * Set PersonnesACharges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\PersonneACharges $personnesACharges
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setPersonnesACharges(\CfcalSasieSDK\Entity\PersonneACharges $personnesACharges = null)
    {
        if (is_null($personnesACharges) || (is_array($personnesACharges) && empty($personnesACharges))) {
            unset($this->PersonnesACharges);
        } else {
            $this->PersonnesACharges = $personnesACharges;
        }
        return $this;
    }
    /**
     * Get Emplois value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Emplois|null
     */
    public function getEmplois()
    {
        return isset($this->Emplois) ? $this->Emplois : null;
    }
    /**
     * Set Emplois value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\Emplois $emplois
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setEmplois(\CfcalSasieSDK\Entity\Emplois $emplois = null)
    {
        if (is_null($emplois) || (is_array($emplois) && empty($emplois))) {
            unset($this->Emplois);
        } else {
            $this->Emplois = $emplois;
        }
        return $this;
    }
    /**
     * Get Revenus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Revenus|null
     */
    public function getRevenus()
    {
        return isset($this->Revenus) ? $this->Revenus : null;
    }
    /**
     * Set Revenus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\Revenus $revenus
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setRevenus(\CfcalSasieSDK\Entity\Revenus $revenus = null)
    {
        if (is_null($revenus) || (is_array($revenus) && empty($revenus))) {
            unset($this->Revenus);
        } else {
            $this->Revenus = $revenus;
        }
        return $this;
    }
    /**
     * Get Charges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Charges|null
     */
    public function getCharges()
    {
        return isset($this->Charges) ? $this->Charges : null;
    }
    /**
     * Set Charges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\Charges $charges
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setCharges(\CfcalSasieSDK\Entity\Charges $charges = null)
    {
        if (is_null($charges) || (is_array($charges) && empty($charges))) {
            unset($this->Charges);
        } else {
            $this->Charges = $charges;
        }
        return $this;
    }
    /**
     * Get Entreprise value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Societe|null
     */
    public function getEntreprise()
    {
        return isset($this->Entreprise) ? $this->Entreprise : null;
    }
    /**
     * Set Entreprise value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\Societe $entreprise
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setEntreprise(\CfcalSasieSDK\Entity\Societe $entreprise = null)
    {
        if (is_null($entreprise) || (is_array($entreprise) && empty($entreprise))) {
            unset($this->Entreprise);
        } else {
            $this->Entreprise = $entreprise;
        }
        return $this;
    }
    /**
     * Get Taille value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaille()
    {
        return isset($this->Taille) ? $this->Taille : null;
    }
    /**
     * Set Taille value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taille
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setTaille($taille = null)
    {
        // validation for constraint: string
        if (!is_null($taille) && !is_string($taille)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taille, true), gettype($taille)), __LINE__);
        }
        if (is_null($taille) || (is_array($taille) && empty($taille))) {
            unset($this->Taille);
        } else {
            $this->Taille = $taille;
        }
        return $this;
    }
    /**
     * Get Poids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPoids()
    {
        return isset($this->Poids) ? $this->Poids : null;
    }
    /**
     * Set Poids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $poids
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setPoids($poids = null)
    {
        // validation for constraint: int
        if (!is_null($poids) && !(is_int($poids) || ctype_digit($poids))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($poids, true), gettype($poids)), __LINE__);
        }
        if (is_null($poids) || (is_array($poids) && empty($poids))) {
            unset($this->Poids);
        } else {
            $this->Poids = $poids;
        }
        return $this;
    }
    /**
     * Get EstPersonnePolitiquementExposee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEstPersonnePolitiquementExposee()
    {
        return isset($this->EstPersonnePolitiquementExposee) ? $this->EstPersonnePolitiquementExposee : null;
    }
    /**
     * Set EstPersonnePolitiquementExposee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $estPersonnePolitiquementExposee
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setEstPersonnePolitiquementExposee($estPersonnePolitiquementExposee = null)
    {
        // validation for constraint: boolean
        if (!is_null($estPersonnePolitiquementExposee) && !is_bool($estPersonnePolitiquementExposee)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estPersonnePolitiquementExposee, true), gettype($estPersonnePolitiquementExposee)), __LINE__);
        }
        if (is_null($estPersonnePolitiquementExposee) || (is_array($estPersonnePolitiquementExposee) && empty($estPersonnePolitiquementExposee))) {
            unset($this->EstPersonnePolitiquementExposee);
        } else {
            $this->EstPersonnePolitiquementExposee = $estPersonnePolitiquementExposee;
        }
        return $this;
    }
    /**
     * Get AbsenceImpotsSurLeRevenu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAbsenceImpotsSurLeRevenu()
    {
        return isset($this->AbsenceImpotsSurLeRevenu) ? $this->AbsenceImpotsSurLeRevenu : null;
    }
    /**
     * Set AbsenceImpotsSurLeRevenu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $absenceImpotsSurLeRevenu
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setAbsenceImpotsSurLeRevenu($absenceImpotsSurLeRevenu = null)
    {
        // validation for constraint: boolean
        if (!is_null($absenceImpotsSurLeRevenu) && !is_bool($absenceImpotsSurLeRevenu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($absenceImpotsSurLeRevenu, true), gettype($absenceImpotsSurLeRevenu)), __LINE__);
        }
        if (is_null($absenceImpotsSurLeRevenu) || (is_array($absenceImpotsSurLeRevenu) && empty($absenceImpotsSurLeRevenu))) {
            unset($this->AbsenceImpotsSurLeRevenu);
        } else {
            $this->AbsenceImpotsSurLeRevenu = $absenceImpotsSurLeRevenu;
        }
        return $this;
    }
    /**
     * Get EstSansAssurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEstSansAssurance()
    {
        return isset($this->EstSansAssurance) ? $this->EstSansAssurance : null;
    }
    /**
     * Set EstSansAssurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $estSansAssurance
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setEstSansAssurance($estSansAssurance = null)
    {
        // validation for constraint: boolean
        if (!is_null($estSansAssurance) && !is_bool($estSansAssurance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estSansAssurance, true), gettype($estSansAssurance)), __LINE__);
        }
        if (is_null($estSansAssurance) || (is_array($estSansAssurance) && empty($estSansAssurance))) {
            unset($this->EstSansAssurance);
        } else {
            $this->EstSansAssurance = $estSansAssurance;
        }
        return $this;
    }
    /**
     * Get Assurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Assurance|null
     */
    public function getAssurance()
    {
        return isset($this->Assurance) ? $this->Assurance : null;
    }
    /**
     * Set Assurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\Assurance $assurance
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setAssurance(\CfcalSasieSDK\Entity\Assurance $assurance = null)
    {
        if (is_null($assurance) || (is_array($assurance) && empty($assurance))) {
            unset($this->Assurance);
        } else {
            $this->Assurance = $assurance;
        }
        return $this;
    }
    /**
     * Get NumeroDeRegistreNational value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroDeRegistreNational()
    {
        return isset($this->NumeroDeRegistreNational) ? $this->NumeroDeRegistreNational : null;
    }
    /**
     * Set NumeroDeRegistreNational value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroDeRegistreNational
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setNumeroDeRegistreNational($numeroDeRegistreNational = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDeRegistreNational) && !is_string($numeroDeRegistreNational)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDeRegistreNational, true), gettype($numeroDeRegistreNational)), __LINE__);
        }
        if (is_null($numeroDeRegistreNational) || (is_array($numeroDeRegistreNational) && empty($numeroDeRegistreNational))) {
            unset($this->NumeroDeRegistreNational);
        } else {
            $this->NumeroDeRegistreNational = $numeroDeRegistreNational;
        }
        return $this;
    }
    /**
     * Get NumeroDeCarteIdentite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroDeCarteIdentite()
    {
        return isset($this->NumeroDeCarteIdentite) ? $this->NumeroDeCarteIdentite : null;
    }
    /**
     * Set NumeroDeCarteIdentite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroDeCarteIdentite
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setNumeroDeCarteIdentite($numeroDeCarteIdentite = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDeCarteIdentite) && !is_string($numeroDeCarteIdentite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDeCarteIdentite, true), gettype($numeroDeCarteIdentite)), __LINE__);
        }
        if (is_null($numeroDeCarteIdentite) || (is_array($numeroDeCarteIdentite) && empty($numeroDeCarteIdentite))) {
            unset($this->NumeroDeCarteIdentite);
        } else {
            $this->NumeroDeCarteIdentite = $numeroDeCarteIdentite;
        }
        return $this;
    }
    /**
     * Get CodeCultureLangue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeCultureLangue()
    {
        return isset($this->CodeCultureLangue) ? $this->CodeCultureLangue : null;
    }
    /**
     * Set CodeCultureLangue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypeCodeCultureLangueBelgique::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeCodeCultureLangueBelgique::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeCultureLangue
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setCodeCultureLangue($codeCultureLangue = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeCodeCultureLangueBelgique::valueIsValid($codeCultureLangue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeCodeCultureLangueBelgique', is_array($codeCultureLangue) ? implode(', ', $codeCultureLangue) : var_export($codeCultureLangue, true), implode(', ', \CfcalSasieSDK\Enum\TypeCodeCultureLangueBelgique::getValidValues())), __LINE__);
        }
        if (is_null($codeCultureLangue) || (is_array($codeCultureLangue) && empty($codeCultureLangue))) {
            unset($this->CodeCultureLangue);
        } else {
            $this->CodeCultureLangue = $codeCultureLangue;
        }
        return $this;
    }
    /**
     * Get CodePaysDeResidenceFiscale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodePaysDeResidenceFiscale()
    {
        return isset($this->CodePaysDeResidenceFiscale) ? $this->CodePaysDeResidenceFiscale : null;
    }
    /**
     * Set CodePaysDeResidenceFiscale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codePaysDeResidenceFiscale
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setCodePaysDeResidenceFiscale($codePaysDeResidenceFiscale = null)
    {
        // validation for constraint: string
        if (!is_null($codePaysDeResidenceFiscale) && !is_string($codePaysDeResidenceFiscale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codePaysDeResidenceFiscale, true), gettype($codePaysDeResidenceFiscale)), __LINE__);
        }
        if (is_null($codePaysDeResidenceFiscale) || (is_array($codePaysDeResidenceFiscale) && empty($codePaysDeResidenceFiscale))) {
            unset($this->CodePaysDeResidenceFiscale);
        } else {
            $this->CodePaysDeResidenceFiscale = $codePaysDeResidenceFiscale;
        }
        return $this;
    }
    /**
     * Get CodeTypeNationalite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeTypeNationalite()
    {
        return isset($this->CodeTypeNationalite) ? $this->CodeTypeNationalite : null;
    }
    /**
     * Set CodeTypeNationalite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\Nationalite::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\Nationalite::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $codeTypeNationalite
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setCodeTypeNationalite($codeTypeNationalite = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\Nationalite::valueIsValid($codeTypeNationalite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\Nationalite', is_array($codeTypeNationalite) ? implode(', ', $codeTypeNationalite) : var_export($codeTypeNationalite, true), implode(', ', \CfcalSasieSDK\Enum\Nationalite::getValidValues())), __LINE__);
        }
        if (is_null($codeTypeNationalite) || (is_array($codeTypeNationalite) && empty($codeTypeNationalite))) {
            unset($this->CodeTypeNationalite);
        } else {
            $this->CodeTypeNationalite = $codeTypeNationalite;
        }
        return $this;
    }
    /**
     * Get PossedeRejetBancaireRecent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPossedeRejetBancaireRecent()
    {
        return isset($this->PossedeRejetBancaireRecent) ? $this->PossedeRejetBancaireRecent : null;
    }
    /**
     * Set PossedeRejetBancaireRecent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $possedeRejetBancaireRecent
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setPossedeRejetBancaireRecent($possedeRejetBancaireRecent = null)
    {
        // validation for constraint: boolean
        if (!is_null($possedeRejetBancaireRecent) && !is_bool($possedeRejetBancaireRecent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($possedeRejetBancaireRecent, true), gettype($possedeRejetBancaireRecent)), __LINE__);
        }
        if (is_null($possedeRejetBancaireRecent) || (is_array($possedeRejetBancaireRecent) && empty($possedeRejetBancaireRecent))) {
            unset($this->PossedeRejetBancaireRecent);
        } else {
            $this->PossedeRejetBancaireRecent = $possedeRejetBancaireRecent;
        }
        return $this;
    }
    /**
     * Get EstRessortissantUE value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEstRessortissantUE()
    {
        return isset($this->EstRessortissantUE) ? $this->EstRessortissantUE : null;
    }
    /**
     * Set EstRessortissantUE value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $estRessortissantUE
     * @return \CfcalSasieSDK\Entity\Emprunteur
     */
    public function setEstRessortissantUE($estRessortissantUE = null)
    {
        // validation for constraint: boolean
        if (!is_null($estRessortissantUE) && !is_bool($estRessortissantUE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estRessortissantUE, true), gettype($estRessortissantUE)), __LINE__);
        }
        if (is_null($estRessortissantUE) || (is_array($estRessortissantUE) && empty($estRessortissantUE))) {
            unset($this->EstRessortissantUE);
        } else {
            $this->EstRessortissantUE = $estRessortissantUE;
        }
        return $this;
    }
}
