<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Emprunt Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Emprunt
 * @subpackage Structs
 */
class Emprunt extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The Organisme
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Organisme;
    /**
     * The DateOctroi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOctroi;
    /**
     * The MontantRestant
     * @var float
     */
    public $MontantRestant;
    /**
     * The Echeance
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var float
     */
    public $Echeance;
    /**
     * The Periodicite
     * @var string
     */
    public $Periodicite;
    /**
     * The Nature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Nature;
    /**
     * The Taux
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Taux;
    /**
     * The MontantIRA
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MontantIRA;
    /**
     * The DelaiPreavisRA
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DelaiPreavisRA;
    /**
     * The EstInscriptionHypothecaire
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EstInscriptionHypothecaire;
    /**
     * The EstInscriptionJudiciaire
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EstInscriptionJudiciaire;
    /**
     * The EstRegroupementDeCredit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EstRegroupementDeCredit;
    /**
     * The EtatRachatEmprunt
     * @var string
     */
    public $EtatRachatEmprunt;
    /**
     * The NumeroContrat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroContrat;
    /**
     * The ObjetPret
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ObjetPret;
    /**
     * The DateDernierReleve
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateDernierReleve;
    /**
     * The Duree
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Duree;
    /**
     * The MontantInitial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $MontantInitial;
    /**
     * The CodeOrganismePreteurFiabilise
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CodeOrganismePreteurFiabilise;
    /**
     * The CodeOrganismePreteurFiabiliseCoordonnee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CodeOrganismePreteurFiabiliseCoordonnee;
    /**
     * The Adresse1OrganismePreteur
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Adresse1OrganismePreteur;
    /**
     * The Adresse2OrganismePreteur
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Adresse2OrganismePreteur;
    /**
     * The VilleOrganismePreteur
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Ville
     */
    public $VilleOrganismePreteur;
    /**
     * The EstDeductibleFiscalement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EstDeductibleFiscalement;
    /**
     * The TypeSousNatureEngagement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TypeSousNatureEngagement;
    /**
     * Constructor method for Emprunt
     * @uses Emprunt::setOrganisme()
     * @uses Emprunt::setDateOctroi()
     * @uses Emprunt::setMontantRestant()
     * @uses Emprunt::setEcheance()
     * @uses Emprunt::setPeriodicite()
     * @uses Emprunt::setNature()
     * @uses Emprunt::setTaux()
     * @uses Emprunt::setMontantIRA()
     * @uses Emprunt::setDelaiPreavisRA()
     * @uses Emprunt::setEstInscriptionHypothecaire()
     * @uses Emprunt::setEstInscriptionJudiciaire()
     * @uses Emprunt::setEstRegroupementDeCredit()
     * @uses Emprunt::setEtatRachatEmprunt()
     * @uses Emprunt::setNumeroContrat()
     * @uses Emprunt::setObjetPret()
     * @uses Emprunt::setDateDernierReleve()
     * @uses Emprunt::setDuree()
     * @uses Emprunt::setMontantInitial()
     * @uses Emprunt::setCodeOrganismePreteurFiabilise()
     * @uses Emprunt::setCodeOrganismePreteurFiabiliseCoordonnee()
     * @uses Emprunt::setAdresse1OrganismePreteur()
     * @uses Emprunt::setAdresse2OrganismePreteur()
     * @uses Emprunt::setVilleOrganismePreteur()
     * @uses Emprunt::setEstDeductibleFiscalement()
     * @uses Emprunt::setTypeSousNatureEngagement()
     * @param string $organisme
     * @param string $dateOctroi
     * @param float $montantRestant
     * @param float $echeance
     * @param string $periodicite
     * @param string $nature
     * @param float $taux
     * @param float $montantIRA
     * @param int $delaiPreavisRA
     * @param bool $estInscriptionHypothecaire
     * @param bool $estInscriptionJudiciaire
     * @param bool $estRegroupementDeCredit
     * @param string $etatRachatEmprunt
     * @param string $numeroContrat
     * @param string $objetPret
     * @param string $dateDernierReleve
     * @param int $duree
     * @param float $montantInitial
     * @param int $codeOrganismePreteurFiabilise
     * @param int $codeOrganismePreteurFiabiliseCoordonnee
     * @param string $adresse1OrganismePreteur
     * @param string $adresse2OrganismePreteur
     * @param \CfcalSasieSDK\Entity\Ville $villeOrganismePreteur
     * @param bool $estDeductibleFiscalement
     * @param string $typeSousNatureEngagement
     */
    public function __construct($organisme = null, $dateOctroi = null, $montantRestant = null, $echeance = null, $periodicite = null, $nature = null, $taux = null, $montantIRA = null, $delaiPreavisRA = null, $estInscriptionHypothecaire = null, $estInscriptionJudiciaire = null, $estRegroupementDeCredit = null, $etatRachatEmprunt = null, $numeroContrat = null, $objetPret = null, $dateDernierReleve = null, $duree = null, $montantInitial = null, $codeOrganismePreteurFiabilise = null, $codeOrganismePreteurFiabiliseCoordonnee = null, $adresse1OrganismePreteur = null, $adresse2OrganismePreteur = null, \CfcalSasieSDK\Entity\Ville $villeOrganismePreteur = null, $estDeductibleFiscalement = null, $typeSousNatureEngagement = null)
    {
        $this
            ->setOrganisme($organisme)
            ->setDateOctroi($dateOctroi)
            ->setMontantRestant($montantRestant)
            ->setEcheance($echeance)
            ->setPeriodicite($periodicite)
            ->setNature($nature)
            ->setTaux($taux)
            ->setMontantIRA($montantIRA)
            ->setDelaiPreavisRA($delaiPreavisRA)
            ->setEstInscriptionHypothecaire($estInscriptionHypothecaire)
            ->setEstInscriptionJudiciaire($estInscriptionJudiciaire)
            ->setEstRegroupementDeCredit($estRegroupementDeCredit)
            ->setEtatRachatEmprunt($etatRachatEmprunt)
            ->setNumeroContrat($numeroContrat)
            ->setObjetPret($objetPret)
            ->setDateDernierReleve($dateDernierReleve)
            ->setDuree($duree)
            ->setMontantInitial($montantInitial)
            ->setCodeOrganismePreteurFiabilise($codeOrganismePreteurFiabilise)
            ->setCodeOrganismePreteurFiabiliseCoordonnee($codeOrganismePreteurFiabiliseCoordonnee)
            ->setAdresse1OrganismePreteur($adresse1OrganismePreteur)
            ->setAdresse2OrganismePreteur($adresse2OrganismePreteur)
            ->setVilleOrganismePreteur($villeOrganismePreteur)
            ->setEstDeductibleFiscalement($estDeductibleFiscalement)
            ->setTypeSousNatureEngagement($typeSousNatureEngagement);
    }
    /**
     * Get Organisme value
     * @return string|null
     */
    public function getOrganisme()
    {
        return $this->Organisme;
    }
    /**
     * Set Organisme value
     * @param string $organisme
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setOrganisme($organisme = null)
    {
        // validation for constraint: string
        if (!is_null($organisme) && !is_string($organisme)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organisme, true), gettype($organisme)), __LINE__);
        }
        $this->Organisme = $organisme;
        return $this;
    }
    /**
     * Get DateOctroi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOctroi()
    {
        return isset($this->DateOctroi) ? $this->DateOctroi : null;
    }
    /**
     * Set DateOctroi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOctroi
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setDateOctroi($dateOctroi = null)
    {
        // validation for constraint: string
        if (!is_null($dateOctroi) && !is_string($dateOctroi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOctroi, true), gettype($dateOctroi)), __LINE__);
        }
        if (is_null($dateOctroi) || (is_array($dateOctroi) && empty($dateOctroi))) {
            unset($this->DateOctroi);
        } else {
            $this->DateOctroi = $dateOctroi;
        }
        return $this;
    }
    /**
     * Get MontantRestant value
     * @return float|null
     */
    public function getMontantRestant()
    {
        return $this->MontantRestant;
    }
    /**
     * Set MontantRestant value
     * @param float $montantRestant
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setMontantRestant($montantRestant = null)
    {
        // validation for constraint: float
        if (!is_null($montantRestant) && !(is_float($montantRestant) || is_numeric($montantRestant))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montantRestant, true), gettype($montantRestant)), __LINE__);
        }
        $this->MontantRestant = $montantRestant;
        return $this;
    }
    /**
     * Get Echeance value
     * @return float|null
     */
    public function getEcheance()
    {
        return $this->Echeance;
    }
    /**
     * Set Echeance value
     * @param float $echeance
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setEcheance($echeance = null)
    {
        // validation for constraint: float
        if (!is_null($echeance) && !(is_float($echeance) || is_numeric($echeance))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($echeance, true), gettype($echeance)), __LINE__);
        }
        $this->Echeance = $echeance;
        return $this;
    }
    /**
     * Get Periodicite value
     * @return string|null
     */
    public function getPeriodicite()
    {
        return $this->Periodicite;
    }
    /**
     * Set Periodicite value
     * @uses \CfcalSasieSDK\Enum\Periodicite::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\Periodicite::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $periodicite
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setPeriodicite($periodicite = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\Periodicite::valueIsValid($periodicite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\Periodicite', is_array($periodicite) ? implode(', ', $periodicite) : var_export($periodicite, true), implode(', ', \CfcalSasieSDK\Enum\Periodicite::getValidValues())), __LINE__);
        }
        $this->Periodicite = $periodicite;
        return $this;
    }
    /**
     * Get Nature value
     * @return string|null
     */
    public function getNature()
    {
        return $this->Nature;
    }
    /**
     * Set Nature value
     * @uses \CfcalSasieSDK\Enum\NatureEngagement::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\NatureEngagement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nature
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setNature($nature = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\NatureEngagement::valueIsValid($nature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\NatureEngagement', is_array($nature) ? implode(', ', $nature) : var_export($nature, true), implode(', ', \CfcalSasieSDK\Enum\NatureEngagement::getValidValues())), __LINE__);
        }
        $this->Nature = $nature;
        return $this;
    }
    /**
     * Get Taux value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaux()
    {
        return isset($this->Taux) ? $this->Taux : null;
    }
    /**
     * Set Taux value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taux
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setTaux($taux = null)
    {
        // validation for constraint: float
        if (!is_null($taux) && !(is_float($taux) || is_numeric($taux))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taux, true), gettype($taux)), __LINE__);
        }
        if (is_null($taux) || (is_array($taux) && empty($taux))) {
            unset($this->Taux);
        } else {
            $this->Taux = $taux;
        }
        return $this;
    }
    /**
     * Get MontantIRA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMontantIRA()
    {
        return isset($this->MontantIRA) ? $this->MontantIRA : null;
    }
    /**
     * Set MontantIRA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $montantIRA
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setMontantIRA($montantIRA = null)
    {
        // validation for constraint: float
        if (!is_null($montantIRA) && !(is_float($montantIRA) || is_numeric($montantIRA))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montantIRA, true), gettype($montantIRA)), __LINE__);
        }
        if (is_null($montantIRA) || (is_array($montantIRA) && empty($montantIRA))) {
            unset($this->MontantIRA);
        } else {
            $this->MontantIRA = $montantIRA;
        }
        return $this;
    }
    /**
     * Get DelaiPreavisRA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDelaiPreavisRA()
    {
        return isset($this->DelaiPreavisRA) ? $this->DelaiPreavisRA : null;
    }
    /**
     * Set DelaiPreavisRA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $delaiPreavisRA
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setDelaiPreavisRA($delaiPreavisRA = null)
    {
        // validation for constraint: int
        if (!is_null($delaiPreavisRA) && !(is_int($delaiPreavisRA) || ctype_digit($delaiPreavisRA))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($delaiPreavisRA, true), gettype($delaiPreavisRA)), __LINE__);
        }
        if (is_null($delaiPreavisRA) || (is_array($delaiPreavisRA) && empty($delaiPreavisRA))) {
            unset($this->DelaiPreavisRA);
        } else {
            $this->DelaiPreavisRA = $delaiPreavisRA;
        }
        return $this;
    }
    /**
     * Get EstInscriptionHypothecaire value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEstInscriptionHypothecaire()
    {
        return isset($this->EstInscriptionHypothecaire) ? $this->EstInscriptionHypothecaire : null;
    }
    /**
     * Set EstInscriptionHypothecaire value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $estInscriptionHypothecaire
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setEstInscriptionHypothecaire($estInscriptionHypothecaire = null)
    {
        // validation for constraint: boolean
        if (!is_null($estInscriptionHypothecaire) && !is_bool($estInscriptionHypothecaire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estInscriptionHypothecaire, true), gettype($estInscriptionHypothecaire)), __LINE__);
        }
        if (is_null($estInscriptionHypothecaire) || (is_array($estInscriptionHypothecaire) && empty($estInscriptionHypothecaire))) {
            unset($this->EstInscriptionHypothecaire);
        } else {
            $this->EstInscriptionHypothecaire = $estInscriptionHypothecaire;
        }
        return $this;
    }
    /**
     * Get EstInscriptionJudiciaire value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEstInscriptionJudiciaire()
    {
        return isset($this->EstInscriptionJudiciaire) ? $this->EstInscriptionJudiciaire : null;
    }
    /**
     * Set EstInscriptionJudiciaire value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $estInscriptionJudiciaire
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setEstInscriptionJudiciaire($estInscriptionJudiciaire = null)
    {
        // validation for constraint: boolean
        if (!is_null($estInscriptionJudiciaire) && !is_bool($estInscriptionJudiciaire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estInscriptionJudiciaire, true), gettype($estInscriptionJudiciaire)), __LINE__);
        }
        if (is_null($estInscriptionJudiciaire) || (is_array($estInscriptionJudiciaire) && empty($estInscriptionJudiciaire))) {
            unset($this->EstInscriptionJudiciaire);
        } else {
            $this->EstInscriptionJudiciaire = $estInscriptionJudiciaire;
        }
        return $this;
    }
    /**
     * Get EstRegroupementDeCredit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEstRegroupementDeCredit()
    {
        return isset($this->EstRegroupementDeCredit) ? $this->EstRegroupementDeCredit : null;
    }
    /**
     * Set EstRegroupementDeCredit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $estRegroupementDeCredit
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setEstRegroupementDeCredit($estRegroupementDeCredit = null)
    {
        // validation for constraint: boolean
        if (!is_null($estRegroupementDeCredit) && !is_bool($estRegroupementDeCredit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estRegroupementDeCredit, true), gettype($estRegroupementDeCredit)), __LINE__);
        }
        if (is_null($estRegroupementDeCredit) || (is_array($estRegroupementDeCredit) && empty($estRegroupementDeCredit))) {
            unset($this->EstRegroupementDeCredit);
        } else {
            $this->EstRegroupementDeCredit = $estRegroupementDeCredit;
        }
        return $this;
    }
    /**
     * Get EtatRachatEmprunt value
     * @return string|null
     */
    public function getEtatRachatEmprunt()
    {
        return $this->EtatRachatEmprunt;
    }
    /**
     * Set EtatRachatEmprunt value
     * @uses \CfcalSasieSDK\Enum\EtatRachat::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\EtatRachat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $etatRachatEmprunt
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setEtatRachatEmprunt($etatRachatEmprunt = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\EtatRachat::valueIsValid($etatRachatEmprunt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\EtatRachat', is_array($etatRachatEmprunt) ? implode(', ', $etatRachatEmprunt) : var_export($etatRachatEmprunt, true), implode(', ', \CfcalSasieSDK\Enum\EtatRachat::getValidValues())), __LINE__);
        }
        $this->EtatRachatEmprunt = $etatRachatEmprunt;
        return $this;
    }
    /**
     * Get NumeroContrat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroContrat()
    {
        return isset($this->NumeroContrat) ? $this->NumeroContrat : null;
    }
    /**
     * Set NumeroContrat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroContrat
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setNumeroContrat($numeroContrat = null)
    {
        // validation for constraint: string
        if (!is_null($numeroContrat) && !is_string($numeroContrat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroContrat, true), gettype($numeroContrat)), __LINE__);
        }
        if (is_null($numeroContrat) || (is_array($numeroContrat) && empty($numeroContrat))) {
            unset($this->NumeroContrat);
        } else {
            $this->NumeroContrat = $numeroContrat;
        }
        return $this;
    }
    /**
     * Get ObjetPret value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjetPret()
    {
        return isset($this->ObjetPret) ? $this->ObjetPret : null;
    }
    /**
     * Set ObjetPret value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objetPret
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setObjetPret($objetPret = null)
    {
        // validation for constraint: string
        if (!is_null($objetPret) && !is_string($objetPret)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($objetPret, true), gettype($objetPret)), __LINE__);
        }
        if (is_null($objetPret) || (is_array($objetPret) && empty($objetPret))) {
            unset($this->ObjetPret);
        } else {
            $this->ObjetPret = $objetPret;
        }
        return $this;
    }
    /**
     * Get DateDernierReleve value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateDernierReleve()
    {
        return isset($this->DateDernierReleve) ? $this->DateDernierReleve : null;
    }
    /**
     * Set DateDernierReleve value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateDernierReleve
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setDateDernierReleve($dateDernierReleve = null)
    {
        // validation for constraint: string
        if (!is_null($dateDernierReleve) && !is_string($dateDernierReleve)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateDernierReleve, true), gettype($dateDernierReleve)), __LINE__);
        }
        if (is_null($dateDernierReleve) || (is_array($dateDernierReleve) && empty($dateDernierReleve))) {
            unset($this->DateDernierReleve);
        } else {
            $this->DateDernierReleve = $dateDernierReleve;
        }
        return $this;
    }
    /**
     * Get Duree value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDuree()
    {
        return isset($this->Duree) ? $this->Duree : null;
    }
    /**
     * Set Duree value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $duree
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setDuree($duree = null)
    {
        // validation for constraint: int
        if (!is_null($duree) && !(is_int($duree) || ctype_digit($duree))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($duree, true), gettype($duree)), __LINE__);
        }
        if (is_null($duree) || (is_array($duree) && empty($duree))) {
            unset($this->Duree);
        } else {
            $this->Duree = $duree;
        }
        return $this;
    }
    /**
     * Get MontantInitial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMontantInitial()
    {
        return isset($this->MontantInitial) ? $this->MontantInitial : null;
    }
    /**
     * Set MontantInitial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $montantInitial
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setMontantInitial($montantInitial = null)
    {
        // validation for constraint: float
        if (!is_null($montantInitial) && !(is_float($montantInitial) || is_numeric($montantInitial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montantInitial, true), gettype($montantInitial)), __LINE__);
        }
        if (is_null($montantInitial) || (is_array($montantInitial) && empty($montantInitial))) {
            unset($this->MontantInitial);
        } else {
            $this->MontantInitial = $montantInitial;
        }
        return $this;
    }
    /**
     * Get CodeOrganismePreteurFiabilise value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCodeOrganismePreteurFiabilise()
    {
        return isset($this->CodeOrganismePreteurFiabilise) ? $this->CodeOrganismePreteurFiabilise : null;
    }
    /**
     * Set CodeOrganismePreteurFiabilise value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $codeOrganismePreteurFiabilise
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setCodeOrganismePreteurFiabilise($codeOrganismePreteurFiabilise = null)
    {
        // validation for constraint: int
        if (!is_null($codeOrganismePreteurFiabilise) && !(is_int($codeOrganismePreteurFiabilise) || ctype_digit($codeOrganismePreteurFiabilise))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeOrganismePreteurFiabilise, true), gettype($codeOrganismePreteurFiabilise)), __LINE__);
        }
        if (is_null($codeOrganismePreteurFiabilise) || (is_array($codeOrganismePreteurFiabilise) && empty($codeOrganismePreteurFiabilise))) {
            unset($this->CodeOrganismePreteurFiabilise);
        } else {
            $this->CodeOrganismePreteurFiabilise = $codeOrganismePreteurFiabilise;
        }
        return $this;
    }
    /**
     * Get CodeOrganismePreteurFiabiliseCoordonnee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCodeOrganismePreteurFiabiliseCoordonnee()
    {
        return isset($this->CodeOrganismePreteurFiabiliseCoordonnee) ? $this->CodeOrganismePreteurFiabiliseCoordonnee : null;
    }
    /**
     * Set CodeOrganismePreteurFiabiliseCoordonnee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $codeOrganismePreteurFiabiliseCoordonnee
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setCodeOrganismePreteurFiabiliseCoordonnee($codeOrganismePreteurFiabiliseCoordonnee = null)
    {
        // validation for constraint: int
        if (!is_null($codeOrganismePreteurFiabiliseCoordonnee) && !(is_int($codeOrganismePreteurFiabiliseCoordonnee) || ctype_digit($codeOrganismePreteurFiabiliseCoordonnee))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codeOrganismePreteurFiabiliseCoordonnee, true), gettype($codeOrganismePreteurFiabiliseCoordonnee)), __LINE__);
        }
        if (is_null($codeOrganismePreteurFiabiliseCoordonnee) || (is_array($codeOrganismePreteurFiabiliseCoordonnee) && empty($codeOrganismePreteurFiabiliseCoordonnee))) {
            unset($this->CodeOrganismePreteurFiabiliseCoordonnee);
        } else {
            $this->CodeOrganismePreteurFiabiliseCoordonnee = $codeOrganismePreteurFiabiliseCoordonnee;
        }
        return $this;
    }
    /**
     * Get Adresse1OrganismePreteur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdresse1OrganismePreteur()
    {
        return isset($this->Adresse1OrganismePreteur) ? $this->Adresse1OrganismePreteur : null;
    }
    /**
     * Set Adresse1OrganismePreteur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adresse1OrganismePreteur
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setAdresse1OrganismePreteur($adresse1OrganismePreteur = null)
    {
        // validation for constraint: string
        if (!is_null($adresse1OrganismePreteur) && !is_string($adresse1OrganismePreteur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresse1OrganismePreteur, true), gettype($adresse1OrganismePreteur)), __LINE__);
        }
        if (is_null($adresse1OrganismePreteur) || (is_array($adresse1OrganismePreteur) && empty($adresse1OrganismePreteur))) {
            unset($this->Adresse1OrganismePreteur);
        } else {
            $this->Adresse1OrganismePreteur = $adresse1OrganismePreteur;
        }
        return $this;
    }
    /**
     * Get Adresse2OrganismePreteur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdresse2OrganismePreteur()
    {
        return isset($this->Adresse2OrganismePreteur) ? $this->Adresse2OrganismePreteur : null;
    }
    /**
     * Set Adresse2OrganismePreteur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adresse2OrganismePreteur
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setAdresse2OrganismePreteur($adresse2OrganismePreteur = null)
    {
        // validation for constraint: string
        if (!is_null($adresse2OrganismePreteur) && !is_string($adresse2OrganismePreteur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresse2OrganismePreteur, true), gettype($adresse2OrganismePreteur)), __LINE__);
        }
        if (is_null($adresse2OrganismePreteur) || (is_array($adresse2OrganismePreteur) && empty($adresse2OrganismePreteur))) {
            unset($this->Adresse2OrganismePreteur);
        } else {
            $this->Adresse2OrganismePreteur = $adresse2OrganismePreteur;
        }
        return $this;
    }
    /**
     * Get VilleOrganismePreteur value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Ville|null
     */
    public function getVilleOrganismePreteur()
    {
        return isset($this->VilleOrganismePreteur) ? $this->VilleOrganismePreteur : null;
    }
    /**
     * Set VilleOrganismePreteur value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\Ville $villeOrganismePreteur
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setVilleOrganismePreteur(\CfcalSasieSDK\Entity\Ville $villeOrganismePreteur = null)
    {
        if (is_null($villeOrganismePreteur) || (is_array($villeOrganismePreteur) && empty($villeOrganismePreteur))) {
            unset($this->VilleOrganismePreteur);
        } else {
            $this->VilleOrganismePreteur = $villeOrganismePreteur;
        }
        return $this;
    }
    /**
     * Get EstDeductibleFiscalement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEstDeductibleFiscalement()
    {
        return isset($this->EstDeductibleFiscalement) ? $this->EstDeductibleFiscalement : null;
    }
    /**
     * Set EstDeductibleFiscalement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $estDeductibleFiscalement
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setEstDeductibleFiscalement($estDeductibleFiscalement = null)
    {
        // validation for constraint: boolean
        if (!is_null($estDeductibleFiscalement) && !is_bool($estDeductibleFiscalement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estDeductibleFiscalement, true), gettype($estDeductibleFiscalement)), __LINE__);
        }
        if (is_null($estDeductibleFiscalement) || (is_array($estDeductibleFiscalement) && empty($estDeductibleFiscalement))) {
            unset($this->EstDeductibleFiscalement);
        } else {
            $this->EstDeductibleFiscalement = $estDeductibleFiscalement;
        }
        return $this;
    }
    /**
     * Get TypeSousNatureEngagement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTypeSousNatureEngagement()
    {
        return isset($this->TypeSousNatureEngagement) ? $this->TypeSousNatureEngagement : null;
    }
    /**
     * Set TypeSousNatureEngagement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypeSousNatureEngagement::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeSousNatureEngagement::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeSousNatureEngagement
     * @return \CfcalSasieSDK\Entity\Emprunt
     */
    public function setTypeSousNatureEngagement($typeSousNatureEngagement = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeSousNatureEngagement::valueIsValid($typeSousNatureEngagement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeSousNatureEngagement', is_array($typeSousNatureEngagement) ? implode(', ', $typeSousNatureEngagement) : var_export($typeSousNatureEngagement, true), implode(', ', \CfcalSasieSDK\Enum\TypeSousNatureEngagement::getValidValues())), __LINE__);
        }
        if (is_null($typeSousNatureEngagement) || (is_array($typeSousNatureEngagement) && empty($typeSousNatureEngagement))) {
            unset($this->TypeSousNatureEngagement);
        } else {
            $this->TypeSousNatureEngagement = $typeSousNatureEngagement;
        }
        return $this;
    }
}
