<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Emploi Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Emploi
 * @subpackage Structs
 */
class Emploi extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The Employeur
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Societe
     */
    public $Employeur;
    /**
     * The TypeContrat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $TypeContrat;
    /**
     * The Profession
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Profession;
    /**
     * The DateEntree
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $DateEntree;
    /**
     * The DateFin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateFin;
    /**
     * Constructor method for Emploi
     * @uses Emploi::setEmployeur()
     * @uses Emploi::setTypeContrat()
     * @uses Emploi::setProfession()
     * @uses Emploi::setDateEntree()
     * @uses Emploi::setDateFin()
     * @param \CfcalSasieSDK\Entity\Societe $employeur
     * @param string $typeContrat
     * @param string $profession
     * @param string $dateEntree
     * @param string $dateFin
     */
    public function __construct(\CfcalSasieSDK\Entity\Societe $employeur = null, $typeContrat = null, $profession = null, $dateEntree = null, $dateFin = null)
    {
        $this
            ->setEmployeur($employeur)
            ->setTypeContrat($typeContrat)
            ->setProfession($profession)
            ->setDateEntree($dateEntree)
            ->setDateFin($dateFin);
    }
    /**
     * Get Employeur value
     * @return \CfcalSasieSDK\Entity\Societe|null
     */
    public function getEmployeur()
    {
        return $this->Employeur;
    }
    /**
     * Set Employeur value
     * @param \CfcalSasieSDK\Entity\Societe $employeur
     * @return \CfcalSasieSDK\Entity\Emploi
     */
    public function setEmployeur(\CfcalSasieSDK\Entity\Societe $employeur = null)
    {
        $this->Employeur = $employeur;
        return $this;
    }
    /**
     * Get TypeContrat value
     * @return string|null
     */
    public function getTypeContrat()
    {
        return $this->TypeContrat;
    }
    /**
     * Set TypeContrat value
     * @uses \CfcalSasieSDK\Enum\Contrat::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\Contrat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $typeContrat
     * @return \CfcalSasieSDK\Entity\Emploi
     */
    public function setTypeContrat($typeContrat = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\Contrat::valueIsValid($typeContrat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\Contrat', is_array($typeContrat) ? implode(', ', $typeContrat) : var_export($typeContrat, true), implode(', ', \CfcalSasieSDK\Enum\Contrat::getValidValues())), __LINE__);
        }
        $this->TypeContrat = $typeContrat;
        return $this;
    }
    /**
     * Get Profession value
     * @return string|null
     */
    public function getProfession()
    {
        return $this->Profession;
    }
    /**
     * Set Profession value
     * @param string $profession
     * @return \CfcalSasieSDK\Entity\Emploi
     */
    public function setProfession($profession = null)
    {
        // validation for constraint: string
        if (!is_null($profession) && !is_string($profession)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profession, true), gettype($profession)), __LINE__);
        }
        $this->Profession = $profession;
        return $this;
    }
    /**
     * Get DateEntree value
     * @return string|null
     */
    public function getDateEntree()
    {
        return $this->DateEntree;
    }
    /**
     * Set DateEntree value
     * @param string $dateEntree
     * @return \CfcalSasieSDK\Entity\Emploi
     */
    public function setDateEntree($dateEntree = null)
    {
        // validation for constraint: string
        if (!is_null($dateEntree) && !is_string($dateEntree)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateEntree, true), gettype($dateEntree)), __LINE__);
        }
        $this->DateEntree = $dateEntree;
        return $this;
    }
    /**
     * Get DateFin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateFin()
    {
        return isset($this->DateFin) ? $this->DateFin : null;
    }
    /**
     * Set DateFin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateFin
     * @return \CfcalSasieSDK\Entity\Emploi
     */
    public function setDateFin($dateFin = null)
    {
        // validation for constraint: string
        if (!is_null($dateFin) && !is_string($dateFin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateFin, true), gettype($dateFin)), __LINE__);
        }
        if (is_null($dateFin) || (is_array($dateFin) && empty($dateFin))) {
            unset($this->DateFin);
        } else {
            $this->DateFin = $dateFin;
        }
        return $this;
    }
}
