<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentInformations Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DocumentInformations
 * @subpackage Structs
 */
class DocumentInformations extends AbstractStructBase
{
    /**
     * The DocumentInformation
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\DocumentInformation[]
     */
    public $DocumentInformation;
    /**
     * Constructor method for DocumentInformations
     * @uses DocumentInformations::setDocumentInformation()
     * @param \CfcalSasieSDK\Entity\DocumentInformation[] $documentInformation
     */
    public function __construct(array $documentInformation = array())
    {
        $this
            ->setDocumentInformation($documentInformation);
    }
    /**
     * Get DocumentInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\DocumentInformation[]|null
     */
    public function getDocumentInformation()
    {
        return isset($this->DocumentInformation) ? $this->DocumentInformation : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDocumentInformation method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDocumentInformation method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDocumentInformationForArrayConstraintsFromSetDocumentInformation(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentInformationsDocumentInformationItem) {
            // validation for constraint: itemType
            if (!$documentInformationsDocumentInformationItem instanceof \CfcalSasieSDK\Entity\DocumentInformation) {
                $invalidValues[] = is_object($documentInformationsDocumentInformationItem) ? get_class($documentInformationsDocumentInformationItem) : sprintf('%s(%s)', gettype($documentInformationsDocumentInformationItem), var_export($documentInformationsDocumentInformationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DocumentInformation property can only contain items of type \CfcalSasieSDK\Entity\DocumentInformation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DocumentInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\DocumentInformation[] $documentInformation
     * @return \CfcalSasieSDK\Entity\DocumentInformations
     */
    public function setDocumentInformation(array $documentInformation = array())
    {
        // validation for constraint: array
        if ('' !== ($documentInformationArrayErrorMessage = self::validateDocumentInformationForArrayConstraintsFromSetDocumentInformation($documentInformation))) {
            throw new \InvalidArgumentException($documentInformationArrayErrorMessage, __LINE__);
        }
        if (is_null($documentInformation) || (is_array($documentInformation) && empty($documentInformation))) {
            unset($this->DocumentInformation);
        } else {
            $this->DocumentInformation = $documentInformation;
        }
        return $this;
    }
    /**
     * Add item to DocumentInformation value
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\DocumentInformation $item
     * @return \CfcalSasieSDK\Entity\DocumentInformations
     */
    public function addToDocumentInformation(\CfcalSasieSDK\Entity\DocumentInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CfcalSasieSDK\Entity\DocumentInformation) {
            throw new \InvalidArgumentException(sprintf('The DocumentInformation property can only contain items of type \CfcalSasieSDK\Entity\DocumentInformation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DocumentInformation[] = $item;
        return $this;
    }
}
