<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentInformation Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DocumentInformation
 * @subpackage Structs
 */
class DocumentInformation extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The CodeDocumentInformation
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $CodeDocumentInformation;
    /**
     * The Nom
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Nom;
    /**
     * The TypeEdition
     * @var string[]
     */
    public $TypeEdition;
    /**
     * The Categorie
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Categorie;
    /**
     * Constructor method for DocumentInformation
     * @uses DocumentInformation::setCodeDocumentInformation()
     * @uses DocumentInformation::setNom()
     * @uses DocumentInformation::setTypeEdition()
     * @uses DocumentInformation::setCategorie()
     * @param string $codeDocumentInformation
     * @param string $nom
     * @param string[] $typeEdition
     * @param string $categorie
     */
    public function __construct($codeDocumentInformation = null, $nom = null, array $typeEdition = array(), $categorie = null)
    {
        $this
            ->setCodeDocumentInformation($codeDocumentInformation)
            ->setNom($nom)
            ->setTypeEdition($typeEdition)
            ->setCategorie($categorie);
    }
    /**
     * Get CodeDocumentInformation value
     * @return string|null
     */
    public function getCodeDocumentInformation()
    {
        return $this->CodeDocumentInformation;
    }
    /**
     * Set CodeDocumentInformation value
     * @param string $codeDocumentInformation
     * @return \CfcalSasieSDK\Entity\DocumentInformation
     */
    public function setCodeDocumentInformation($codeDocumentInformation = null)
    {
        // validation for constraint: string
        if (!is_null($codeDocumentInformation) && !is_string($codeDocumentInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeDocumentInformation, true), gettype($codeDocumentInformation)), __LINE__);
        }
        $this->CodeDocumentInformation = $codeDocumentInformation;
        return $this;
    }
    /**
     * Get Nom value
     * @return string|null
     */
    public function getNom()
    {
        return $this->Nom;
    }
    /**
     * Set Nom value
     * @param string $nom
     * @return \CfcalSasieSDK\Entity\DocumentInformation
     */
    public function setNom($nom = null)
    {
        // validation for constraint: string
        if (!is_null($nom) && !is_string($nom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom, true), gettype($nom)), __LINE__);
        }
        $this->Nom = $nom;
        return $this;
    }
    /**
     * Get TypeEdition value
     * @return string[]|null
     */
    public function getTypeEdition()
    {
        return $this->TypeEdition;
    }
    /**
     * This method is responsible for validating the values passed to the setTypeEdition method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTypeEdition method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeEditionForArrayConstraintsFromSetTypeEdition(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $documentInformationTypeEditionItem) {
            // validation for constraint: enumeration
            if (!\CfcalSasieSDK\Enum\TypeSaisieEnLigneEdition::valueIsValid($documentInformationTypeEditionItem)) {
                $invalidValues[] = is_object($documentInformationTypeEditionItem) ? get_class($documentInformationTypeEditionItem) : sprintf('%s(%s)', gettype($documentInformationTypeEditionItem), var_export($documentInformationTypeEditionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeSaisieEnLigneEdition', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \CfcalSasieSDK\Enum\TypeSaisieEnLigneEdition::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TypeEdition value
     * @uses \CfcalSasieSDK\Enum\TypeSaisieEnLigneEdition::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeSaisieEnLigneEdition::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $typeEdition
     * @return \CfcalSasieSDK\Entity\DocumentInformation
     */
    public function setTypeEdition(array $typeEdition = array())
    {
        // validation for constraint: list
        if ('' !== ($typeEditionArrayErrorMessage = self::validateTypeEditionForArrayConstraintsFromSetTypeEdition($typeEdition))) {
            throw new \InvalidArgumentException($typeEditionArrayErrorMessage, __LINE__);
        }
        $this->TypeEdition = is_array($typeEdition) ? implode(' ', $typeEdition) : null;
        return $this;
    }
    /**
     * Get Categorie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategorie()
    {
        return isset($this->Categorie) ? $this->Categorie : null;
    }
    /**
     * Set Categorie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categorie
     * @return \CfcalSasieSDK\Entity\DocumentInformation
     */
    public function setCategorie($categorie = null)
    {
        // validation for constraint: string
        if (!is_null($categorie) && !is_string($categorie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categorie, true), gettype($categorie)), __LINE__);
        }
        if (is_null($categorie) || (is_array($categorie) && empty($categorie))) {
            unset($this->Categorie);
        } else {
            $this->Categorie = $categorie;
        }
        return $this;
    }
}
