<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Document Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Document
 * @subpackage Structs
 */
class Document extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The Nom
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Nom;
    /**
     * The Fichier
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Fichier;
    /**
     * Constructor method for Document
     * @uses Document::setNom()
     * @uses Document::setFichier()
     * @param string $nom
     * @param string $fichier
     */
    public function __construct($nom = null, $fichier = null)
    {
        $this
            ->setNom($nom)
            ->setFichier($fichier);
    }
    /**
     * Get Nom value
     * @return string|null
     */
    public function getNom()
    {
        return $this->Nom;
    }
    /**
     * Set Nom value
     * @param string $nom
     * @return \CfcalSasieSDK\Entity\Document
     */
    public function setNom($nom = null)
    {
        // validation for constraint: string
        if (!is_null($nom) && !is_string($nom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nom, true), gettype($nom)), __LINE__);
        }
        $this->Nom = $nom;
        return $this;
    }
    /**
     * Get Fichier value
     * @return string|null
     */
    public function getFichier()
    {
        return $this->Fichier;
    }
    /**
     * Set Fichier value
     * @param string $fichier
     * @return \CfcalSasieSDK\Entity\Document
     */
    public function setFichier($fichier = null)
    {
        // validation for constraint: string
        if (!is_null($fichier) && !is_string($fichier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fichier, true), gettype($fichier)), __LINE__);
        }
        $this->Fichier = $fichier;
        return $this;
    }
}
