<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dettes Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Dettes
 * @subpackage Structs
 */
class Dettes extends AbstractStructBase
{
    /**
     * The Dette
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Dette[]
     */
    public $Dette;
    /**
     * Constructor method for Dettes
     * @uses Dettes::setDette()
     * @param \CfcalSasieSDK\Entity\Dette[] $dette
     */
    public function __construct(array $dette = array())
    {
        $this
            ->setDette($dette);
    }
    /**
     * Get Dette value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Dette[]|null
     */
    public function getDette()
    {
        return isset($this->Dette) ? $this->Dette : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDette method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDette method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDetteForArrayConstraintsFromSetDette(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dettesDetteItem) {
            // validation for constraint: itemType
            if (!$dettesDetteItem instanceof \CfcalSasieSDK\Entity\Dette) {
                $invalidValues[] = is_object($dettesDetteItem) ? get_class($dettesDetteItem) : sprintf('%s(%s)', gettype($dettesDetteItem), var_export($dettesDetteItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dette property can only contain items of type \CfcalSasieSDK\Entity\Dette, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dette value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Dette[] $dette
     * @return \CfcalSasieSDK\Entity\Dettes
     */
    public function setDette(array $dette = array())
    {
        // validation for constraint: array
        if ('' !== ($detteArrayErrorMessage = self::validateDetteForArrayConstraintsFromSetDette($dette))) {
            throw new \InvalidArgumentException($detteArrayErrorMessage, __LINE__);
        }
        if (is_null($dette) || (is_array($dette) && empty($dette))) {
            unset($this->Dette);
        } else {
            $this->Dette = $dette;
        }
        return $this;
    }
    /**
     * Add item to Dette value
     * @throws \InvalidArgumentException
     * @param \CfcalSasieSDK\Entity\Dette $item
     * @return \CfcalSasieSDK\Entity\Dettes
     */
    public function addToDette(\CfcalSasieSDK\Entity\Dette $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \CfcalSasieSDK\Entity\Dette) {
            throw new \InvalidArgumentException(sprintf('The Dette property can only contain items of type \CfcalSasieSDK\Entity\Dette, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Dette[] = $item;
        return $this;
    }
}
