<?php

namespace CfcalSasieSDK\Entity;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dette Entity
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Dette
 * @subpackage Structs
 */
class Dette extends ObjetPublicSaisieEnLigneBase
{
    /**
     * The Libelle
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Libelle;
    /**
     * The MontantRestant
     * @var float
     */
    public $MontantRestant;
    /**
     * The Nature
     * @var string
     */
    public $Nature;
    /**
     * The DateExigibilite
     * @var string
     */
    public $DateExigibilite;
    /**
     * The OrigineNature
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrigineNature;
    /**
     * The Reference
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Reference;
    /**
     * The EstInscriptionHypothecaire
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EstInscriptionHypothecaire;
    /**
     * The EstInscriptionJudiciaire
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EstInscriptionJudiciaire;
    /**
     * The VilleRemboursement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \CfcalSasieSDK\Entity\Ville
     */
    public $VilleRemboursement;
    /**
     * The Ad1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ad1;
    /**
     * The Ad2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ad2;
    /**
     * Constructor method for Dette
     * @uses Dette::setLibelle()
     * @uses Dette::setMontantRestant()
     * @uses Dette::setNature()
     * @uses Dette::setDateExigibilite()
     * @uses Dette::setOrigineNature()
     * @uses Dette::setReference()
     * @uses Dette::setEstInscriptionHypothecaire()
     * @uses Dette::setEstInscriptionJudiciaire()
     * @uses Dette::setVilleRemboursement()
     * @uses Dette::setAd1()
     * @uses Dette::setAd2()
     * @param string $libelle
     * @param float $montantRestant
     * @param string $nature
     * @param string $dateExigibilite
     * @param string $origineNature
     * @param string $reference
     * @param bool $estInscriptionHypothecaire
     * @param bool $estInscriptionJudiciaire
     * @param \CfcalSasieSDK\Entity\Ville $villeRemboursement
     * @param string $ad1
     * @param string $ad2
     */
    public function __construct($libelle = null, $montantRestant = null, $nature = null, $dateExigibilite = null, $origineNature = null, $reference = null, $estInscriptionHypothecaire = null, $estInscriptionJudiciaire = null, \CfcalSasieSDK\Entity\Ville $villeRemboursement = null, $ad1 = null, $ad2 = null)
    {
        $this
            ->setLibelle($libelle)
            ->setMontantRestant($montantRestant)
            ->setNature($nature)
            ->setDateExigibilite($dateExigibilite)
            ->setOrigineNature($origineNature)
            ->setReference($reference)
            ->setEstInscriptionHypothecaire($estInscriptionHypothecaire)
            ->setEstInscriptionJudiciaire($estInscriptionJudiciaire)
            ->setVilleRemboursement($villeRemboursement)
            ->setAd1($ad1)
            ->setAd2($ad2);
    }
    /**
     * Get Libelle value
     * @return string|null
     */
    public function getLibelle()
    {
        return $this->Libelle;
    }
    /**
     * Set Libelle value
     * @param string $libelle
     * @return \CfcalSasieSDK\Entity\Dette
     */
    public function setLibelle($libelle = null)
    {
        // validation for constraint: string
        if (!is_null($libelle) && !is_string($libelle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($libelle, true), gettype($libelle)), __LINE__);
        }
        $this->Libelle = $libelle;
        return $this;
    }
    /**
     * Get MontantRestant value
     * @return float|null
     */
    public function getMontantRestant()
    {
        return $this->MontantRestant;
    }
    /**
     * Set MontantRestant value
     * @param float $montantRestant
     * @return \CfcalSasieSDK\Entity\Dette
     */
    public function setMontantRestant($montantRestant = null)
    {
        // validation for constraint: float
        if (!is_null($montantRestant) && !(is_float($montantRestant) || is_numeric($montantRestant))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($montantRestant, true), gettype($montantRestant)), __LINE__);
        }
        $this->MontantRestant = $montantRestant;
        return $this;
    }
    /**
     * Get Nature value
     * @return string|null
     */
    public function getNature()
    {
        return $this->Nature;
    }
    /**
     * Set Nature value
     * @uses \CfcalSasieSDK\Enum\TypeNatureDette::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeNatureDette::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nature
     * @return \CfcalSasieSDK\Entity\Dette
     */
    public function setNature($nature = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeNatureDette::valueIsValid($nature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeNatureDette', is_array($nature) ? implode(', ', $nature) : var_export($nature, true), implode(', ', \CfcalSasieSDK\Enum\TypeNatureDette::getValidValues())), __LINE__);
        }
        $this->Nature = $nature;
        return $this;
    }
    /**
     * Get DateExigibilite value
     * @return string|null
     */
    public function getDateExigibilite()
    {
        return $this->DateExigibilite;
    }
    /**
     * Set DateExigibilite value
     * @param string $dateExigibilite
     * @return \CfcalSasieSDK\Entity\Dette
     */
    public function setDateExigibilite($dateExigibilite = null)
    {
        // validation for constraint: string
        if (!is_null($dateExigibilite) && !is_string($dateExigibilite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateExigibilite, true), gettype($dateExigibilite)), __LINE__);
        }
        $this->DateExigibilite = $dateExigibilite;
        return $this;
    }
    /**
     * Get OrigineNature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrigineNature()
    {
        return isset($this->OrigineNature) ? $this->OrigineNature : null;
    }
    /**
     * Set OrigineNature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \CfcalSasieSDK\Enum\TypeOrigineNatureDette::valueIsValid()
     * @uses \CfcalSasieSDK\Enum\TypeOrigineNatureDette::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $origineNature
     * @return \CfcalSasieSDK\Entity\Dette
     */
    public function setOrigineNature($origineNature = null)
    {
        // validation for constraint: enumeration
        if (!\CfcalSasieSDK\Enum\TypeOrigineNatureDette::valueIsValid($origineNature)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \CfcalSasieSDK\Enum\TypeOrigineNatureDette', is_array($origineNature) ? implode(', ', $origineNature) : var_export($origineNature, true), implode(', ', \CfcalSasieSDK\Enum\TypeOrigineNatureDette::getValidValues())), __LINE__);
        }
        if (is_null($origineNature) || (is_array($origineNature) && empty($origineNature))) {
            unset($this->OrigineNature);
        } else {
            $this->OrigineNature = $origineNature;
        }
        return $this;
    }
    /**
     * Get Reference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReference()
    {
        return isset($this->Reference) ? $this->Reference : null;
    }
    /**
     * Set Reference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reference
     * @return \CfcalSasieSDK\Entity\Dette
     */
    public function setReference($reference = null)
    {
        // validation for constraint: string
        if (!is_null($reference) && !is_string($reference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reference, true), gettype($reference)), __LINE__);
        }
        if (is_null($reference) || (is_array($reference) && empty($reference))) {
            unset($this->Reference);
        } else {
            $this->Reference = $reference;
        }
        return $this;
    }
    /**
     * Get EstInscriptionHypothecaire value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEstInscriptionHypothecaire()
    {
        return isset($this->EstInscriptionHypothecaire) ? $this->EstInscriptionHypothecaire : null;
    }
    /**
     * Set EstInscriptionHypothecaire value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $estInscriptionHypothecaire
     * @return \CfcalSasieSDK\Entity\Dette
     */
    public function setEstInscriptionHypothecaire($estInscriptionHypothecaire = null)
    {
        // validation for constraint: boolean
        if (!is_null($estInscriptionHypothecaire) && !is_bool($estInscriptionHypothecaire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estInscriptionHypothecaire, true), gettype($estInscriptionHypothecaire)), __LINE__);
        }
        if (is_null($estInscriptionHypothecaire) || (is_array($estInscriptionHypothecaire) && empty($estInscriptionHypothecaire))) {
            unset($this->EstInscriptionHypothecaire);
        } else {
            $this->EstInscriptionHypothecaire = $estInscriptionHypothecaire;
        }
        return $this;
    }
    /**
     * Get EstInscriptionJudiciaire value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEstInscriptionJudiciaire()
    {
        return isset($this->EstInscriptionJudiciaire) ? $this->EstInscriptionJudiciaire : null;
    }
    /**
     * Set EstInscriptionJudiciaire value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $estInscriptionJudiciaire
     * @return \CfcalSasieSDK\Entity\Dette
     */
    public function setEstInscriptionJudiciaire($estInscriptionJudiciaire = null)
    {
        // validation for constraint: boolean
        if (!is_null($estInscriptionJudiciaire) && !is_bool($estInscriptionJudiciaire)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($estInscriptionJudiciaire, true), gettype($estInscriptionJudiciaire)), __LINE__);
        }
        if (is_null($estInscriptionJudiciaire) || (is_array($estInscriptionJudiciaire) && empty($estInscriptionJudiciaire))) {
            unset($this->EstInscriptionJudiciaire);
        } else {
            $this->EstInscriptionJudiciaire = $estInscriptionJudiciaire;
        }
        return $this;
    }
    /**
     * Get VilleRemboursement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \CfcalSasieSDK\Entity\Ville|null
     */
    public function getVilleRemboursement()
    {
        return isset($this->VilleRemboursement) ? $this->VilleRemboursement : null;
    }
    /**
     * Set VilleRemboursement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \CfcalSasieSDK\Entity\Ville $villeRemboursement
     * @return \CfcalSasieSDK\Entity\Dette
     */
    public function setVilleRemboursement(\CfcalSasieSDK\Entity\Ville $villeRemboursement = null)
    {
        if (is_null($villeRemboursement) || (is_array($villeRemboursement) && empty($villeRemboursement))) {
            unset($this->VilleRemboursement);
        } else {
            $this->VilleRemboursement = $villeRemboursement;
        }
        return $this;
    }
    /**
     * Get Ad1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd1()
    {
        return isset($this->Ad1) ? $this->Ad1 : null;
    }
    /**
     * Set Ad1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad1
     * @return \CfcalSasieSDK\Entity\Dette
     */
    public function setAd1($ad1 = null)
    {
        // validation for constraint: string
        if (!is_null($ad1) && !is_string($ad1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad1, true), gettype($ad1)), __LINE__);
        }
        if (is_null($ad1) || (is_array($ad1) && empty($ad1))) {
            unset($this->Ad1);
        } else {
            $this->Ad1 = $ad1;
        }
        return $this;
    }
    /**
     * Get Ad2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAd2()
    {
        return isset($this->Ad2) ? $this->Ad2 : null;
    }
    /**
     * Set Ad2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ad2
     * @return \CfcalSasieSDK\Entity\Dette
     */
    public function setAd2($ad2 = null)
    {
        // validation for constraint: string
        if (!is_null($ad2) && !is_string($ad2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ad2, true), gettype($ad2)), __LINE__);
        }
        if (is_null($ad2) || (is_array($ad2) && empty($ad2))) {
            unset($this->Ad2);
        } else {
            $this->Ad2 = $ad2;
        }
        return $this;
    }
}
